from game import Game
from car_element import car_element
from multiprocessing import Process
import os

from kivy.app import App
from kivy.uix.boxlayout import BoxLayout
from kivy.properties import StringProperty
from kivy.lang import Builder
from kivy.clock import Clock

def start_game(acceleration, brakes, map_selec):
    maps = {"Rennstrecke": ["Rennstrecke_track.png", "Rennstrecke_track_colour.png"], "Testmap": ["Testmap_track.png", "Testmap_track_colour.png"]}
    graphic_dict = {"map_png": maps[map_selec][0], "screen_width": 700, "screen_height": 467, "height": 40, "distance": 200}
    car_dict = {"overlay": "car_overlay.png", "steering_wheel": car_element("steering_wheel.png", [(230,334)]), "stick_shift": car_element("stick_shift.png", [(155,145),(155,155),(165,145),(165,155)]), "acceleration": acceleration, "brakes": brakes}
    myGame = Game(graphic_dict, car_dict, maps[map_selec][1], "motorsound.wav", [6000.0, 3800.0, -89.5])
    myGame.start()

#Kivy
class StartMenu(BoxLayout):
    accel_strength = StringProperty(2)
    brake_strength = StringProperty(0.5)
    highscore = StringProperty("-")
    highscore_text = StringProperty("Highscore: - s")
    map_selec = StringProperty("Rennstrecke")
    
    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        Clock.schedule_interval(self.check_highscore, 1)

    def set_accel(self, value):
        self.accel_strength = value

    def set_brake(self, value):
        self.brake_strength = value
        
    def set_map(self, value):
        self.map_selec = value
        
    def check_highscore(self, dt): 
        with open("highscore.txt", "r") as f:
            self.highscore = f.read().strip()
            self.highscore_text = f"Highscore: {self.highscore} s"
    
    def open_instructions(self): os.startfile("instructions.pdf")

    def start_game(self):
        self.pg_proc = Process(target=start_game, args=(float(self.accel_strength), float(self.brake_strength), self.map_selec), daemon=True)
        self.pg_proc.start()

class MenuApp(App):
    def build(self):
        return StartMenu()


if __name__ == "__main__":
    MenuApp().run()