import pygame

class Road:
    def __init__(self, screen_width, screen_height):
        self.width = screen_width
        self.height = screen_height
        self.image_path = "assets/road.png"  # Make sure this file exists

        #bild laden und anpassen
        self.image = pygame.image.load(self.image_path)
        self.image = pygame.transform.scale(self.image, (self.width, self.height))

        # Scrolleffect
        self.y1 = 0
        self.y2 = -self.height
        self.speed = 200  # pixels per second

    def update(self, dt):
        # scrollt road nach unten
        self.y1 += self.speed * dt
        self.y2 += self.speed * dt

        # Reset positions to loop the road
        if self.y1 >= self.height:
            self.y1 = -self.height
        if self.y2 >= self.height:
            self.y2 = -self.height

    def draw(self, screen):
        
        screen.blit(self.image, (0, self.y1))
        screen.blit(self.image, (0, self.y2))

