/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.DefaultTransformListHandler;
import io.sf.carte.echosvg.parser.NumberParser;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.TransformListHandler;
import java.io.IOException;

public class TransformListParser
extends NumberParser {
    protected TransformListHandler transformListHandler = DefaultTransformListHandler.INSTANCE;

    public void setTransformListHandler(TransformListHandler transformListHandler) {
        this.transformListHandler = transformListHandler;
    }

    public TransformListHandler getTransformListHandler() {
        return this.transformListHandler;
    }

    @Override
    protected void doParse() throws ParseException, IOException {
        this.transformListHandler.startTransformList();
        block14: while (true) {
            try {
                while (true) {
                    this.current = this.reader.read();
                    block1 : switch (this.current) {
                        case 9: 
                        case 10: 
                        case 13: 
                        case 32: 
                        case 44: {
                            break;
                        }
                        case 109: {
                            this.parseMatrix();
                            break;
                        }
                        case 114: {
                            this.parseRotate();
                            break;
                        }
                        case 116: {
                            this.parseTranslate();
                            break;
                        }
                        case 115: {
                            this.current = this.reader.read();
                            switch (this.current) {
                                case 99: {
                                    this.parseScale();
                                    break block1;
                                }
                                case 107: {
                                    this.parseSkew();
                                    break block1;
                                }
                            }
                            this.reportUnexpectedCharacterError(this.current);
                            this.skipTransform();
                            break;
                        }
                        case -1: {
                            break block14;
                        }
                        default: {
                            this.reportUnexpectedCharacterError(this.current);
                            this.skipTransform();
                            break;
                        }
                    }
                }
            }
            catch (ParseException parseException) {
                this.errorHandler.error(parseException);
                this.skipTransform();
                continue;
            }
            break;
        }
        this.skipSpaces();
        if (this.current != -1) {
            this.reportError("end.of.stream.expected", new Object[]{this.current});
        }
        this.transformListHandler.endTransformList();
    }

    protected void parseMatrix() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportCharacterExpectedError('a', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportCharacterExpectedError('t', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 114) {
            this.reportCharacterExpectedError('r', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 105) {
            this.reportCharacterExpectedError('i', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 120) {
            this.reportCharacterExpectedError('x', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportCharacterExpectedError('(', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float f = this.parseFloat();
        this.skipCommaSpaces();
        float f2 = this.parseFloat();
        this.skipCommaSpaces();
        float f3 = this.parseFloat();
        this.skipCommaSpaces();
        float f4 = this.parseFloat();
        this.skipCommaSpaces();
        float f5 = this.parseFloat();
        this.skipCommaSpaces();
        float f6 = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportCharacterExpectedError(')', this.current);
            this.skipTransform();
            return;
        }
        this.transformListHandler.matrix(f, f2, f3, f4, f5, f6);
    }

    protected void parseRotate() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 111) {
            this.reportCharacterExpectedError('o', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportCharacterExpectedError('t', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportCharacterExpectedError('a', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportCharacterExpectedError('t', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportCharacterExpectedError('e', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportCharacterExpectedError('(', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float f = this.parseFloat();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transformListHandler.rotate(f);
                return;
            }
            case 44: {
                this.current = this.reader.read();
                this.skipSpaces();
            }
        }
        float f2 = this.parseFloat();
        this.skipCommaSpaces();
        float f3 = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportCharacterExpectedError(')', this.current);
            this.skipTransform();
            return;
        }
        this.transformListHandler.rotate(f, f2, f3);
    }

    protected void parseTranslate() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 114) {
            this.reportCharacterExpectedError('r', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportCharacterExpectedError('a', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 110) {
            this.reportCharacterExpectedError('n', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 115) {
            this.reportCharacterExpectedError('s', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 108) {
            this.reportCharacterExpectedError('l', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportCharacterExpectedError('a', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 116) {
            this.reportCharacterExpectedError('t', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportCharacterExpectedError('e', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportCharacterExpectedError('(', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float f = this.parseFloat();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transformListHandler.translate(f);
                return;
            }
            case 44: {
                this.current = this.reader.read();
                this.skipSpaces();
            }
        }
        float f2 = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportCharacterExpectedError(')', this.current);
            this.skipTransform();
            return;
        }
        this.transformListHandler.translate(f, f2);
    }

    protected void parseScale() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 97) {
            this.reportCharacterExpectedError('a', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 108) {
            this.reportCharacterExpectedError('l', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportCharacterExpectedError('e', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportCharacterExpectedError('(', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float f = this.parseFloat();
        this.skipSpaces();
        switch (this.current) {
            case 41: {
                this.transformListHandler.scale(f);
                return;
            }
            case 44: {
                this.current = this.reader.read();
                this.skipSpaces();
            }
        }
        float f2 = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportCharacterExpectedError(')', this.current);
            this.skipTransform();
            return;
        }
        this.transformListHandler.scale(f, f2);
    }

    protected void parseSkew() throws ParseException, IOException {
        this.current = this.reader.read();
        if (this.current != 101) {
            this.reportCharacterExpectedError('e', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        if (this.current != 119) {
            this.reportCharacterExpectedError('w', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        boolean bl = false;
        switch (this.current) {
            case 88: {
                bl = true;
            }
            case 89: {
                break;
            }
            default: {
                this.reportCharacterExpectedError('X', this.current);
                this.skipTransform();
                return;
            }
        }
        this.current = this.reader.read();
        this.skipSpaces();
        if (this.current != 40) {
            this.reportCharacterExpectedError('(', this.current);
            this.skipTransform();
            return;
        }
        this.current = this.reader.read();
        this.skipSpaces();
        float f = this.parseFloat();
        this.skipSpaces();
        if (this.current != 41) {
            this.reportCharacterExpectedError(')', this.current);
            this.skipTransform();
            return;
        }
        if (bl) {
            this.transformListHandler.skewX(f);
        } else {
            this.transformListHandler.skewY(f);
        }
    }

    protected void skipTransform() throws IOException {
        block3: while (true) {
            this.current = this.reader.read();
            switch (this.current) {
                case 41: {
                    break block3;
                }
                default: {
                    if (this.current != -1) continue block3;
                    break block3;
                }
            }
            break;
        }
    }
}

