/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.TransformListHandler;
import io.sf.carte.echosvg.parser.TransformListParser;
import java.awt.geom.AffineTransform;
import java.io.Reader;

public class AWTTransformProducer
implements TransformListHandler {
    protected AffineTransform affineTransform;

    public static AffineTransform createAffineTransform(Reader reader) throws ParseException {
        TransformListParser transformListParser = new TransformListParser();
        AWTTransformProducer aWTTransformProducer = new AWTTransformProducer();
        transformListParser.setTransformListHandler(aWTTransformProducer);
        transformListParser.parse(reader);
        return aWTTransformProducer.getAffineTransform();
    }

    public static AffineTransform createAffineTransform(String string) throws ParseException {
        TransformListParser transformListParser = new TransformListParser();
        AWTTransformProducer aWTTransformProducer = new AWTTransformProducer();
        transformListParser.setTransformListHandler(aWTTransformProducer);
        transformListParser.parse(string);
        return aWTTransformProducer.getAffineTransform();
    }

    public AffineTransform getAffineTransform() {
        return this.affineTransform;
    }

    @Override
    public void startTransformList() throws ParseException {
        this.affineTransform = new AffineTransform();
    }

    @Override
    public void matrix(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
        this.affineTransform.concatenate(new AffineTransform(f, f2, f3, f4, f5, f6));
    }

    @Override
    public void rotate(float f) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getRotateInstance(Math.toRadians(f)));
    }

    @Override
    public void rotate(float f, float f2, float f3) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f), f2, f3);
        this.affineTransform.concatenate(affineTransform);
    }

    @Override
    public void translate(float f) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, 0.0);
        this.affineTransform.concatenate(affineTransform);
    }

    @Override
    public void translate(float f, float f2) throws ParseException {
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(f, f2);
        this.affineTransform.concatenate(affineTransform);
    }

    @Override
    public void scale(float f) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(f, f));
    }

    @Override
    public void scale(float f, float f2) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getScaleInstance(f, f2));
    }

    @Override
    public void skewX(float f) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(Math.tan(Math.toRadians(f)), 0.0));
    }

    @Override
    public void skewY(float f) throws ParseException {
        this.affineTransform.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(Math.toRadians(f))));
    }

    @Override
    public void endTransformList() throws ParseException {
    }
}

