/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.PaintServer;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import org.w3c.dom.Element;

public class SVGSolidColorElementBridge
extends AnimatableGenericSVGBridge
implements PaintBridge {
    @Override
    public String getNamespaceURI() {
        return "http://www.w3.org/2000/svg";
    }

    @Override
    public String getLocalName() {
        return "solidColor";
    }

    @Override
    public Paint createPaint(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, float f) {
        f = SVGSolidColorElementBridge.extractOpacity(element, f, bridgeContext);
        return SVGSolidColorElementBridge.extractColor(element, f, bridgeContext);
    }

    protected static float extractOpacity(Element element, float f, BridgeContext bridgeContext) {
        String string;
        HashMap<ParsedURL, ParsedURL> hashMap = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        int n = cSSEngine.getPropertyIndex("solid-opacity");
        do {
            Value value = CSSUtilities.getComputedStyle(element, n);
            StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
            if (!styleMap.isNullCascaded(n)) {
                float f2 = PaintServer.convertOpacity(value);
                return f * f2;
            }
            string = XLinkSupport.getXLinkHref((Element)element);
            if (string.length() == 0) {
                return f;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (hashMap.containsKey(parsedURL)) {
                throw new BridgeException(bridgeContext, element, "xlink.href.circularDependencies", new Object[]{string});
            }
            hashMap.put(parsedURL, parsedURL);
        } while ((element = bridgeContext.getReferencedElement(element, string)) != null);
        return f;
    }

    protected static Color extractColor(Element element, float f, BridgeContext bridgeContext) {
        String string;
        HashMap<ParsedURL, ParsedURL> hashMap = new HashMap<ParsedURL, ParsedURL>();
        CSSEngine cSSEngine = CSSUtilities.getCSSEngine(element);
        int n = cSSEngine.getPropertyIndex("solid-color");
        do {
            Value value = CSSUtilities.getComputedStyle(element, n);
            StyleMap styleMap = ((CSSStylableElement)element).getComputedStyleMap(null);
            if (!styleMap.isNullCascaded(n)) {
                if (value.getCssValueType() == 1) {
                    return PaintServer.convertColor(value, f);
                }
                return PaintServer.convertRGBICCColor(element, value.item(0), value.item(1), f, bridgeContext);
            }
            string = XLinkSupport.getXLinkHref((Element)element);
            if (string.length() == 0) {
                return new Color(0.0f, 0.0f, 0.0f, f);
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (hashMap.containsKey(parsedURL)) {
                throw new BridgeException(bridgeContext, element, "xlink.href.circularDependencies", new Object[]{string});
            }
            hashMap.put(parsedURL, parsedURL);
        } while ((element = bridgeContext.getReferencedElement(element, string)) != null);
        return new Color(0.0f, 0.0f, 0.0f, f);
    }
}

