/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedPoints;
import io.sf.carte.echosvg.anim.dom.SVGOMPolylineElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.SVGDecoratedShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.parser.AWTPolylineProducer;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;

public class SVGPolylineElementBridge
extends SVGDecoratedShapeElementBridge {
    protected static final Shape DEFAULT_SHAPE = new GeneralPath();

    @Override
    public String getLocalName() {
        return "polyline";
    }

    @Override
    public Bridge getInstance() {
        return new SVGPolylineElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        SVGOMPolylineElement sVGOMPolylineElement = (SVGOMPolylineElement)element;
        try {
            SVGOMAnimatedPoints sVGOMAnimatedPoints = sVGOMPolylineElement.getSVGOMAnimatedPoints();
            sVGOMAnimatedPoints.check();
            SVGPointList sVGPointList = sVGOMAnimatedPoints.getAnimatedPoints();
            int n = sVGPointList.getNumberOfItems();
            if (n == 0) {
                shapeNode.setShape(DEFAULT_SHAPE);
            } else {
                AWTPolylineProducer aWTPolylineProducer = new AWTPolylineProducer();
                aWTPolylineProducer.setWindingRule(CSSUtilities.convertFillRule(element));
                aWTPolylineProducer.startPoints();
                for (int i = 0; i < n; ++i) {
                    SVGPoint sVGPoint = sVGPointList.getItem(i);
                    aWTPolylineProducer.point(sVGPoint.getX(), sVGPoint.getY());
                }
                aWTPolylineProducer.endPoints();
                shapeNode.setShape(aWTPolylineProducer.getShape());
            }
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && (string = animatedLiveAttributeValue.getLocalName()).equals("points")) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    protected void handleCSSPropertyChanged(int n) {
        switch (n) {
            case 17: {
                this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
                this.handleGeometryChanged();
                break;
            }
            default: {
                super.handleCSSPropertyChanged(n);
            }
        }
    }
}

