/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.bridge.AnimatableGenericSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.PaintBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.ViewBox;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.ext.awt.image.ConcreteComponentTransferFunction;
import io.sf.carte.echosvg.ext.awt.image.renderable.ComponentTransferRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.gvt.AbstractGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.gvt.PatternPaint;
import io.sf.carte.echosvg.gvt.RootGraphicsNode;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGPatternElementBridge
extends AnimatableGenericSVGBridge
implements PaintBridge,
ErrorConstants {
    @Override
    public String getLocalName() {
        return "pattern";
    }

    @Override
    public Paint createPaint(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, float f) {
        Object object;
        RootGraphicsNode rootGraphicsNode = (RootGraphicsNode)bridgeContext.getElementData(element);
        if (rootGraphicsNode == null) {
            rootGraphicsNode = SVGPatternElementBridge.extractPatternContent(element, bridgeContext);
            bridgeContext.setElementData(element, rootGraphicsNode);
        }
        if (rootGraphicsNode == null) {
            return null;
        }
        Rectangle2D rectangle2D = SVGUtilities.convertPatternRegion(element, element2, graphicsNode, bridgeContext);
        String string = SVGUtilities.getChainableAttributeNS(element, null, "patternTransform", bridgeContext);
        AffineTransform affineTransform = string.length() != 0 ? SVGUtilities.convertTransform(element, "patternTransform", string, bridgeContext) : new AffineTransform();
        boolean bl = CSSUtilities.convertOverflow(element);
        string = SVGUtilities.getChainableAttributeNS(element, null, "patternContentUnits", bridgeContext);
        short s = string.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(element, "patternContentUnits", string, bridgeContext);
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
        String string2 = SVGUtilities.getChainableAttributeNS(element, null, "viewBox", bridgeContext);
        if (string2.length() > 0) {
            object = SVGUtilities.getChainableAttributeNS(element, null, "preserveAspectRatio", bridgeContext);
            float f2 = (float)rectangle2D.getWidth();
            float f3 = (float)rectangle2D.getHeight();
            AffineTransform affineTransform3 = ViewBox.getPreserveAspectRatioTransform(element, string2, (String)object, f2, f3, bridgeContext);
            affineTransform2.concatenate(affineTransform3);
        } else if (s == 2) {
            object = new AffineTransform();
            Rectangle2D rectangle2D2 = graphicsNode.getGeometryBounds();
            ((AffineTransform)object).translate(rectangle2D2.getX(), rectangle2D2.getY());
            ((AffineTransform)object).scale(rectangle2D2.getWidth(), rectangle2D2.getHeight());
            affineTransform2.concatenate((AffineTransform)object);
        }
        object = new PatternGraphicsNode((GraphicsNode)rootGraphicsNode);
        object.setTransform(affineTransform2);
        if (f != 1.0f) {
            Filter filter = object.getGraphicsNodeRable(true);
            filter = new ComponentTransferRable8Bit(filter, ConcreteComponentTransferFunction.getLinearTransfer((float)f, (float)0.0f), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer(), ConcreteComponentTransferFunction.getIdentityTransfer());
            object.setFilter(filter);
        }
        return new PatternPaint((GraphicsNode)object, rectangle2D, !bl, affineTransform);
    }

    protected static RootGraphicsNode extractPatternContent(Element element, BridgeContext bridgeContext) {
        LinkedList<ParsedURL> linkedList = new LinkedList<ParsedURL>();
        RootGraphicsNode rootGraphicsNode;
        while ((rootGraphicsNode = SVGPatternElementBridge.extractLocalPatternContent(element, bridgeContext)) == null) {
            String string = XLinkSupport.getXLinkHref((Element)element);
            if (string.length() == 0) {
                return null;
            }
            SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
            ParsedURL parsedURL = new ParsedURL(sVGOMDocument.getURL(), string);
            if (!parsedURL.complete()) {
                throw new BridgeException(bridgeContext, element, "uri.malformed", new Object[]{string});
            }
            if (SVGPatternElementBridge.contains(linkedList, parsedURL)) {
                throw new BridgeException(bridgeContext, element, "xlink.href.circularDependencies", new Object[]{string});
            }
            if ((element = bridgeContext.getReferencedElement(element, string)) == null) {
                return null;
            }
            linkedList.add(parsedURL);
        }
        return rootGraphicsNode;
    }

    protected static RootGraphicsNode extractLocalPatternContent(Element element, BridgeContext bridgeContext) {
        GVTBuilder gVTBuilder = bridgeContext.getGVTBuilder();
        RootGraphicsNode rootGraphicsNode = null;
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            GraphicsNode graphicsNode;
            if (node.getNodeType() != 1 || (graphicsNode = gVTBuilder.build(bridgeContext, (Element)node)) == null) continue;
            if (rootGraphicsNode == null) {
                rootGraphicsNode = new RootGraphicsNode();
            }
            rootGraphicsNode.getChildren().add(graphicsNode);
        }
        return rootGraphicsNode;
    }

    private static boolean contains(List<ParsedURL> list, ParsedURL parsedURL) {
        for (ParsedURL parsedURL2 : list) {
            if (!parsedURL.equals((Object)parsedURL2)) continue;
            return true;
        }
        return false;
    }

    public static class PatternGraphicsNode
    extends AbstractGraphicsNode {
        GraphicsNode pcn;
        Rectangle2D pBounds;
        Rectangle2D gBounds;
        Rectangle2D sBounds;
        Shape oShape;

        public PatternGraphicsNode(GraphicsNode graphicsNode) {
            this.pcn = graphicsNode;
        }

        public void primitivePaint(Graphics2D graphics2D) {
            this.pcn.paint(graphics2D);
        }

        public Rectangle2D getPrimitiveBounds() {
            if (this.pBounds != null) {
                return this.pBounds;
            }
            this.pBounds = this.pcn.getTransformedBounds(IDENTITY);
            return this.pBounds;
        }

        public Rectangle2D getGeometryBounds() {
            if (this.gBounds != null) {
                return this.gBounds;
            }
            this.gBounds = this.pcn.getTransformedGeometryBounds(IDENTITY);
            return this.gBounds;
        }

        public Rectangle2D getSensitiveBounds() {
            if (this.sBounds != null) {
                return this.sBounds;
            }
            this.sBounds = this.pcn.getTransformedSensitiveBounds(IDENTITY);
            return this.sBounds;
        }

        public Shape getOutline() {
            if (this.oShape != null) {
                return this.oShape;
            }
            this.oShape = this.pcn.getOutline();
            AffineTransform affineTransform = this.pcn.getTransform();
            if (affineTransform != null) {
                this.oShape = affineTransform.createTransformedShape(this.oShape);
            }
            return this.oShape;
        }

        protected void invalidateGeometryCache() {
            this.pBounds = null;
            this.gBounds = null;
            this.sBounds = null;
            this.oShape = null;
            super.invalidateGeometryCache();
        }
    }
}

