/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AbstractSVGBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.dom.util.XLinkSupport;
import io.sf.carte.echosvg.ext.awt.color.NamedProfileCache;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.xmlgraphics.java2d.color.ICCColorSpaceWithIntent;
import org.apache.xmlgraphics.java2d.color.RenderingIntent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SVGColorProfileElementBridge
extends AbstractSVGBridge
implements ErrorConstants {
    public NamedProfileCache cache = new NamedProfileCache();

    @Override
    public String getLocalName() {
        return "color-profile";
    }

    public ICCColorSpaceWithIntent createICCColorSpaceWithIntent(BridgeContext bridgeContext, Element element, String string) {
        Object object;
        String string2;
        Object object2;
        ICCColorSpaceWithIntent iCCColorSpaceWithIntent = this.cache.request(string.toLowerCase());
        if (iCCColorSpaceWithIntent != null) {
            return iCCColorSpaceWithIntent;
        }
        Document document = element.getOwnerDocument();
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/svg", "color-profile");
        int n = nodeList.getLength();
        Object object3 = null;
        for (int i = 0; i < n; ++i) {
            object2 = nodeList.item(i);
            if (object2.getNodeType() != 1 || !string.equalsIgnoreCase(string2 = (object = (Element)object2).getAttributeNS(null, "name"))) continue;
            object3 = object;
        }
        if (object3 == null) {
            return null;
        }
        String string3 = XLinkSupport.getXLinkHref(object3);
        object2 = null;
        if (string3 != null) {
            ParsedURL parsedURL;
            object = object3.getBaseURI();
            string2 = null;
            if (object != null) {
                string2 = new ParsedURL((String)object);
            }
            if (!(parsedURL = new ParsedURL((ParsedURL)string2, string3)).complete()) {
                BridgeException bridgeException = new BridgeException(bridgeContext, element, "uri.malformed", new Object[]{string3});
                bridgeContext.getUserAgent().displayError(bridgeException);
                return null;
            }
            try {
                bridgeContext.getUserAgent().checkLoadExternalResource(parsedURL, (ParsedURL)string2);
                object2 = ICC_Profile.getInstance(parsedURL.openStream());
            }
            catch (IOException iOException) {
                BridgeException bridgeException = new BridgeException(bridgeContext, element, iOException, "uri.io", new Object[]{string3});
                bridgeContext.getUserAgent().displayError(bridgeException);
                return null;
            }
            catch (SecurityException securityException) {
                BridgeException bridgeException = new BridgeException(bridgeContext, element, securityException, "uri.unsecure", new Object[]{string3});
                bridgeContext.getUserAgent().displayError(bridgeException);
                return null;
            }
        }
        if (object2 == null) {
            return null;
        }
        object = SVGColorProfileElementBridge.convertIntent((Element)object3, bridgeContext);
        iCCColorSpaceWithIntent = new ICCColorSpaceWithIntent((ICC_Profile)object2, (RenderingIntent)object, string3, string);
        this.cache.put(string.toLowerCase(), iCCColorSpaceWithIntent);
        return iCCColorSpaceWithIntent;
    }

    private static RenderingIntent convertIntent(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "rendering-intent");
        if (string.length() == 0) {
            return RenderingIntent.AUTO;
        }
        if ("perceptual".equals(string)) {
            return RenderingIntent.PERCEPTUAL;
        }
        if ("auto".equals(string)) {
            return RenderingIntent.AUTO;
        }
        if ("relative-colorimetric".equals(string)) {
            return RenderingIntent.RELATIVE_COLORIMETRIC;
        }
        if ("absolute-colorimetric".equals(string)) {
            return RenderingIntent.ABSOLUTE_COLORIMETRIC;
        }
        if ("saturation".equals(string)) {
            return RenderingIntent.SATURATION;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"rendering-intent", string});
    }
}

