/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedLength;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGOMCircleElement;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGShapeElementBridge;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.gvt.ShapeNode;
import io.sf.carte.echosvg.gvt.ShapePainter;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Element;

public class SVGCircleElementBridge
extends SVGShapeElementBridge {
    @Override
    public String getLocalName() {
        return "circle";
    }

    @Override
    public Bridge getInstance() {
        return new SVGCircleElementBridge();
    }

    @Override
    protected void buildShape(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        try {
            SVGOMCircleElement sVGOMCircleElement = (SVGOMCircleElement)element;
            AbstractSVGAnimatedLength abstractSVGAnimatedLength = (AbstractSVGAnimatedLength)sVGOMCircleElement.getCx();
            float f = abstractSVGAnimatedLength.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength2 = (AbstractSVGAnimatedLength)sVGOMCircleElement.getCy();
            float f2 = abstractSVGAnimatedLength2.getCheckedValue();
            AbstractSVGAnimatedLength abstractSVGAnimatedLength3 = (AbstractSVGAnimatedLength)sVGOMCircleElement.getR();
            float f3 = abstractSVGAnimatedLength3.getCheckedValue();
            float f4 = f - f3;
            float f5 = f2 - f3;
            float f6 = f3 * 2.0f;
            shapeNode.setShape((Shape)new Ellipse2D.Float(f4, f5, f6, f6));
        }
        catch (LiveAttributeException liveAttributeException) {
            throw new BridgeException(bridgeContext, liveAttributeException);
        }
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
        String string;
        if (animatedLiveAttributeValue.getNamespaceURI() == null && ((string = animatedLiveAttributeValue.getLocalName()).equals("cx") || string.equals("cy") || string.equals("r"))) {
            this.buildShape(this.ctx, this.e, (ShapeNode)this.node);
            this.handleGeometryChanged();
            return;
        }
        super.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
    }

    @Override
    protected ShapePainter createShapePainter(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        Rectangle2D rectangle2D = shapeNode.getShape().getBounds2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            return null;
        }
        return super.createShapePainter(bridgeContext, element, shapeNode);
    }
}

