/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.anim.dom.AnimatedAttributeListener;
import io.sf.carte.echosvg.anim.dom.AnimatedLiveAttributeValue;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.dom.SVGStylableElement;
import io.sf.carte.echosvg.bridge.AbstractGraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.BaseScriptingEnvironment;
import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeEventSupport;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.BridgeExtension;
import io.sf.carte.echosvg.bridge.BridgeUpdateHandler;
import io.sf.carte.echosvg.bridge.CSSUtilities;
import io.sf.carte.echosvg.bridge.CursorManager;
import io.sf.carte.echosvg.bridge.DocumentBridge;
import io.sf.carte.echosvg.bridge.DocumentLoader;
import io.sf.carte.echosvg.bridge.ErrorConstants;
import io.sf.carte.echosvg.bridge.FocusManager;
import io.sf.carte.echosvg.bridge.FontFamilyResolver;
import io.sf.carte.echosvg.bridge.GVTBuilder;
import io.sf.carte.echosvg.bridge.GraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.InterruptedBridgeException;
import io.sf.carte.echosvg.bridge.SVGAnimationEngine;
import io.sf.carte.echosvg.bridge.SVGBridgeExtension;
import io.sf.carte.echosvg.bridge.SVGDocumentBridge;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.bridge.TextPainter;
import io.sf.carte.echosvg.bridge.URIResolver;
import io.sf.carte.echosvg.bridge.UpdateManager;
import io.sf.carte.echosvg.bridge.UserAgent;
import io.sf.carte.echosvg.bridge.UserAgentViewport;
import io.sf.carte.echosvg.bridge.Viewport;
import io.sf.carte.echosvg.bridge.svg12.SVG12BridgeContext;
import io.sf.carte.echosvg.bridge.svg12.SVG12BridgeExtension;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineEvent;
import io.sf.carte.echosvg.css.engine.CSSEngineListener;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.SystemColorSupport;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.dom.AbstractStylableDocument;
import io.sf.carte.echosvg.dom.events.NodeEventTarget;
import io.sf.carte.echosvg.dom.svg.SVGContext;
import io.sf.carte.echosvg.dom.xbl.XBLManager;
import io.sf.carte.echosvg.gvt.CompositeGraphicsNode;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.script.Interpreter;
import io.sf.carte.echosvg.script.InterpreterPool;
import io.sf.carte.echosvg.util.CleanerThread;
import io.sf.carte.echosvg.util.ParsedURL;
import java.awt.Cursor;
import java.awt.geom.Dimension2D;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.WeakHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class BridgeContext
implements ErrorConstants,
CSSContext,
Closeable {
    protected Document document;
    protected boolean isSVG12;
    protected GVTBuilder gvtBuilder;
    protected Map<String, Interpreter> interpreterMap = new HashMap<String, Interpreter>(7);
    private Map<Object, Object> fontFamilyMap;
    protected Map<Object, Viewport> viewportMap = new WeakHashMap<Object, Viewport>();
    protected List<Viewport> viewportStack = new LinkedList<Viewport>();
    protected UserAgent userAgent;
    protected Map<Node, SoftReference<GraphicsNode>> elementNodeMap;
    protected Map<GraphicsNode, SoftReference<Node>> nodeElementMap;
    protected Map<String, HashMap<String, Bridge>> namespaceURIMap;
    protected Bridge defaultBridge;
    protected Set<String> reservedNamespaceSet;
    protected Map<Node, SoftReference<Object>> elementDataMap;
    protected InterpreterPool interpreterPool;
    protected DocumentLoader documentLoader;
    protected Dimension2D documentSize;
    protected TextPainter textPainter;
    public static final int STATIC = 0;
    public static final int INTERACTIVE = 1;
    public static final int DYNAMIC = 2;
    protected int dynamicStatus = 0;
    protected UpdateManager updateManager;
    protected XBLManager xblManager;
    protected BridgeContext primaryContext;
    protected HashSet<WeakReference<BridgeContext>> childContexts = new HashSet();
    protected SVGAnimationEngine animationEngine;
    protected int animationLimitingMode;
    protected float animationLimitingAmount;
    private static InterpreterPool sharedPool = new InterpreterPool();
    protected Set<EventListenerMememto> eventListenerSet = new HashSet<EventListenerMememto>();
    protected EventListener domCharacterDataModifiedEventListener;
    protected EventListener domAttrModifiedEventListener;
    protected EventListener domNodeInsertedEventListener;
    protected EventListener domNodeRemovedEventListener;
    protected CSSEngineListener cssPropertiesChangedListener;
    protected AnimatedAttributeListener animatedAttributeListener;
    protected FocusManager focusManager;
    protected CursorManager cursorManager = new CursorManager(this);
    protected List<BridgeExtension> extensions = null;
    protected static List<BridgeExtension> globalExtensions = null;

    protected BridgeContext() {
    }

    public final FontFamilyResolver getFontFamilyResolver() {
        return this.userAgent.getFontFamilyResolver();
    }

    public BridgeContext(UserAgent userAgent) {
        this(userAgent, sharedPool, new DocumentLoader(userAgent));
    }

    public BridgeContext(UserAgent userAgent, DocumentLoader documentLoader) {
        this(userAgent, sharedPool, documentLoader);
    }

    public BridgeContext(UserAgent userAgent, InterpreterPool interpreterPool, DocumentLoader documentLoader) {
        this.userAgent = userAgent;
        this.viewportMap.put(userAgent, new UserAgentViewport(userAgent));
        this.interpreterPool = interpreterPool;
        this.documentLoader = documentLoader;
    }

    @Override
    public void close() {
        if (this.primaryContext != null) {
            this.dispose();
        }
    }

    public BridgeContext createSubBridgeContext(SVGOMDocument sVGOMDocument) {
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        if (cSSEngine != null) {
            BridgeContext bridgeContext = (BridgeContext)sVGOMDocument.getCSSEngine().getCSSContext();
            return bridgeContext;
        }
        BridgeContext bridgeContext = this.createBridgeContext(sVGOMDocument);
        bridgeContext.primaryContext = this.primaryContext != null ? this.primaryContext : this;
        bridgeContext.primaryContext.childContexts.add(new WeakReference<BridgeContext>(bridgeContext));
        bridgeContext.dynamicStatus = this.dynamicStatus;
        bridgeContext.setGVTBuilder(this.getGVTBuilder());
        bridgeContext.setTextPainter(this.getTextPainter());
        bridgeContext.setDocument((Document)sVGOMDocument);
        bridgeContext.initializeDocument((Document)sVGOMDocument);
        if (this.isInteractive()) {
            bridgeContext.addUIEventListeners((Document)sVGOMDocument);
        }
        return bridgeContext;
    }

    public BridgeContext createBridgeContext(SVGOMDocument sVGOMDocument) {
        if (sVGOMDocument.isSVG12()) {
            return new SVG12BridgeContext(this.getUserAgent(), this.getDocumentLoader());
        }
        return new BridgeContext(this.getUserAgent(), this.getDocumentLoader());
    }

    protected void initializeDocument(Document document) {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        if (cSSEngine == null) {
            SVGDOMImplementation sVGDOMImplementation = (SVGDOMImplementation)sVGOMDocument.getImplementation();
            cSSEngine = sVGDOMImplementation.createCSSEngine((AbstractStylableDocument)sVGOMDocument, (CSSContext)this);
            cSSEngine.setCSSEngineUserAgent((CSSEngineUserAgent)new CSSEngineUserAgentWrapper(this.userAgent));
            sVGOMDocument.setCSSEngine(cSSEngine);
            cSSEngine.setMedia(this.userAgent.getMedia());
            String string = this.userAgent.getUserStyleSheetURI();
            if (string != null) {
                try {
                    ParsedURL parsedURL = new ParsedURL(string);
                    cSSEngine.setUserAgentStyleSheet(cSSEngine.parseStyleSheet(parsedURL, "all"));
                }
                catch (Exception exception) {
                    this.userAgent.displayError(exception);
                }
            }
            cSSEngine.setAlternateStyleSheet(this.userAgent.getAlternateStyleSheet());
        }
    }

    public CSSEngine getCSSEngineForElement(Element element) {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)element.getOwnerDocument();
        return sVGOMDocument.getCSSEngine();
    }

    public void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter;
    }

    public TextPainter getTextPainter() {
        return this.textPainter;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void setDocument(Document document) {
        if (this.document != document) {
            this.fontFamilyMap = null;
        }
        this.document = document;
        this.isSVG12 = ((SVGOMDocument)document).isSVG12();
        this.registerSVGBridges();
    }

    public Map<Object, Object> getFontFamilyMap() {
        if (this.fontFamilyMap == null) {
            this.fontFamilyMap = new HashMap<Object, Object>();
        }
        return this.fontFamilyMap;
    }

    protected void setFontFamilyMap(Map<Object, Object> map) {
        this.fontFamilyMap = map;
    }

    public void setElementData(Node node, Object object) {
        if (this.elementDataMap == null) {
            this.elementDataMap = new WeakHashMap<Node, SoftReference<Object>>();
        }
        this.elementDataMap.put(node, new SoftReference<Object>(object));
    }

    public Object getElementData(Node node) {
        if (this.elementDataMap == null) {
            return null;
        }
        SoftReference<Object> softReference = this.elementDataMap.get(node);
        if (softReference == null) {
            return null;
        }
        Object object = softReference.get();
        if (object == null) {
            this.elementDataMap.remove(node);
        }
        return object;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public GVTBuilder getGVTBuilder() {
        return this.gvtBuilder;
    }

    protected void setGVTBuilder(GVTBuilder gVTBuilder) {
        this.gvtBuilder = gVTBuilder;
    }

    public InterpreterPool getInterpreterPool() {
        return this.interpreterPool;
    }

    public FocusManager getFocusManager() {
        return this.focusManager;
    }

    public CursorManager getCursorManager() {
        return this.cursorManager;
    }

    protected void setInterpreterPool(InterpreterPool interpreterPool) {
        this.interpreterPool = interpreterPool;
    }

    public Interpreter getInterpreter(String string) {
        Interpreter interpreter;
        block6: {
            if (this.document == null) {
                throw new RuntimeException("Unknown document");
            }
            interpreter = this.interpreterMap.get(string);
            if (interpreter == null) {
                try {
                    String[] stringArray;
                    interpreter = this.interpreterPool.createInterpreter(this.document, string, null);
                    for (String string2 : stringArray = interpreter.getMimeTypes()) {
                        this.interpreterMap.put(string2, interpreter);
                    }
                }
                catch (Exception exception) {
                    if (this.userAgent == null) break block6;
                    this.userAgent.displayError(exception);
                    return null;
                }
            }
        }
        if (interpreter == null && this.userAgent != null) {
            this.userAgent.displayError(new Exception("Unknown language: " + string));
        }
        return interpreter;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    protected void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }

    public Dimension2D getDocumentSize() {
        return this.documentSize;
    }

    protected void setDocumentSize(Dimension2D dimension2D) {
        this.documentSize = dimension2D;
    }

    public boolean isDynamic() {
        return this.dynamicStatus == 2;
    }

    public boolean isInteractive() {
        return this.dynamicStatus != 0;
    }

    public void setDynamicState(int n) {
        this.dynamicStatus = n;
    }

    public void setDynamic(boolean bl) {
        if (bl) {
            this.setDynamicState(2);
        } else {
            this.setDynamicState(0);
        }
    }

    public void setInteractive(boolean bl) {
        if (bl) {
            this.setDynamicState(1);
        } else {
            this.setDynamicState(0);
        }
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }

    protected void setUpdateManager(UpdateManager updateManager) {
        this.updateManager = updateManager;
    }

    protected void setUpdateManager(BridgeContext bridgeContext, UpdateManager updateManager) {
        bridgeContext.setUpdateManager(updateManager);
    }

    protected void setXBLManager(BridgeContext bridgeContext, XBLManager xBLManager) {
        bridgeContext.xblManager = xBLManager;
    }

    public boolean isSVG12() {
        return this.isSVG12;
    }

    public BridgeContext getPrimaryBridgeContext() {
        if (this.primaryContext != null) {
            return this.primaryContext;
        }
        return this;
    }

    public BridgeContext[] getChildContexts() {
        BridgeContext[] bridgeContextArray = new BridgeContext[this.childContexts.size()];
        Iterator<WeakReference<BridgeContext>> iterator = this.childContexts.iterator();
        for (int i = 0; i < bridgeContextArray.length; ++i) {
            WeakReference<BridgeContext> weakReference = iterator.next();
            bridgeContextArray[i] = (BridgeContext)weakReference.get();
        }
        return bridgeContextArray;
    }

    public SVGAnimationEngine getAnimationEngine() {
        if (this.animationEngine == null) {
            this.animationEngine = new SVGAnimationEngine(this.document, this);
            this.setAnimationLimitingMode();
        }
        return this.animationEngine;
    }

    public URIResolver createURIResolver(SVGDocument sVGDocument, DocumentLoader documentLoader) {
        return new URIResolver(sVGDocument, documentLoader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node getReferencedNode(Element element, String string) {
        try {
            SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
            URIResolver uRIResolver = this.createURIResolver(sVGDocument, this.documentLoader);
            Node node = uRIResolver.getNode(string, element);
            if (node == null) {
                BridgeException bridgeException = new BridgeException(this, element, "uri.badTarget", new Object[]{string});
                if (this.userAgent == null) throw bridgeException;
                this.userAgent.displayError(bridgeException);
                return node;
            } else {
                SVGOMDocument sVGOMDocument = (SVGOMDocument)(node.getNodeType() == 9 ? node : node.getOwnerDocument());
                if (sVGOMDocument == sVGDocument) return node;
                this.createSubBridgeContext(sVGOMDocument);
            }
            return node;
        }
        catch (MalformedURLException malformedURLException) {
            throw new BridgeException(this, element, malformedURLException, "uri.malformed", new Object[]{string});
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedBridgeException();
        }
        catch (IOException iOException) {
            throw new BridgeException(this, element, iOException, "uri.io", new Object[]{string});
        }
        catch (SecurityException securityException) {
            throw new BridgeException(this, element, securityException, "uri.unsecure", new Object[]{string});
        }
    }

    public Element getReferencedElement(Element element, String string) {
        Node node = this.getReferencedNode(element, string);
        if (node != null && node.getNodeType() != 1) {
            throw new BridgeException(this, element, "uri.referenceDocument", new Object[]{string});
        }
        return (Element)node;
    }

    public Viewport getViewport(Element element) {
        if (this.viewportStack != null) {
            if (this.viewportStack.size() == 0) {
                return this.viewportMap.get(this.userAgent);
            }
            return this.viewportStack.get(0);
        }
        element = SVGUtilities.getParentElement(element);
        while (element != null) {
            Viewport viewport = this.viewportMap.get(element);
            if (viewport != null) {
                return viewport;
            }
            element = SVGUtilities.getParentElement(element);
        }
        return this.viewportMap.get(this.userAgent);
    }

    public void openViewport(Element element, Viewport viewport) {
        this.viewportMap.put(element, viewport);
        if (this.viewportStack == null) {
            this.viewportStack = new LinkedList<Viewport>();
        }
        this.viewportStack.add(0, viewport);
    }

    public void removeViewport(Element element) {
        this.viewportMap.remove(element);
    }

    public void closeViewport(Element element) {
        this.viewportStack.remove(0);
        if (this.viewportStack.size() == 0) {
            this.viewportStack = null;
        }
    }

    public void bind(Node node, GraphicsNode graphicsNode) {
        if (this.elementNodeMap == null) {
            this.elementNodeMap = new WeakHashMap<Node, SoftReference<GraphicsNode>>();
            this.nodeElementMap = new WeakHashMap<GraphicsNode, SoftReference<Node>>();
        }
        this.elementNodeMap.put(node, new SoftReference<GraphicsNode>(graphicsNode));
        this.nodeElementMap.put(graphicsNode, new SoftReference<Node>(node));
    }

    public void unbind(Node node) {
        if (this.elementNodeMap == null) {
            return;
        }
        GraphicsNode graphicsNode = null;
        SoftReference<GraphicsNode> softReference = this.elementNodeMap.get(node);
        if (softReference != null) {
            graphicsNode = softReference.get();
        }
        this.elementNodeMap.remove(node);
        if (graphicsNode != null) {
            this.nodeElementMap.remove(graphicsNode);
        }
    }

    public GraphicsNode getGraphicsNode(Node node) {
        SoftReference<GraphicsNode> softReference;
        if (this.elementNodeMap != null && (softReference = this.elementNodeMap.get(node)) != null) {
            return softReference.get();
        }
        return null;
    }

    public Element getElement(GraphicsNode graphicsNode) {
        Node node;
        SoftReference<Node> softReference;
        if (this.nodeElementMap != null && (softReference = this.nodeElementMap.get(graphicsNode)) != null && (node = softReference.get()) != null && node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    public boolean hasGraphicsNodeBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return false;
        }
        String string = element.getLocalName();
        String string2 = element.getNamespaceURI();
        string2 = string2 == null ? "" : string2;
        HashMap<String, Bridge> hashMap = this.namespaceURIMap.get(string2);
        if (hashMap == null) {
            return false;
        }
        return hashMap.get(string) instanceof GraphicsNodeBridge;
    }

    public DocumentBridge getDocumentBridge() {
        return new SVGDocumentBridge();
    }

    public Bridge getBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return null;
        }
        String string = element.getLocalName();
        String string2 = element.getNamespaceURI();
        string2 = string2 == null ? "" : string2;
        return this.getBridge(string2, string);
    }

    public Bridge getBridge(String string, String string2) {
        HashMap<String, Bridge> hashMap;
        Bridge bridge = null;
        if (this.namespaceURIMap != null && (hashMap = this.namespaceURIMap.get(string)) != null) {
            bridge = hashMap.get(string2);
        }
        if (!(bridge != null || this.reservedNamespaceSet != null && this.reservedNamespaceSet.contains(string))) {
            bridge = this.defaultBridge;
        }
        if (this.isDynamic()) {
            return bridge == null ? null : bridge.getInstance();
        }
        return bridge;
    }

    public void putBridge(String string, String string2, Bridge bridge) {
        HashMap<String, Bridge> hashMap;
        String string3 = bridge.getNamespaceURI();
        string3 = string3 == null ? "" : string3;
        String string4 = string = string == null ? "" : string;
        if (!string.equals(string3) || !string2.equals(bridge.getLocalName())) {
            throw new RuntimeException("Invalid Bridge: " + string + "/" + bridge.getNamespaceURI() + " " + string2 + "/" + bridge.getLocalName() + " " + bridge.getClass());
        }
        if (this.namespaceURIMap == null) {
            this.namespaceURIMap = new HashMap<String, HashMap<String, Bridge>>();
        }
        if ((hashMap = this.namespaceURIMap.get(string)) == null) {
            hashMap = new HashMap();
            this.namespaceURIMap.put(string, hashMap);
        }
        hashMap.put(string2, bridge);
    }

    public void putBridge(Bridge bridge) {
        this.putBridge(bridge.getNamespaceURI(), bridge.getLocalName(), bridge);
    }

    public void removeBridge(String string, String string2) {
        if (this.namespaceURIMap == null) {
            return;
        }
        Map map = this.namespaceURIMap.get(string = string == null ? "" : string);
        if (map != null) {
            map.remove(string2);
            if (map.isEmpty()) {
                this.namespaceURIMap.remove(string);
                if (this.namespaceURIMap.isEmpty()) {
                    this.namespaceURIMap = null;
                }
            }
        }
    }

    public void setDefaultBridge(Bridge bridge) {
        this.defaultBridge = bridge;
    }

    public void putReservedNamespaceURI(String string) {
        if (string == null) {
            string = "";
        }
        if (this.reservedNamespaceSet == null) {
            this.reservedNamespaceSet = new HashSet<String>();
        }
        this.reservedNamespaceSet.add(string);
    }

    public void removeReservedNamespaceURI(String string) {
        if (string == null) {
            string = "";
        }
        if (this.reservedNamespaceSet != null) {
            this.reservedNamespaceSet.remove(string);
            if (this.reservedNamespaceSet.isEmpty()) {
                this.reservedNamespaceSet = null;
            }
        }
    }

    public void addUIEventListeners(Document document) {
        NodeEventTarget nodeEventTarget = (NodeEventTarget)document.getDocumentElement();
        DOMMouseOverEventListener dOMMouseOverEventListener = new DOMMouseOverEventListener();
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseover", (EventListener)dOMMouseOverEventListener, true, null);
        this.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseover", dOMMouseOverEventListener, true);
        DOMMouseOutEventListener dOMMouseOutEventListener = new DOMMouseOutEventListener();
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "mouseout", (EventListener)dOMMouseOutEventListener, true, null);
        this.storeEventListenerNS((EventTarget)nodeEventTarget, "http://www.w3.org/2001/xml-events", "mouseout", dOMMouseOutEventListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUIEventListeners(Document document) {
        EventTarget eventTarget = (EventTarget)((Object)document.getDocumentElement());
        Set<EventListenerMememto> set = this.eventListenerSet;
        synchronized (set) {
            for (EventListenerMememto eventListenerMememto : this.eventListenerSet) {
                NodeEventTarget nodeEventTarget = eventListenerMememto.getTarget();
                if (nodeEventTarget != eventTarget) continue;
                EventListener eventListener = eventListenerMememto.getListener();
                boolean bl = eventListenerMememto.getUseCapture();
                String string = eventListenerMememto.getEventType();
                boolean bl2 = eventListenerMememto.getNamespaced();
                if (nodeEventTarget == null || eventListener == null || string == null) continue;
                if (bl2) {
                    String string2 = eventListenerMememto.getNamespaceURI();
                    nodeEventTarget.removeEventListenerNS(string2, string, eventListener, bl);
                    continue;
                }
                nodeEventTarget.removeEventListener(string, eventListener, bl);
            }
        }
    }

    public void addDOMListeners() {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.document;
        this.domAttrModifiedEventListener = new DOMAttrModifiedEventListener();
        sVGOMDocument.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedEventListener, true, null);
        this.domNodeInsertedEventListener = new DOMNodeInsertedEventListener();
        sVGOMDocument.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedEventListener, true, null);
        this.domNodeRemovedEventListener = new DOMNodeRemovedEventListener();
        sVGOMDocument.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedEventListener, true, null);
        this.domCharacterDataModifiedEventListener = new DOMCharacterDataModifiedEventListener();
        sVGOMDocument.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.domCharacterDataModifiedEventListener, true, null);
        this.animatedAttributeListener = new AnimatedAttrListener();
        sVGOMDocument.addAnimatedAttributeListener(this.animatedAttributeListener);
        this.focusManager = new FocusManager(this.document);
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        this.cssPropertiesChangedListener = new CSSPropertiesChangedListener();
        cSSEngine.addCSSEngineListener(this.cssPropertiesChangedListener);
    }

    protected void removeDOMListeners() {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.document;
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedEventListener, true);
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedEventListener, true);
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        sVGOMDocument.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.domCharacterDataModifiedEventListener, true);
        sVGOMDocument.removeAnimatedAttributeListener(this.animatedAttributeListener);
        CSSEngine cSSEngine = sVGOMDocument.getCSSEngine();
        if (cSSEngine != null) {
            cSSEngine.removeCSSEngineListener(this.cssPropertiesChangedListener);
            cSSEngine.dispose();
            sVGOMDocument.setCSSEngine(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEventListener(EventTarget eventTarget, String string, EventListener eventListener, boolean bl) {
        Set<EventListenerMememto> set = this.eventListenerSet;
        synchronized (set) {
            this.eventListenerSet.add(new EventListenerMememto(eventTarget, string, eventListener, bl, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEventListenerNS(EventTarget eventTarget, String string, String string2, EventListener eventListener, boolean bl) {
        Set<EventListenerMememto> set = this.eventListenerSet;
        synchronized (set) {
            this.eventListenerSet.add(new EventListenerMememto(eventTarget, string, string2, eventListener, bl, this));
        }
    }

    public void addGVTListener(Document document) {
        BridgeEventSupport.addGVTListener(this, document);
    }

    protected void clearChildContexts() {
        this.childContexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.clearChildContexts();
        Set<EventListenerMememto> set = this.eventListenerSet;
        synchronized (set) {
            for (EventListenerMememto eventListenerMememto : this.eventListenerSet) {
                NodeEventTarget nodeEventTarget = eventListenerMememto.getTarget();
                EventListener eventListener = eventListenerMememto.getListener();
                boolean bl = eventListenerMememto.getUseCapture();
                String string = eventListenerMememto.getEventType();
                boolean bl2 = eventListenerMememto.getNamespaced();
                if (nodeEventTarget == null || eventListener == null || string == null) continue;
                if (bl2) {
                    String string2 = eventListenerMememto.getNamespaceURI();
                    nodeEventTarget.removeEventListenerNS(string2, string, eventListener, bl);
                    continue;
                }
                nodeEventTarget.removeEventListener(string, eventListener, bl);
            }
        }
        if (this.document != null) {
            this.removeDOMListeners();
            AbstractGraphicsNodeBridge.disposeTree(this.document);
        }
        if (this.animationEngine != null) {
            this.animationEngine.dispose();
            this.animationEngine = null;
        }
        for (Interpreter interpreter : this.interpreterMap.values()) {
            if (interpreter == null) continue;
            interpreter.dispose();
        }
        this.interpreterMap.clear();
        if (this.focusManager != null) {
            this.focusManager.dispose();
        }
        if (this.elementDataMap != null) {
            this.elementDataMap.clear();
        }
        if (this.nodeElementMap != null) {
            this.nodeElementMap.clear();
        }
        if (this.elementNodeMap != null) {
            this.elementNodeMap.clear();
        }
    }

    protected static SVGContext getSVGContext(Node node) {
        if (node instanceof SVGOMElement) {
            return ((SVGOMElement)node).getSVGContext();
        }
        if (node instanceof SVGOMDocument) {
            return ((SVGOMDocument)node).getSVGContext();
        }
        return null;
    }

    protected static BridgeUpdateHandler getBridgeUpdateHandler(Node node) {
        SVGContext sVGContext = BridgeContext.getSVGContext(node);
        return sVGContext == null ? null : (BridgeUpdateHandler)sVGContext;
    }

    public Value getSystemColor(String string) {
        return SystemColorSupport.getSystemColor((String)string);
    }

    public Value getDefaultFontFamily() {
        SVGOMDocument sVGOMDocument = (SVGOMDocument)this.document;
        SVGStylableElement sVGStylableElement = (SVGStylableElement)sVGOMDocument.getRootElement();
        String string = this.userAgent.getDefaultFontFamily();
        return sVGOMDocument.getCSSEngine().parsePropertyValue((CSSStylableElement)sVGStylableElement, "font-family", string);
    }

    public float getLighterFontWeight(float f) {
        return this.userAgent.getLighterFontWeight(f);
    }

    public float getBolderFontWeight(float f) {
        return this.userAgent.getBolderFontWeight(f);
    }

    public float getPixelUnitToMillimeter() {
        return this.userAgent.getPixelUnitToMillimeter();
    }

    public float getMediumFontSize() {
        return this.userAgent.getMediumFontSize();
    }

    public float getBlockWidth(Element element) {
        return this.getViewport(element).getWidth();
    }

    public float getBlockHeight(Element element) {
        return this.getViewport(element).getHeight();
    }

    public void checkLoadExternalResource(ParsedURL parsedURL, ParsedURL parsedURL2) throws SecurityException {
        this.userAgent.checkLoadExternalResource(parsedURL, parsedURL2);
    }

    public boolean isDynamicDocument(Document document) {
        return BaseScriptingEnvironment.isDynamicDocument(this, document);
    }

    public boolean isInteractiveDocument(Document document) {
        SVGSVGElement sVGSVGElement = ((SVGDocument)document).getRootElement();
        if (!"http://www.w3.org/2000/svg".equals(sVGSVGElement.getNamespaceURI())) {
            return false;
        }
        return this.checkInteractiveElement((Element)sVGSVGElement);
    }

    public boolean checkInteractiveElement(Element element) {
        return this.checkInteractiveElement((SVGDocument)element.getOwnerDocument(), element);
    }

    public boolean checkInteractiveElement(SVGDocument sVGDocument, Element element) {
        String string = element.getLocalName();
        if ("a".equals(string)) {
            return true;
        }
        if ("title".equals(string)) {
            return element.getParentNode() != sVGDocument.getRootElement();
        }
        if ("desc".equals(string)) {
            return element.getParentNode() != sVGDocument.getRootElement();
        }
        if ("cursor".equals(string)) {
            return true;
        }
        if (element.getAttribute("cursor").length() > 0) {
            return true;
        }
        String string2 = "http://www.w3.org/2000/svg";
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals((element2 = (Element)node).getNamespaceURI()) || !this.checkInteractiveElement(element2)) continue;
            return true;
        }
        return false;
    }

    public void setAnimationLimitingNone() {
        this.animationLimitingMode = 0;
        if (this.animationEngine != null) {
            this.setAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingCPU(float f) {
        this.animationLimitingMode = 1;
        this.animationLimitingAmount = f;
        if (this.animationEngine != null) {
            this.setAnimationLimitingMode();
        }
    }

    public void setAnimationLimitingFPS(float f) {
        this.animationLimitingMode = 2;
        this.animationLimitingAmount = f;
        if (this.animationEngine != null) {
            this.setAnimationLimitingMode();
        }
    }

    protected void setAnimationLimitingMode() {
        switch (this.animationLimitingMode) {
            case 0: {
                this.animationEngine.setAnimationLimitingNone();
                break;
            }
            case 1: {
                this.animationEngine.setAnimationLimitingCPU(this.animationLimitingAmount);
                break;
            }
            case 2: {
                this.animationEngine.setAnimationLimitingFPS(this.animationLimitingAmount);
            }
        }
    }

    public void registerSVGBridges() {
        UserAgent userAgent = this.getUserAgent();
        List<BridgeExtension> list = this.getBridgeExtensions(this.document);
        for (BridgeExtension bridgeExtension : list) {
            bridgeExtension.registerTags(this);
            userAgent.registerExtension(bridgeExtension);
        }
    }

    public List<BridgeExtension> getBridgeExtensions(Document document) {
        block1: {
            BridgeExtension bridgeExtension;
            SVGSVGElement sVGSVGElement = ((SVGOMDocument)document).getRootElement();
            String string = sVGSVGElement.getAttributeNS(null, "version");
            SVGBridgeExtension sVGBridgeExtension = string.length() == 0 || string.equals("1.0") || string.equals("1.1") ? new SVGBridgeExtension() : new SVG12BridgeExtension();
            float f = sVGBridgeExtension.getPriority();
            this.extensions = new LinkedList<BridgeExtension>(BridgeContext.getGlobalBridgeExtensions());
            ListIterator<BridgeExtension> listIterator = this.extensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(sVGBridgeExtension);
                break block1;
            } while (!((bridgeExtension = listIterator.next()).getPriority() > f));
            listIterator.previous();
            listIterator.add(sVGBridgeExtension);
        }
        return this.extensions;
    }

    public static synchronized List<BridgeExtension> getGlobalBridgeExtensions() {
        if (globalExtensions != null) {
            return globalExtensions;
        }
        globalExtensions = new LinkedList<BridgeExtension>();
        ServiceLoader<BridgeExtension> serviceLoader = ServiceLoader.load(BridgeExtension.class);
        block0: for (BridgeExtension bridgeExtension : serviceLoader) {
            BridgeExtension bridgeExtension2;
            float f = bridgeExtension.getPriority();
            ListIterator<BridgeExtension> listIterator = globalExtensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(bridgeExtension);
                continue block0;
            } while (!((bridgeExtension2 = listIterator.next()).getPriority() > f));
            listIterator.previous();
            listIterator.add(bridgeExtension);
        }
        return globalExtensions;
    }

    protected class AnimatedAttrListener
    implements AnimatedAttributeListener {
        public void animatedAttributeChanged(Element element, AnimatedLiveAttributeValue animatedLiveAttributeValue) {
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(element);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleAnimatedAttributeChanged(animatedLiveAttributeValue);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }

        public void otherAnimationChanged(Element element, String string) {
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(element);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleOtherAnimationChanged(string);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    public static class CSSEngineUserAgentWrapper
    implements CSSEngineUserAgent {
        UserAgent ua;

        CSSEngineUserAgentWrapper(UserAgent userAgent) {
            this.ua = userAgent;
        }

        public void displayError(Exception exception) {
            this.ua.displayError(exception);
        }

        public void displayMessage(String string) {
            this.ua.displayMessage(string);
        }
    }

    protected class CSSPropertiesChangedListener
    implements CSSEngineListener {
        public void propertiesChanged(CSSEngineEvent cSSEngineEvent) {
            Element element = cSSEngineEvent.getElement();
            SVGContext sVGContext = BridgeContext.getSVGContext(element);
            if (sVGContext == null) {
                int[] nArray;
                GraphicsNode graphicsNode = BridgeContext.this.getGraphicsNode(element.getParentNode());
                if (graphicsNode == null || !(graphicsNode instanceof CompositeGraphicsNode)) {
                    return;
                }
                CompositeGraphicsNode compositeGraphicsNode = (CompositeGraphicsNode)graphicsNode;
                for (int n : nArray = cSSEngineEvent.getProperties()) {
                    Element element2;
                    GraphicsNode graphicsNode2;
                    GVTBuilder gVTBuilder;
                    GraphicsNode graphicsNode3;
                    if (n != 12) continue;
                    if (!CSSUtilities.convertDisplay(element) || (graphicsNode3 = (gVTBuilder = BridgeContext.this.getGVTBuilder()).build(BridgeContext.this, element)) == null) break;
                    int n2 = -1;
                    for (Node node = element.getPreviousSibling(); node != null && (node.getNodeType() != 1 || (graphicsNode2 = BridgeContext.this.getGraphicsNode(element2 = (Element)node)) == null || (n2 = compositeGraphicsNode.indexOf((Object)graphicsNode2)) == -1); node = node.getPreviousSibling()) {
                    }
                    compositeGraphicsNode.add(++n2, graphicsNode3);
                    break;
                }
            }
            if (sVGContext != null && sVGContext instanceof BridgeUpdateHandler) {
                ((BridgeUpdateHandler)sVGContext).handleCSSEngineEvent(cSSEngineEvent);
            }
        }
    }

    protected class DOMAttrModifiedEventListener
    implements EventListener {
        @Override
        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(node);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMAttrModifiedEvent((MutationEvent)event);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected class DOMCharacterDataModifiedEventListener
    implements EventListener {
        @Override
        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            while (node != null && !(node instanceof SVGOMElement)) {
                node = (Node)((AbstractNode)node).getParentNodeEventTarget();
            }
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(node);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMCharacterDataModified((MutationEvent)event);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected class DOMMouseOutEventListener
    implements EventListener {
        @Override
        public void handleEvent(Event event) {
            MouseEvent mouseEvent = (MouseEvent)event;
            Element element = (Element)((Object)mouseEvent.getRelatedTarget());
            Cursor cursor = CursorManager.DEFAULT_CURSOR;
            if (element != null) {
                cursor = CSSUtilities.convertCursor(element, BridgeContext.this);
            }
            if (cursor == null) {
                cursor = CursorManager.DEFAULT_CURSOR;
            }
            BridgeContext.this.userAgent.setSVGCursor(cursor);
        }
    }

    protected class DOMMouseOverEventListener
    implements EventListener {
        @Override
        public void handleEvent(Event event) {
            Element element = (Element)((Object)event.getTarget());
            Cursor cursor = CSSUtilities.convertCursor(element, BridgeContext.this);
            if (cursor != null) {
                BridgeContext.this.userAgent.setSVGCursor(cursor);
            }
        }
    }

    protected class DOMNodeInsertedEventListener
    implements EventListener {
        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(mutationEvent.getRelatedNode());
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMNodeInsertedEvent(mutationEvent);
                }
                catch (InterruptedBridgeException interruptedBridgeException) {
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected class DOMNodeRemovedEventListener
    implements EventListener {
        @Override
        public void handleEvent(Event event) {
            Node node = (Node)((Object)event.getTarget());
            BridgeUpdateHandler bridgeUpdateHandler = BridgeContext.getBridgeUpdateHandler(node);
            if (bridgeUpdateHandler != null) {
                try {
                    bridgeUpdateHandler.handleDOMNodeRemovedEvent((MutationEvent)event);
                }
                catch (Exception exception) {
                    BridgeContext.this.userAgent.displayError(exception);
                }
            }
        }
    }

    protected static class EventListenerMememto {
        public SoftReference<EventTarget> target;
        public SoftReference<EventListener> listener;
        public boolean useCapture;
        public String namespaceURI;
        public String eventType;
        public boolean namespaced;

        public EventListenerMememto(EventTarget eventTarget, String string, EventListener eventListener, boolean bl, BridgeContext bridgeContext) {
            Set<EventListenerMememto> set = bridgeContext.eventListenerSet;
            this.target = new SoftReferenceMememto<EventTarget>(eventTarget, this, set);
            this.listener = new SoftReferenceMememto<EventListener>(eventListener, this, set);
            this.eventType = string;
            this.useCapture = bl;
        }

        public EventListenerMememto(EventTarget eventTarget, String string, String string2, EventListener eventListener, boolean bl, BridgeContext bridgeContext) {
            this(eventTarget, string2, eventListener, bl, bridgeContext);
            this.namespaceURI = string;
            this.namespaced = true;
        }

        public EventListener getListener() {
            return this.listener.get();
        }

        public NodeEventTarget getTarget() {
            return (NodeEventTarget)this.target.get();
        }

        public boolean getUseCapture() {
            return this.useCapture;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getEventType() {
            return this.eventType;
        }

        public boolean getNamespaced() {
            return this.namespaced;
        }
    }

    public static class SoftReferenceMememto<T>
    extends CleanerThread.SoftReferenceCleared<T> {
        Object mememto;
        Set<EventListenerMememto> set;

        SoftReferenceMememto(T t, Object object, Set<EventListenerMememto> set) {
            super(t);
            this.mememto = object;
            this.set = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleared() {
            Set<EventListenerMememto> set = this.set;
            synchronized (set) {
                this.set.remove(this.mememto);
                this.mememto = null;
                this.set = null;
            }
        }
    }
}

