/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.output.NullOutputStream;

public class ThresholdingOutputStream
extends OutputStream {
    private static final IOFunction<ThresholdingOutputStream, OutputStream> NOOP_OS_GETTER = thresholdingOutputStream -> NullOutputStream.NULL_OUTPUT_STREAM;
    private final int threshold;
    private final IOConsumer<ThresholdingOutputStream> thresholdConsumer;
    private final IOFunction<ThresholdingOutputStream, OutputStream> outputStreamGetter;
    private long written;
    private boolean thresholdExceeded;

    public ThresholdingOutputStream(int n) {
        this(n, IOConsumer.noop(), NOOP_OS_GETTER);
    }

    public ThresholdingOutputStream(int n, IOConsumer<ThresholdingOutputStream> iOConsumer, IOFunction<ThresholdingOutputStream, OutputStream> iOFunction) {
        this.threshold = n;
        this.thresholdConsumer = iOConsumer == null ? IOConsumer.noop() : iOConsumer;
        this.outputStreamGetter = iOFunction == null ? NOOP_OS_GETTER : iOFunction;
    }

    protected void checkThreshold(int n) throws IOException {
        if (!this.thresholdExceeded && this.written + (long)n > (long)this.threshold) {
            this.thresholdExceeded = true;
            this.thresholdReached();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    @Override
    public void flush() throws IOException {
        this.getStream().flush();
    }

    public long getByteCount() {
        return this.written;
    }

    protected OutputStream getStream() throws IOException {
        return this.outputStreamGetter.apply(this);
    }

    public int getThreshold() {
        return this.threshold;
    }

    public boolean isThresholdExceeded() {
        return this.written > (long)this.threshold;
    }

    protected void resetByteCount() {
        this.thresholdExceeded = false;
        this.written = 0L;
    }

    protected void setByteCount(long l) {
        this.written = l;
    }

    protected void thresholdReached() throws IOException {
        this.thresholdConsumer.accept(this);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.checkThreshold(byArray.length);
        this.getStream().write(byArray);
        this.written += (long)byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.checkThreshold(n2);
        this.getStream().write(byArray, n, n2);
        this.written += (long)n2;
    }

    @Override
    public void write(int n) throws IOException {
        this.checkThreshold(1);
        this.getStream().write(n);
        ++this.written;
    }
}

