/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;

public class ObservableInputStream
extends ProxyInputStream {
    private final List<Observer> observers;

    public ObservableInputStream(InputStream inputStream) {
        this(inputStream, new ArrayList<Observer>());
    }

    private ObservableInputStream(InputStream inputStream, List<Observer> list) {
        super(inputStream);
        this.observers = list;
    }

    public ObservableInputStream(InputStream inputStream, Observer ... observerArray) {
        this(inputStream, Arrays.asList(observerArray));
    }

    public void add(Observer observer) {
        this.observers.add(observer);
    }

    @Override
    public void close() throws IOException {
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException == null) {
            this.noteClosed();
        } else {
            this.noteError(iOException);
        }
    }

    public void consume() throws IOException {
        byte[] byArray = IOUtils.byteArray();
        while (this.read(byArray) != -1) {
        }
    }

    public List<Observer> getObservers() {
        return this.observers;
    }

    protected void noteClosed() throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.closed();
        }
    }

    protected void noteDataByte(int n) throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.data(n);
        }
    }

    protected void noteDataBytes(byte[] byArray, int n, int n2) throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.data(byArray, n, n2);
        }
    }

    protected void noteError(IOException iOException) throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.error(iOException);
        }
    }

    protected void noteFinished() throws IOException {
        for (Observer observer : this.getObservers()) {
            observer.finished();
        }
    }

    private void notify(byte[] byArray, int n, int n2, IOException iOException) throws IOException {
        if (iOException != null) {
            this.noteError(iOException);
            throw iOException;
        }
        if (n2 == -1) {
            this.noteFinished();
        } else if (n2 > 0) {
            this.noteDataBytes(byArray, n, n2);
        }
    }

    @Override
    public int read() throws IOException {
        int n = 0;
        IOException iOException = null;
        try {
            n = super.read();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (iOException != null) {
            this.noteError(iOException);
            throw iOException;
        }
        if (n == -1) {
            this.noteFinished();
        } else {
            this.noteDataByte(n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = 0;
        IOException iOException = null;
        try {
            n = super.read(byArray);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.notify(byArray, 0, n, iOException);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        IOException iOException = null;
        try {
            n3 = super.read(byArray, n, n2);
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.notify(byArray, n, n3, iOException);
        return n3;
    }

    public void remove(Observer observer) {
        this.observers.remove(observer);
    }

    public void removeAllObservers() {
        this.observers.clear();
    }

    public static abstract class Observer {
        public void closed() throws IOException {
        }

        public void data(byte[] byArray, int n, int n2) throws IOException {
        }

        public void data(int n) throws IOException {
        }

        public void error(IOException iOException) throws IOException {
            throw iOException;
        }

        public void finished() throws IOException {
        }
    }
}

