/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SizeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 7388077430788600069L;
    private final boolean acceptLarger;
    private final long size;

    public SizeFileFilter(long l) {
        this(l, true);
    }

    public SizeFileFilter(long l, boolean bl) {
        if (l < 0L) {
            throw new IllegalArgumentException("The size must be non-negative");
        }
        this.size = l;
        this.acceptLarger = bl;
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file.length());
    }

    private boolean accept(long l) {
        return this.acceptLarger != l < this.size;
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        try {
            return SizeFileFilter.toFileVisitResult(this.accept(Files.size(path)), path);
        }
        catch (IOException iOException) {
            return this.handle(iOException);
        }
    }

    @Override
    public String toString() {
        String string = this.acceptLarger ? ">=" : "<";
        return super.toString() + "(" + string + this.size + ")";
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return SizeFileFilter.toFileVisitResult(this.accept(Files.size(path)), path);
    }
}

