/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class OrFileFilter
extends AbstractFileFilter
implements ConditionalFileFilter,
Serializable {
    private static final long serialVersionUID = 5767770777065432721L;
    private final List<IOFileFilter> fileFilters;

    public OrFileFilter() {
        this(0);
    }

    private OrFileFilter(ArrayList<IOFileFilter> arrayList) {
        this.fileFilters = Objects.requireNonNull(arrayList, "initialList");
    }

    private OrFileFilter(int n) {
        this(new ArrayList<IOFileFilter>(n));
    }

    public OrFileFilter(IOFileFilter ... iOFileFilterArray) {
        this(Objects.requireNonNull(iOFileFilterArray, "fileFilters").length);
        this.addFileFilter(iOFileFilterArray);
    }

    public OrFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        this(2);
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    public OrFileFilter(List<IOFileFilter> list) {
        this(new ArrayList<IOFileFilter>((Collection)Objects.requireNonNull(list, "fileFilters")));
    }

    @Override
    public boolean accept(File file) {
        for (IOFileFilter iOFileFilter : this.fileFilters) {
            if (!iOFileFilter.accept(file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String string) {
        for (IOFileFilter iOFileFilter : this.fileFilters) {
            if (!iOFileFilter.accept(file, string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        for (IOFileFilter iOFileFilter : this.fileFilters) {
            if (iOFileFilter.accept(path, basicFileAttributes) != FileVisitResult.CONTINUE) continue;
            return FileVisitResult.CONTINUE;
        }
        return FileVisitResult.TERMINATE;
    }

    @Override
    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(Objects.requireNonNull(iOFileFilter, "fileFilter"));
    }

    public void addFileFilter(IOFileFilter ... iOFileFilterArray) {
        for (IOFileFilter iOFileFilter : Objects.requireNonNull(iOFileFilterArray, "fileFilters")) {
            this.addFileFilter(iOFileFilter);
        }
    }

    @Override
    public List<IOFileFilter> getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    @Override
    public boolean removeFileFilter(IOFileFilter iOFileFilter) {
        return this.fileFilters.remove(iOFileFilter);
    }

    @Override
    public void setFileFilters(List<IOFileFilter> list) {
        this.fileFilters.clear();
        this.fileFilters.addAll((Collection<IOFileFilter>)Objects.requireNonNull(list, "fileFilters"));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        if (this.fileFilters != null) {
            for (int i = 0; i < this.fileFilters.size(); ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.fileFilters.get(i));
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

