/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.time.Duration;

class ThreadMonitor
implements Runnable {
    private final Thread thread;
    private final Duration timeout;

    static Thread start(Duration duration) {
        return ThreadMonitor.start(Thread.currentThread(), duration);
    }

    static Thread start(Thread thread, Duration duration) {
        if (duration.isZero() || duration.isNegative()) {
            return null;
        }
        ThreadMonitor threadMonitor = new ThreadMonitor(thread, duration);
        Thread thread2 = new Thread((Runnable)threadMonitor, ThreadMonitor.class.getSimpleName());
        thread2.setDaemon(true);
        thread2.start();
        return thread2;
    }

    static void stop(Thread thread) {
        if (thread != null) {
            thread.interrupt();
        }
    }

    private ThreadMonitor(Thread thread, Duration duration) {
        this.thread = thread;
        this.timeout = duration;
    }

    @Override
    public void run() {
        try {
            ThreadMonitor.sleep(this.timeout);
            this.thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void sleep(Duration duration) throws InterruptedException {
        long l = duration.toMillis();
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        do {
            Thread.sleep(l3);
        } while ((l3 = l2 - System.currentTimeMillis()) > 0L);
    }
}

