/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class IOExceptionList
extends IOException {
    private static final long serialVersionUID = 1L;
    private final List<? extends Throwable> causeList;

    public IOExceptionList(List<? extends Throwable> list) {
        this(String.format("%,d exceptions: %s", list == null ? 0 : list.size(), list), list);
    }

    public IOExceptionList(String string, List<? extends Throwable> list) {
        super(string, list == null || list.isEmpty() ? null : list.get(0));
        this.causeList = list == null ? Collections.emptyList() : list;
    }

    public <T extends Throwable> T getCause(int n) {
        return (T)this.causeList.get(n);
    }

    public <T extends Throwable> T getCause(int n, Class<T> clazz) {
        return (T)((Throwable)clazz.cast(this.causeList.get(n)));
    }

    public <T extends Throwable> List<T> getCauseList() {
        return this.causeList;
    }

    public <T extends Throwable> List<T> getCauseList(Class<T> clazz) {
        return this.causeList;
    }
}

