/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp.schemas;

import java.util.Date;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPSchemaAdapter;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;

public class DublinCoreAdapter
extends XMPSchemaAdapter {
    private static final String CONTRIBUTOR = "contributor";
    private static final String COVERAGE = "coverage";
    private static final String CREATOR = "creator";
    private static final String DATE = "date";
    private static final String DESCRIPTION = "description";
    private static final String FORMAT = "format";
    private static final String IDENTIFIER = "identifier";
    private static final String LANGUAGE = "language";
    private static final String PUBLISHER = "publisher";
    private static final String RELATION = "relation";
    private static final String RIGHTS = "rights";
    private static final String SOURCE = "source";
    private static final String SUBJECT = "subject";
    private static final String TITLE = "title";
    private static final String TYPE = "type";

    public DublinCoreAdapter(Metadata metadata) {
        super(metadata, XMPSchemaRegistry.getInstance().getSchema("http://purl.org/dc/elements/1.1/"));
    }

    public void addContributor(String string) {
        this.addStringToBag(CONTRIBUTOR, string);
    }

    public boolean removeContributor(String string) {
        return this.removeStringFromArray(CONTRIBUTOR, string);
    }

    public String[] getContributors() {
        return this.getStringArray(CONTRIBUTOR);
    }

    public void setCoverage(String string) {
        this.setValue(COVERAGE, string);
    }

    public String getCoverage() {
        return this.getValue(COVERAGE);
    }

    public void addCreator(String string) {
        this.addStringToSeq(CREATOR, string);
    }

    public boolean removeCreator(String string) {
        return this.removeStringFromArray(CREATOR, string);
    }

    public String[] getCreators() {
        return this.getStringArray(CREATOR);
    }

    public void addDate(Date date) {
        this.addDateToSeq(DATE, date);
    }

    public Date[] getDates() {
        return this.getDateArray(DATE);
    }

    public Date getDate() {
        Date[] dateArray = this.getDates();
        if (dateArray != null) {
            Date date = null;
            for (Date date2 : dateArray) {
                if (date != null && date2.getTime() <= date.getTime()) continue;
                date = date2;
            }
            return date;
        }
        return null;
    }

    public void setDescription(String string, String string2) {
        this.setLangAlt(DESCRIPTION, string, string2);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(String string) {
        return this.getLangAlt(string, DESCRIPTION);
    }

    public void setFormat(String string) {
        this.setValue(FORMAT, string);
    }

    public String getFormat() {
        return this.getValue(FORMAT);
    }

    public void setIdentifier(String string) {
        this.setValue(IDENTIFIER, string);
    }

    public String getIdentifier() {
        return this.getValue(IDENTIFIER);
    }

    public void addLanguage(String string) {
        this.addStringToBag(LANGUAGE, string);
    }

    public String[] getLanguages() {
        return this.getStringArray(LANGUAGE);
    }

    public void addPublisher(String string) {
        this.addStringToBag(PUBLISHER, string);
    }

    public String[] getPublisher() {
        return this.getStringArray(PUBLISHER);
    }

    public void addRelation(String string) {
        this.addStringToBag(RELATION, string);
    }

    public String[] getRelations() {
        return this.getStringArray(RELATION);
    }

    public void setRights(String string, String string2) {
        this.setLangAlt(RIGHTS, string, string2);
    }

    public String getRights() {
        return this.getRights(null);
    }

    public String getRights(String string) {
        return this.getLangAlt(string, RIGHTS);
    }

    public void setSource(String string) {
        this.setValue(SOURCE, string);
    }

    public String getSource() {
        return this.getValue(SOURCE);
    }

    public void addSubject(String string) {
        this.addStringToBag(SUBJECT, string);
    }

    public String[] getSubjects() {
        return this.getStringArray(SUBJECT);
    }

    public void setTitle(String string) {
        this.setTitle(null, string);
    }

    public void setTitle(String string, String string2) {
        this.setLangAlt(TITLE, string, string2);
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getTitle(String string) {
        return this.getLangAlt(string, TITLE);
    }

    public String removeTitle(String string) {
        return this.removeLangAlt(string, TITLE);
    }

    public void addType(String string) {
        this.addStringToBag(TYPE, string);
    }

    public String[] getTypes() {
        return this.getStringArray(TYPE);
    }
}

