/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.apache.xmlgraphics.xmp.XMPStructure;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMPArray
extends XMPComplexValue {
    private XMPArrayType type;
    private List values = new ArrayList();
    private List xmllang = new ArrayList();
    private List<String> parseTypes = new ArrayList<String>();

    public XMPArray(XMPArrayType xMPArrayType) {
        this.type = xMPArrayType;
    }

    public XMPArrayType getType() {
        return this.type;
    }

    public Object getValue(int n) {
        return this.values.get(n);
    }

    public XMPStructure getStructure(int n) {
        return (XMPStructure)this.values.get(n);
    }

    @Override
    public Object getSimpleValue() {
        if (this.values.size() == 1) {
            return this.getValue(0);
        }
        if (this.values.size() > 1) {
            return this.getLangValue("x-default");
        }
        return null;
    }

    private String getParentLanguage(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(45);
        if (n > 0) {
            String string2 = string.substring(0, n);
            return string2;
        }
        return null;
    }

    public String getLangValue(String string) {
        String string2 = null;
        String string3 = null;
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            String string4;
            String string5 = (String)this.xmllang.get(i);
            if (string5 == null && string == null || string5 != null && string5.equals(string)) {
                string2 = this.values.get(i).toString();
                break;
            }
            if (string5 == null || string == null || (string4 = this.getParentLanguage(string5)) == null || !string4.equals(string)) continue;
            string3 = this.values.get(i).toString();
        }
        if (string != null && string2 == null && string3 != null) {
            string2 = string3;
        }
        if (string == null && string2 == null && (string2 = this.getLangValue("x-default")) == null && this.values.size() > 0) {
            string2 = this.getValue(0).toString();
        }
        return string2;
    }

    public String removeLangValue(String string) {
        if (string == null || "".equals(string)) {
            string = "x-default";
        }
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.xmllang.get(i);
            if ((!"x-default".equals(string) || string2 != null) && !string.equals(string2)) continue;
            String string3 = (String)this.values.remove(i);
            this.xmllang.remove(i);
            return string3;
        }
        return null;
    }

    public void add(Object object, String string, String string2) {
        this.values.add(object);
        this.xmllang.add(string);
        this.parseTypes.add(string2);
    }

    public void add(Object object, String string) {
        this.add(object, string, null);
    }

    public void add(Object object) {
        this.add(object, null, null);
    }

    public boolean remove(String string) {
        int n = this.values.indexOf(string);
        if (n >= 0) {
            this.values.remove(n);
            this.xmllang.remove(n);
            this.parseTypes.remove(n);
            return true;
        }
        return false;
    }

    public int getSize() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public Object[] toObjectArray() {
        Object[] objectArray = new Object[this.getSize()];
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.getValue(i);
        }
        return objectArray;
    }

    @Override
    public void toSAX(ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        contentHandler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName(), attributesImpl);
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = (String)this.xmllang.get(i);
            attributesImpl.clear();
            Object e = this.values.get(i);
            if (string2 != null) {
                attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", string2);
            }
            if (e instanceof URI) {
                attributesImpl.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", "rdf:resource", "CDATA", ((URI)e).toString());
            }
            if ((string = this.parseTypes.get(i)) != null) {
                attributesImpl.addAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "rdf:parseType", "CDATA", string);
            }
            contentHandler.startElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li", attributesImpl);
            if (e instanceof XMPComplexValue) {
                ((XMPComplexValue)e).toSAX(contentHandler);
            } else if (!(e instanceof URI)) {
                String string3 = (String)this.values.get(i);
                char[] cArray = string3.toCharArray();
                contentHandler.characters(cArray, 0, cArray.length);
            }
            contentHandler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "li", "rdf:li");
        }
        contentHandler.endElement("http://www.w3.org/1999/02/22-rdf-syntax-ns#", this.type.getName(), "rdf:" + this.type.getName());
    }

    public String toString() {
        return "XMP array: " + this.type + ", " + this.getSize();
    }
}

