/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public final class ClasspathResource {
    private final Map contentMappings = new HashMap();
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String CONTENT_TYPE_KEY = "Content-Type";
    private static ClasspathResource classpathResource;

    private ClasspathResource() {
        this.loadManifests();
    }

    public static synchronized ClasspathResource getInstance() {
        if (classpathResource == null) {
            classpathResource = new ClasspathResource();
        }
        return classpathResource;
    }

    private Set getClassLoadersForResources() {
        ClassLoader classLoader;
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>();
        try {
            classLoader = ClassLoader.getSystemClassLoader();
            if (classLoader != null) {
                hashSet.add(classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                hashSet.add(classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            classLoader = ClasspathResource.class.getClassLoader();
            if (classLoader != null) {
                hashSet.add(classLoader);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return hashSet;
    }

    private void loadManifests() {
        try {
            for (Object e : this.getClassLoadersForResources()) {
                ClassLoader classLoader = (ClassLoader)e;
                Enumeration<URL> enumeration = classLoader.getResources(MANIFEST_PATH);
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    try {
                        Manifest manifest = new Manifest(uRL.openStream());
                        Map<String, Attributes> map = manifest.getEntries();
                        Iterator<Map.Entry<String, Attributes>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, Attributes> entry;
                            Map.Entry<String, Attributes> entry2 = entry = iterator.next();
                            String string = entry2.getKey();
                            Attributes attributes = entry2.getValue();
                            String string2 = attributes.getValue(CONTENT_TYPE_KEY);
                            if (string2 == null) continue;
                            this.addToMapping(string2, string, classLoader);
                        }
                    }
                    catch (IOException iOException) {
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addToMapping(String string, String string2, ClassLoader classLoader) {
        URL uRL;
        Vector<URL> vector = (Vector<URL>)this.contentMappings.get(string);
        if (vector == null) {
            vector = new Vector<URL>();
            this.contentMappings.put(string, vector);
        }
        if ((uRL = classLoader.getResource(string2)) != null) {
            vector.add(uRL);
        }
    }

    public List listResourcesOfMimeType(String string) {
        List list = (List)this.contentMappings.get(string);
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }
}

