/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.events;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSProcSet;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.events.AbstractDSCComment;

public abstract class AbstractResourcesDSCComment
extends AbstractDSCComment {
    private Set resources;
    static final Set RESOURCE_TYPES = new HashSet();

    public AbstractResourcesDSCComment() {
    }

    public AbstractResourcesDSCComment(Collection collection) {
        this.addResources(collection);
    }

    @Override
    public boolean hasValues() {
        return true;
    }

    private void prepareResourceSet() {
        if (this.resources == null) {
            this.resources = new TreeSet();
        }
    }

    public void addResource(PSResource pSResource) {
        this.prepareResourceSet();
        this.resources.add(pSResource);
    }

    public void addResources(Collection collection) {
        if (collection != null) {
            this.prepareResourceSet();
            this.resources.addAll(collection);
        }
    }

    public Set getResources() {
        return Collections.unmodifiableSet(this.resources);
    }

    @Override
    public void parseValue(String string) {
        List list = this.splitParams(string);
        String string2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4 = (String)iterator.next();
            if (RESOURCE_TYPES.contains(string4)) {
                string2 = string4;
            }
            if (string2 == null) {
                throw new IllegalArgumentException("<resources> must begin with a resource type. Found: " + string4);
            }
            if ("font".equals(string2)) {
                string3 = (String)iterator.next();
                this.addResource(new PSResource(string4, string3));
                continue;
            }
            if ("form".equals(string2)) {
                string3 = (String)iterator.next();
                this.addResource(new PSResource(string4, string3));
                continue;
            }
            if ("procset".equals(string2)) {
                string3 = (String)iterator.next();
                String string5 = (String)iterator.next();
                String string6 = (String)iterator.next();
                this.addResource(new PSProcSet(string3, Float.parseFloat(string5), Integer.parseInt(string6)));
                continue;
            }
            if ("file".equals(string2)) {
                string3 = (String)iterator.next();
                this.addResource(new PSResource(string4, string3));
                continue;
            }
            throw new IllegalArgumentException("Invalid resource type: " + string2);
        }
    }

    @Override
    public void generate(PSGenerator pSGenerator) throws IOException {
        if (this.resources == null || this.resources.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("%%").append(this.getName()).append(": ");
        boolean bl = true;
        for (Object e : this.resources) {
            if (!bl) {
                pSGenerator.writeln(stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append("%%+ ");
            }
            PSResource pSResource = (PSResource)e;
            stringBuffer.append(pSResource.getResourceSpecification());
            bl = false;
        }
        pSGenerator.writeln(stringBuffer.toString());
    }

    static {
        RESOURCE_TYPES.add("font");
        RESOURCE_TYPES.add("procset");
        RESOURCE_TYPES.add("file");
        RESOURCE_TYPES.add("pattern");
        RESOURCE_TYPES.add("form");
        RESOURCE_TYPES.add("encoding");
    }
}

