/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.xmlgraphics.ps.PSDictionaryFormatException;

public class PSDictionary
extends HashMap {
    private static final long serialVersionUID = 815367222496219197L;

    public static PSDictionary valueOf(String string) throws PSDictionaryFormatException {
        return new Maker().parseDictionary(string);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PSDictionary)) {
            return false;
        }
        PSDictionary pSDictionary = (PSDictionary)object;
        if (pSDictionary.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : this.entrySet()) {
            Map.Entry entry2 = entry;
            String string = (String)entry2.getKey();
            if (!pSDictionary.containsKey(string)) {
                return false;
            }
            if (pSDictionary.get(string).equals(entry2.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 7;
        for (Object v : this.values()) {
            n += v.hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("<<\n");
        for (Object k : super.keySet()) {
            String string = (String)k;
            stringBuffer.append("  " + string + " ");
            Object v = super.get(string);
            if (v instanceof ArrayList) {
                List list = (List)v;
                StringBuilder stringBuilder = new StringBuilder("[");
                for (Object e : list) {
                    stringBuilder.append(e + " ");
                }
                Object object = stringBuilder.toString().trim();
                object = (String)object + "]";
                stringBuffer.append((String)object + "\n");
                continue;
            }
            stringBuffer.append(v.toString() + "\n");
        }
        stringBuffer.append(">>");
        return stringBuffer.toString();
    }

    private static class Maker {
        private static final String[][] BRACES = new String[][]{{"<<", ">>"}, {"[", "]"}, {"{", "}"}, {"(", ")"}};
        private static final int OPENING = 0;
        private static final int CLOSING = 1;
        private static final int DICTIONARY = 0;
        private static final int ARRAY = 1;
        private static final int PROCEDURE = 2;
        private static final int STRING = 3;

        private Maker() {
        }

        protected Token nextToken(String string, int n) {
            Token token = null;
            for (int i = n; i < string.length(); ++i) {
                boolean bl = Character.isWhitespace(string.charAt(i));
                if (token == null && !bl) {
                    token = new Token();
                    token.startIndex = i;
                    continue;
                }
                if (token == null || !bl) continue;
                token.endIndex = i;
                break;
            }
            if (token != null) {
                if (token.endIndex == -1) {
                    token.endIndex = string.length();
                }
                token.value = string.substring(token.startIndex, token.endIndex);
            }
            return token;
        }

        private int indexOfMatchingBrace(String string, String[] stringArray, int n) throws PSDictionaryFormatException {
            int n2 = string.length();
            if (stringArray.length != 2) {
                throw new PSDictionaryFormatException("Wrong number of braces");
            }
            int n3 = 0;
            int n4 = 0;
            while (n < n2) {
                if (string.startsWith(stringArray[0], n)) {
                    ++n3;
                } else if (string.startsWith(stringArray[1], n) && n3 > 0 && n3 == ++n4) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private String stripBraces(String string, String[] stringArray) throws PSDictionaryFormatException {
            int n = string.indexOf(stringArray[0]);
            if (n == -1) {
                throw new PSDictionaryFormatException("Failed to find opening parameter '" + stringArray[0] + "");
            }
            int n2 = this.indexOfMatchingBrace(string, stringArray, n);
            if (n2 == -1) {
                throw new PSDictionaryFormatException("Failed to find matching closing parameter '" + stringArray[1] + "'");
            }
            int n3 = stringArray[0].length();
            string = string.substring(n + n3, n2).trim();
            return string;
        }

        /*
         * WARNING - void declaration
         */
        public PSDictionary parseDictionary(String string) throws PSDictionaryFormatException {
            Token token;
            PSDictionary pSDictionary = new PSDictionary();
            string = this.stripBraces(string.trim(), BRACES[0]);
            int n = string.length();
            int n2 = 0;
            while ((token = this.nextToken(string, n2)) != null && n2 <= n) {
                void object;
                if (token.value == null) {
                    throw new PSDictionaryFormatException("Failed to parse object key");
                }
                Token token2 = this.nextToken(string, token.endIndex + 1);
                String[] stringArray = null;
                for (String[] stringArray2 : BRACES) {
                    if (!token2.value.startsWith(stringArray2[0])) continue;
                    stringArray = stringArray2;
                    break;
                }
                Object var8_10 = null;
                if (stringArray != null) {
                    token2.endIndex = this.indexOfMatchingBrace(string, stringArray, token2.startIndex) + stringArray[0].length();
                    if (token2.endIndex < 0) {
                        throw new PSDictionaryFormatException("Closing value brace '" + stringArray[1] + "' not found for key '" + token.value + "'");
                    }
                    token2.value = string.substring(token2.startIndex, token2.endIndex);
                }
                if (stringArray == null || stringArray == BRACES[2] || stringArray == BRACES[3]) {
                    String string2 = token2.value;
                } else if (BRACES[1] == stringArray) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string3 = this.stripBraces(token2.value, stringArray);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    ArrayList<String> arrayList2 = arrayList;
                } else if (BRACES[0] == stringArray) {
                    PSDictionary pSDictionary2 = this.parseDictionary(token2.value);
                }
                pSDictionary.put(token.value, object);
                n2 = token2.endIndex + 1;
            }
            return pSDictionary;
        }

        private static class Token {
            private int startIndex = -1;
            private int endIndex = -1;
            private String value;

            private Token() {
            }
        }
    }
}

