/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Dimension;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.apache.xmlgraphics.ps.FormGenerator;
import org.apache.xmlgraphics.ps.ImageEncoder;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.ps.PSDictionary;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class ImageFormGenerator
extends FormGenerator {
    private RenderedImage image;
    private ImageEncoder encoder;
    private ColorSpace colorSpace;
    private int bitsPerComponent = 8;
    private boolean invertImage;
    private Dimension pixelDimensions;

    public ImageFormGenerator(String string, String string2, Dimension2D dimension2D, RenderedImage renderedImage, boolean bl) {
        super(string, string2, dimension2D);
        this.image = renderedImage;
        this.encoder = ImageEncodingHelper.createRenderedImageEncoder(renderedImage);
        this.invertImage = bl;
        this.pixelDimensions = new Dimension(renderedImage.getWidth(), renderedImage.getHeight());
    }

    public ImageFormGenerator(String string, String string2, Dimension2D dimension2D, Dimension dimension, ImageEncoder imageEncoder, ColorSpace colorSpace, int n, boolean bl) {
        super(string, string2, dimension2D);
        this.pixelDimensions = dimension;
        this.encoder = imageEncoder;
        this.colorSpace = colorSpace;
        this.bitsPerComponent = n;
        this.invertImage = bl;
    }

    public ImageFormGenerator(String string, String string2, Dimension2D dimension2D, Dimension dimension, ImageEncoder imageEncoder, ColorSpace colorSpace, boolean bl) {
        this(string, string2, dimension2D, dimension, imageEncoder, colorSpace, 8, bl);
    }

    protected String getDataName() {
        return this.getFormName() + ":Data";
    }

    private String getAdditionalFilters(PSGenerator pSGenerator) {
        String string = this.encoder.getImplicitFilter();
        if (string != null) {
            return "/ASCII85Decode filter " + string + " filter";
        }
        if (pSGenerator.getPSLevel() >= 3) {
            return "/ASCII85Decode filter";
        }
        return "/ASCII85Decode filter /RunLengthDecode filter";
    }

    @Override
    protected void generatePaintProc(PSGenerator pSGenerator) throws IOException {
        Object object;
        String string;
        if (pSGenerator.getPSLevel() == 2) {
            pSGenerator.writeln("    userdict /i 0 put");
        } else {
            pSGenerator.writeln("    " + this.getDataName() + " 0 setfileposition");
        }
        if (pSGenerator.getPSLevel() == 2) {
            string = "{ " + this.getDataName() + " i get /i i 1 add store } bind";
        } else {
            string = this.getDataName();
            if (pSGenerator.getPSLevel() >= 3 && (object = this.encoder.getImplicitFilter()) == null) {
                string = string + " /FlateDecode filter";
            }
        }
        object = new AffineTransform();
        ((AffineTransform)object).scale(this.getDimensions().getWidth(), this.getDimensions().getHeight());
        pSGenerator.concatMatrix((AffineTransform)object);
        PSDictionary pSDictionary = new PSDictionary();
        pSDictionary.put("/DataSource", string);
        if (this.image != null) {
            PSImageUtils.writeImageCommand(this.image, pSDictionary, pSGenerator);
        } else {
            pSDictionary.put("/BitsPerComponent", Integer.toString(this.bitsPerComponent));
            PSImageUtils.writeImageCommand(pSDictionary, this.pixelDimensions, this.colorSpace, this.invertImage, pSGenerator);
        }
    }

    @Override
    protected void generateAdditionalDataStream(PSGenerator pSGenerator) throws IOException {
        pSGenerator.writeln("/" + this.getDataName() + " currentfile");
        pSGenerator.writeln(this.getAdditionalFilters(pSGenerator));
        if (pSGenerator.getPSLevel() == 2) {
            pSGenerator.writeln("{ /temp exch def [ { temp 16384 string readstring not {exit } if } loop ] } exec");
        } else {
            pSGenerator.writeln("/ReusableStreamDecode filter");
        }
        PSImageUtils.compressAndWriteBitmap(this.encoder, pSGenerator);
        pSGenerator.writeln("def");
    }
}

