/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.xmlgraphics.image.GraphicsUtil;
import org.apache.xmlgraphics.ps.ImageEncoder;

public class ImageEncodingHelper {
    private static final ColorModel DEFAULT_RGB_COLOR_MODEL = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
    private final RenderedImage image;
    private ColorModel encodedColorModel;
    private boolean firstTileDump;
    private boolean enableCMYK;
    private boolean isBGR;
    private boolean isKMYC;
    private boolean outputbw;
    private boolean bwinvert;

    public ImageEncodingHelper(RenderedImage renderedImage) {
        this(renderedImage, true);
        this.outputbw = true;
    }

    public ImageEncodingHelper(RenderedImage renderedImage, boolean bl) {
        this.image = renderedImage;
        this.enableCMYK = bl;
        this.determineEncodedColorModel();
    }

    public RenderedImage getImage() {
        return this.image;
    }

    public ColorModel getNativeColorModel() {
        return this.getImage().getColorModel();
    }

    public ColorModel getEncodedColorModel() {
        return this.encodedColorModel;
    }

    public boolean hasAlpha() {
        return this.image.getColorModel().hasAlpha();
    }

    public boolean isConverted() {
        return this.getNativeColorModel() != this.getEncodedColorModel();
    }

    private void writeRGBTo(OutputStream outputStream) throws IOException {
        boolean bl = ImageEncodingHelper.encodeRenderedImageWithDirectColorModelAsRGB(this.image, outputStream);
        if (bl) {
            return;
        }
        ImageEncodingHelper.encodeRenderedImageAsRGB(this.image, outputStream, this.outputbw, this.bwinvert);
    }

    public static void encodeRenderedImageAsRGB(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        ImageEncodingHelper.encodeRenderedImageAsRGB(renderedImage, outputStream, false, false);
    }

    public static void encodeRenderedImageAsRGB(RenderedImage renderedImage, OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        Object[] objectArray;
        Raster raster = ImageEncodingHelper.getRaster(renderedImage);
        int n = raster.getNumBands();
        int n2 = raster.getDataBuffer().getDataType();
        switch (n2) {
            case 0: {
                objectArray = new byte[n];
                break;
            }
            case 1: {
                objectArray = null;
                break;
            }
            case 3: {
                objectArray = new int[n];
                break;
            }
            case 4: {
                objectArray = new float[n];
                break;
            }
            case 5: {
                objectArray = new double[n];
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown data buffer type: " + n2);
            }
        }
        ColorModel colorModel = renderedImage.getColorModel();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        int n5 = 3;
        if (colorModel.getPixelSize() == 1 && bl) {
            n5 = 1;
        }
        byte[] byArray = new byte[n3 * n5];
        for (int i = 0; i < n4; ++i) {
            int n6 = -1;
            for (int j = 0; j < n3; ++j) {
                int n7 = colorModel.getRGB(raster.getDataElements(j, i, objectArray));
                if (n5 > 1) {
                    byArray[++n6] = (byte)(n7 >> 16);
                    byArray[++n6] = (byte)(n7 >> 8);
                } else if (bl2 && n7 == -1) {
                    n7 = 1;
                }
                byArray[++n6] = (byte)n7;
            }
            outputStream.write(byArray);
        }
    }

    public static boolean encodeRenderedImageWithDirectColorModelAsRGB(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel.getColorSpace() != ColorSpace.getInstance(1000)) {
            return false;
        }
        if (!(colorModel instanceof DirectColorModel)) {
            return false;
        }
        DirectColorModel directColorModel = (DirectColorModel)colorModel;
        int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
        int[] nArray2 = directColorModel.getMasks();
        if (!Arrays.equals(nArray, nArray2)) {
            return false;
        }
        Raster raster = ImageEncodingHelper.getRaster(renderedImage);
        int n = raster.getDataBuffer().getDataType();
        if (n != 3) {
            return false;
        }
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        int[] nArray3 = new int[n2];
        byte[] byArray = new byte[n2 * 3];
        for (int i = 0; i < n3; ++i) {
            int n4 = -1;
            raster.getDataElements(0, i, n2, 1, nArray3);
            for (int j = 0; j < n2; ++j) {
                int n5 = nArray3[j];
                byArray[++n4] = (byte)(n5 >> 16);
                byArray[++n4] = (byte)(n5 >> 8);
                byArray[++n4] = (byte)n5;
            }
            outputStream.write(byArray);
        }
        return true;
    }

    private static Raster getRaster(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return ((BufferedImage)renderedImage).getRaster();
        }
        return renderedImage.getData();
    }

    public static void encodeRGBAsGrayScale(byte[] byArray, int n, int n2, int n3, OutputStream outputStream) throws IOException {
        int n4 = 8 / n3;
        int n5 = n / n4;
        if (n % n4 != 0) {
            ++n5;
        }
        byte[] byArray2 = new byte[n5];
        for (int i = 0; i < n2; ++i) {
            byte by = 0;
            int n6 = 3 * i * n;
            int n7 = 0;
            while (n7 < n) {
                double d = 0.212671 * (double)(byArray[n6] & 0xFF) + 0.71516 * (double)(byArray[n6 + 1] & 0xFF) + 0.072169 * (double)(byArray[n6 + 2] & 0xFF);
                switch (n3) {
                    case 1: {
                        if (!(d < 128.0)) break;
                        by = (byte)(by | (byte)(1 << 7 - n7 % 8));
                        break;
                    }
                    case 4: {
                        by = (byte)(by | (byte)((byte)(d /= 16.0) << (1 - n7 % 2) * 4));
                        break;
                    }
                    case 8: {
                        by = (byte)d;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported bits per pixel: " + n3);
                    }
                }
                if (n7 % n4 == n4 - 1 || n7 + 1 == n) {
                    byArray2[n7 / n4] = by;
                    by = 0;
                }
                ++n7;
                n6 += 3;
            }
            outputStream.write(byArray2);
        }
    }

    private boolean optimizedWriteTo(OutputStream outputStream) throws IOException {
        Raster raster;
        DataBuffer dataBuffer;
        if (this.firstTileDump && (dataBuffer = (raster = this.image.getTile(0, 0)).getDataBuffer()) instanceof DataBufferByte) {
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            if (this.isBGR) {
                byte[] byArray2 = new byte[byArray.length];
                for (int i = 0; i < byArray.length; i += 3) {
                    byArray2[i] = byArray[i + 2];
                    byArray2[i + 1] = byArray[i + 1];
                    byArray2[i + 2] = byArray[i];
                }
                outputStream.write(byArray2);
            } else if (this.isKMYC) {
                byte[] byArray3 = new byte[byArray.length];
                for (int i = 0; i < byArray.length; i += 4) {
                    byArray3[i] = byArray[i + 3];
                    byArray3[i + 1] = byArray[i + 2];
                    byArray3[i + 2] = byArray[i + 1];
                    byArray3[i + 3] = byArray[i];
                }
                outputStream.write(byArray3);
            } else {
                outputStream.write(byArray);
            }
            return true;
        }
        return false;
    }

    protected boolean isMultiTile() {
        int n = this.image.getNumXTiles();
        int n2 = this.image.getNumYTiles();
        return n != 1 || n2 != 1;
    }

    protected void determineEncodedColorModel() {
        this.firstTileDump = false;
        this.encodedColorModel = DEFAULT_RGB_COLOR_MODEL;
        ColorModel colorModel = this.image.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        int n = colorModel.getNumComponents();
        if (!this.isMultiTile()) {
            if (n == 1 && colorSpace.getType() == 6) {
                if (colorModel.getTransferType() == 0) {
                    this.firstTileDump = true;
                    this.encodedColorModel = colorModel;
                }
            } else if (colorModel instanceof IndexColorModel) {
                if (colorModel.getTransferType() == 0) {
                    this.firstTileDump = true;
                    this.encodedColorModel = colorModel;
                }
            } else if (colorModel instanceof ComponentColorModel && (n == 3 || this.enableCMYK && n == 4) && !colorModel.hasAlpha()) {
                Raster raster = this.image.getTile(0, 0);
                DataBuffer dataBuffer = raster.getDataBuffer();
                SampleModel sampleModel = raster.getSampleModel();
                if (sampleModel instanceof PixelInterleavedSampleModel) {
                    PixelInterleavedSampleModel pixelInterleavedSampleModel = (PixelInterleavedSampleModel)sampleModel;
                    int[] nArray = pixelInterleavedSampleModel.getBandOffsets();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == i || nArray[i] == nArray.length - 1 - i) continue;
                        return;
                    }
                    this.isBGR = false;
                    if (nArray.length == 3 && nArray[0] == 2 && nArray[1] == 1 && nArray[2] == 0) {
                        this.isBGR = true;
                    }
                    if (nArray.length == 4 && nArray[0] == 3 && nArray[1] == 2 && nArray[2] == 1 && nArray[3] == 0) {
                        this.isKMYC = true;
                    }
                }
                if (colorModel.getTransferType() == 0 && dataBuffer.getOffset() == 0 && dataBuffer.getNumBanks() == 1) {
                    this.firstTileDump = true;
                    this.encodedColorModel = colorModel;
                }
            }
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (!this.isConverted() && this.optimizedWriteTo(outputStream)) {
            return;
        }
        this.writeRGBTo(outputStream);
    }

    public void encodeAlpha(OutputStream outputStream) throws IOException {
        if (!this.hasAlpha()) {
            throw new IllegalStateException("Image doesn't have an alpha channel");
        }
        Raster raster = GraphicsUtil.getAlphaRaster(this.image);
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (!(dataBuffer instanceof DataBufferByte)) {
            throw new UnsupportedOperationException("Alpha raster not supported: " + dataBuffer.getClass().getName());
        }
        outputStream.write(((DataBufferByte)dataBuffer).getData());
    }

    public static void encodePackedColorComponents(RenderedImage renderedImage, OutputStream outputStream) throws IOException {
        ImageEncodingHelper imageEncodingHelper = new ImageEncodingHelper(renderedImage);
        imageEncodingHelper.encode(outputStream);
    }

    public static ImageEncoder createRenderedImageEncoder(RenderedImage renderedImage) {
        return new RenderedImageEncoder(renderedImage);
    }

    public void setBWInvert(boolean bl) {
        this.bwinvert = bl;
    }

    private static class RenderedImageEncoder
    implements ImageEncoder {
        private final RenderedImage img;

        public RenderedImageEncoder(RenderedImage renderedImage) {
            if (renderedImage instanceof BufferedImage && ((BufferedImage)renderedImage).getType() == 6) {
                BufferedImage bufferedImage = new BufferedImage(renderedImage.getWidth(), renderedImage.getHeight(), 1);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setBackground(Color.WHITE);
                graphics2D.clearRect(0, 0, renderedImage.getWidth(), renderedImage.getHeight());
                graphics2D.drawImage((Image)((BufferedImage)renderedImage), 0, 0, null);
                graphics2D.dispose();
                renderedImage = bufferedImage;
            }
            this.img = renderedImage;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            ImageEncodingHelper.encodePackedColorComponents(this.img, outputStream);
        }

        @Override
        public String getImplicitFilter() {
            return null;
        }
    }
}

