/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;

public abstract class FormGenerator {
    private String formName;
    private String title;
    private Dimension2D dimensions;

    public FormGenerator(String string, String string2, Dimension2D dimension2D) {
        this.formName = string;
        this.title = string2;
        this.dimensions = dimension2D;
    }

    public String getFormName() {
        return this.formName;
    }

    public String getTitle() {
        return this.title;
    }

    public Dimension2D getDimensions() {
        return this.dimensions;
    }

    protected abstract void generatePaintProc(PSGenerator var1) throws IOException;

    protected void generateAdditionalDataStream(PSGenerator pSGenerator) throws IOException {
    }

    protected AffineTransform getMatrix() {
        return new AffineTransform();
    }

    protected Rectangle2D getBBox() {
        return new Rectangle2D.Double(0.0, 0.0, this.dimensions.getWidth(), this.dimensions.getHeight());
    }

    public PSResource generate(PSGenerator pSGenerator) throws IOException {
        if (pSGenerator.getPSLevel() < 2) {
            throw new UnsupportedOperationException("Forms require at least Level 2 PostScript");
        }
        pSGenerator.writeDSCComment("BeginResource", new Object[]{"form", this.getFormName()});
        if (this.title != null) {
            pSGenerator.writeDSCComment("Title", this.title);
        }
        pSGenerator.writeln("/" + this.formName);
        pSGenerator.writeln("<< /FormType 1");
        pSGenerator.writeln("  /BBox " + pSGenerator.formatRectangleToArray(this.getBBox()));
        pSGenerator.writeln("  /Matrix " + pSGenerator.formatMatrix(this.getMatrix()));
        pSGenerator.writeln("  /PaintProc {");
        pSGenerator.writeln("    pop");
        pSGenerator.writeln("    gsave");
        this.generatePaintProc(pSGenerator);
        pSGenerator.writeln("    grestore");
        pSGenerator.writeln("  } bind");
        pSGenerator.writeln(">> def");
        PSResource pSResource = new PSResource("form", this.formName);
        try {
            this.generateAdditionalDataStream(pSGenerator);
        }
        finally {
            pSGenerator.writeDSCComment("EndResource");
            pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        }
        return pSResource;
    }
}

