/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.color;

import java.awt.Color;
import org.apache.xmlgraphics.java2d.color.ColorWithAlternatives;
import org.apache.xmlgraphics.java2d.color.DeviceCMYKColorSpace;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color lightenColor(Color color, float f) {
        float[] fArray = new float[4];
        fArray = color.getRGBComponents(fArray);
        if (f > 0.0f) {
            fArray[0] = fArray[0] + (1.0f - fArray[0]) * f;
            fArray[1] = fArray[1] + (1.0f - fArray[1]) * f;
            fArray[2] = fArray[2] + (1.0f - fArray[2]) * f;
        } else {
            fArray[0] = fArray[0] - fArray[0] * -f;
            fArray[1] = fArray[1] - fArray[1] * -f;
            fArray[2] = fArray[2] - fArray[2] * -f;
        }
        return new Color(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public static boolean isGray(Color color) {
        return color.getRed() == color.getBlue() && color.getRed() == color.getGreen();
    }

    public static Color toCMYKGrayColor(float f) {
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 1.0f - f};
        return DeviceCMYKColorSpace.createCMYKColor(fArray);
    }

    public static Color toSRGBColor(Color color) {
        if (color.getColorSpace().isCS_sRGB()) {
            return color;
        }
        float[] fArray = color.getColorComponents(null);
        float[] fArray2 = color.getColorSpace().toRGB(fArray);
        fArray = color.getComponents(null);
        float f = fArray[fArray.length - 1];
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    public static boolean isSameColor(Color color, Color color2) {
        float[] fArray;
        if (!color.equals(color2)) {
            return false;
        }
        Class<Object> clazz = color.getClass();
        if (color instanceof ColorWithAlternatives && !((ColorWithAlternatives)color).hasAlternativeColors()) {
            clazz = Color.class;
        }
        Class<Object> clazz2 = color2.getClass();
        if (color2 instanceof ColorWithAlternatives && !((ColorWithAlternatives)color2).hasAlternativeColors()) {
            clazz2 = Color.class;
        }
        if (clazz != clazz2) {
            return false;
        }
        if (!color.getColorSpace().equals(color2.getColorSpace())) {
            return false;
        }
        float[] fArray2 = color.getComponents(null);
        if (fArray2.length != (fArray = color2.getComponents(null)).length) {
            return false;
        }
        int n = fArray2.length;
        for (int i = 0; i < n; ++i) {
            if (fArray2[i] == fArray[i]) continue;
            return false;
        }
        if (color instanceof ColorWithAlternatives && color2 instanceof ColorWithAlternatives) {
            ColorWithAlternatives colorWithAlternatives = (ColorWithAlternatives)color;
            ColorWithAlternatives colorWithAlternatives2 = (ColorWithAlternatives)color2;
            return colorWithAlternatives.hasSameAlternativeColors(colorWithAlternatives2);
        }
        return true;
    }
}

