/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer.imageio;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.apache.xmlgraphics.image.writer.Endianness;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ResolutionUnit;
import org.apache.xmlgraphics.image.writer.imageio.ImageIOImageWriter;
import org.w3c.dom.Node;

public class ImageIOTIFFImageWriter
extends ImageIOImageWriter {
    private static final String SUN_TIFF_NATIVE_FORMAT = "com_sun_media_imageio_plugins_tiff_image_1.0";
    private static final String JAVA_TIFF_NATIVE_FORMAT = "javax_imageio_tiff_image_1.0";
    private static final String SUN_TIFF_NATIVE_STREAM_FORMAT = "com_sun_media_imageio_plugins_tiff_stream_1.0";
    private static final String JAVA_TIFF_NATIVE_STREAM_FORMAT = "javax_imageio_tiff_stream_1.0";
    private static final String DENOMINATOR_CENTIMETER = "/10000";
    private static final String DENOMINATOR_INCH = "/1";

    public ImageIOTIFFImageWriter() {
        super("image/tiff");
    }

    @Override
    protected IIOMetadata updateMetadata(RenderedImage renderedImage, IIOMetadata iIOMetadata, ImageWriterParams imageWriterParams) {
        iIOMetadata = super.updateMetadata(renderedImage, iIOMetadata, imageWriterParams);
        if (imageWriterParams.getResolution() != null && (SUN_TIFF_NATIVE_FORMAT.equals(iIOMetadata.getNativeMetadataFormatName()) || JAVA_TIFF_NATIVE_FORMAT.equals(iIOMetadata.getNativeMetadataFormatName()))) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(iIOMetadata.getNativeMetadataFormatName());
            IIOMetadataNode iIOMetadataNode2 = ImageIOTIFFImageWriter.getChildNode(iIOMetadataNode, "TIFFIFD");
            if (iIOMetadataNode2 == null) {
                iIOMetadataNode2 = new IIOMetadataNode("TIFFIFD");
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            iIOMetadataNode2.appendChild(this.createResolutionUnitField(imageWriterParams));
            iIOMetadataNode2.appendChild(this.createResolutionField(282, "XResolution", imageWriterParams.getXResolution(), imageWriterParams.getResolutionUnit()));
            iIOMetadataNode2.appendChild(this.createResolutionField(283, "YResolution", imageWriterParams.getYResolution(), imageWriterParams.getResolutionUnit()));
            int n = imageWriterParams.isSingleStrip() ? renderedImage.getHeight() : imageWriterParams.getRowsPerStrip();
            iIOMetadataNode2.appendChild(ImageIOTIFFImageWriter.createShortMetadataNode(278, "RowsPerStrip", Integer.toString(n)));
            try {
                iIOMetadata.mergeTree(iIOMetadata.getNativeMetadataFormatName(), iIOMetadataNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new RuntimeException("Cannot update image metadata: " + iIOInvalidTreeException.getMessage(), iIOInvalidTreeException);
            }
        }
        return iIOMetadata;
    }

    private IIOMetadataNode createResolutionField(int n, String string, Integer n2, ResolutionUnit resolutionUnit) {
        String string2;
        if (resolutionUnit == ResolutionUnit.INCH) {
            string2 = n2 + DENOMINATOR_INCH;
        } else {
            float f = 25.4f / n2.floatValue();
            int n3 = (int)((double)(100000.0f / f) + 0.5);
            string2 = n3 + DENOMINATOR_CENTIMETER;
        }
        return ImageIOTIFFImageWriter.createRationalMetadataNode(n, string, string2);
    }

    private IIOMetadataNode createResolutionUnitField(ImageWriterParams imageWriterParams) {
        return ImageIOTIFFImageWriter.createShortMetadataNode(296, "ResolutionUnit", Integer.toString(imageWriterParams.getResolutionUnit().getValue()), imageWriterParams.getResolutionUnit().getDescription());
    }

    public static final IIOMetadataNode createShortMetadataNode(int n, String string, String string2) {
        return ImageIOTIFFImageWriter.createShortMetadataNode(n, string, string2, null);
    }

    public static final IIOMetadataNode createShortMetadataNode(int n, String string, String string2, String string3) {
        IIOMetadataNode iIOMetadataNode = ImageIOTIFFImageWriter.createMetadataField(n, string);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFFShorts");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("TIFFShort");
        iIOMetadataNode3.setAttribute("value", string2);
        if (string3 != null) {
            iIOMetadataNode3.setAttribute("description", string3);
        }
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        return iIOMetadataNode;
    }

    public static final IIOMetadataNode createRationalMetadataNode(int n, String string, String string2) {
        IIOMetadataNode iIOMetadataNode = ImageIOTIFFImageWriter.createMetadataField(n, string);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TIFFRationals");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("TIFFRational");
        iIOMetadataNode3.setAttribute("value", string2);
        iIOMetadataNode2.appendChild(iIOMetadataNode3);
        return iIOMetadataNode;
    }

    public static final IIOMetadataNode createMetadataField(int n, String string) {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("TIFFField");
        iIOMetadataNode.setAttribute("number", Integer.toString(n));
        iIOMetadataNode.setAttribute("name", string);
        return iIOMetadataNode;
    }

    @Override
    protected IIOMetadata createStreamMetadata(ImageWriter imageWriter, ImageWriteParam imageWriteParam, ImageWriterParams imageWriterParams) {
        Endianness endianness;
        Endianness endianness2 = endianness = imageWriterParams != null ? imageWriterParams.getEndianness() : Endianness.DEFAULT;
        if (endianness == Endianness.DEFAULT || endianness == null) {
            return super.createStreamMetadata(imageWriter, imageWriteParam, imageWriterParams);
        }
        IIOMetadata iIOMetadata = imageWriter.getDefaultStreamMetadata(imageWriteParam);
        if (iIOMetadata != null) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(iIOMetadata.getMetadataFormatNames()));
            this.setFromTree(hashSet, iIOMetadata, endianness, SUN_TIFF_NATIVE_STREAM_FORMAT);
            this.setFromTree(hashSet, iIOMetadata, endianness, JAVA_TIFF_NATIVE_STREAM_FORMAT);
        }
        return iIOMetadata;
    }

    private void setFromTree(Set<String> set, IIOMetadata iIOMetadata, Endianness endianness, String string) {
        if (set.contains(string)) {
            Node node = iIOMetadata.getAsTree(string);
            node.getFirstChild().getAttributes().item(0).setNodeValue(endianness.toString());
            try {
                iIOMetadata.setFromTree(string, node);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                throw new IllegalStateException("Could not replace TIFF stream metadata: " + iIOInvalidTreeException.getMessage(), iIOInvalidTreeException);
            }
        }
    }
}

