/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.spi.ImageConverter;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;
import org.apache.xmlgraphics.image.loader.spi.ImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.spi.ImagePreloader;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.apache.xmlgraphics.util.Service;

public class ImageImplRegistry {
    protected static final Log log = LogFactory.getLog(ImageImplRegistry.class);
    public static final int INFINITE_PENALTY = Integer.MAX_VALUE;
    private List preloaders = new ArrayList();
    private int lastPreloaderIdentifier;
    private int lastPreloaderSort;
    private Map loaders = new HashMap();
    private List converters = new ArrayList();
    private int converterModifications;
    private Map additionalPenalties = new HashMap();
    private static ImageImplRegistry defaultInstance = new ImageImplRegistry();

    public ImageImplRegistry(boolean bl) {
        if (bl) {
            this.discoverClasspathImplementations();
        }
    }

    public ImageImplRegistry() {
        this(true);
    }

    public static ImageImplRegistry getDefaultInstance() {
        return defaultInstance;
    }

    public void discoverClasspathImplementations() {
        Iterator<Object> iterator = Service.providers(ImagePreloader.class);
        while (iterator.hasNext()) {
            this.registerPreloader((ImagePreloader)iterator.next());
        }
        iterator = Service.providers(ImageLoaderFactory.class);
        while (iterator.hasNext()) {
            this.registerLoaderFactory((ImageLoaderFactory)iterator.next());
        }
        iterator = Service.providers(ImageConverter.class);
        while (iterator.hasNext()) {
            this.registerConverter((ImageConverter)iterator.next());
        }
    }

    public void registerPreloader(ImagePreloader imagePreloader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered " + imagePreloader.getClass().getName() + " with priority " + imagePreloader.getPriority()));
        }
        this.preloaders.add(this.newPreloaderHolder(imagePreloader));
    }

    private synchronized PreloaderHolder newPreloaderHolder(ImagePreloader imagePreloader) {
        PreloaderHolder preloaderHolder = new PreloaderHolder();
        preloaderHolder.preloader = imagePreloader;
        preloaderHolder.identifier = ++this.lastPreloaderIdentifier;
        return preloaderHolder;
    }

    private synchronized void sortPreloaders() {
        if (this.lastPreloaderIdentifier != this.lastPreloaderSort) {
            Collections.sort(this.preloaders, new Comparator(){

                public int compare(Object object, Object object2) {
                    PreloaderHolder preloaderHolder = (PreloaderHolder)object;
                    long l = preloaderHolder.preloader.getPriority();
                    PreloaderHolder preloaderHolder2 = (PreloaderHolder)object2;
                    int n = preloaderHolder2.preloader.getPriority();
                    int n2 = Penalty.truncate((l += (long)ImageImplRegistry.this.getAdditionalPenalty(preloaderHolder.preloader.getClass().getName()).getValue()) - (long)(n += ImageImplRegistry.this.getAdditionalPenalty(preloaderHolder2.preloader.getClass().getName()).getValue()));
                    if (n2 != 0) {
                        return n2;
                    }
                    n2 = preloaderHolder.identifier - preloaderHolder2.identifier;
                    return n2;
                }
            });
            this.lastPreloaderSort = this.lastPreloaderIdentifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLoaderFactory(ImageLoaderFactory imageLoaderFactory) {
        String[] stringArray;
        if (!imageLoaderFactory.isAvailable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ImageLoaderFactory reports not available: " + imageLoaderFactory.getClass().getName()));
            }
            return;
        }
        for (String string : stringArray = imageLoaderFactory.getSupportedMIMETypes()) {
            Map map = this.loaders;
            synchronized (map) {
                ImageFlavor[] imageFlavorArray;
                HashMap<ImageFlavor, ArrayList<ImageLoaderFactory>> hashMap = (HashMap<ImageFlavor, ArrayList<ImageLoaderFactory>>)this.loaders.get(string);
                if (hashMap == null) {
                    hashMap = new HashMap<ImageFlavor, ArrayList<ImageLoaderFactory>>();
                    this.loaders.put(string, hashMap);
                }
                for (ImageFlavor imageFlavor : imageFlavorArray = imageLoaderFactory.getSupportedFlavors(string)) {
                    ArrayList<ImageLoaderFactory> arrayList = (ArrayList<ImageLoaderFactory>)hashMap.get(imageFlavor);
                    if (arrayList == null) {
                        arrayList = new ArrayList<ImageLoaderFactory>();
                        hashMap.put(imageFlavor, arrayList);
                    }
                    arrayList.add(imageLoaderFactory);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Registered " + imageLoaderFactory.getClass().getName() + ": MIME = " + string + ", Flavor = " + imageFlavor));
                }
            }
        }
    }

    public Collection getImageConverters() {
        return Collections.unmodifiableList(this.converters);
    }

    public int getImageConverterModifications() {
        return this.converterModifications;
    }

    public void registerConverter(ImageConverter imageConverter) {
        this.converters.add(imageConverter);
        ++this.converterModifications;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registered: " + imageConverter.getClass().getName()));
        }
    }

    public Iterator getPreloaderIterator() {
        this.sortPreloaders();
        Iterator iterator = this.preloaders.iterator();
        MyIterator myIterator = new MyIterator();
        myIterator.iter = iterator;
        return myIterator;
    }

    public ImageLoaderFactory getImageLoaderFactory(ImageInfo imageInfo, ImageFlavor imageFlavor) {
        List list;
        String string = imageInfo.getMimeType();
        Map map = (Map)this.loaders.get(string);
        if (map != null && (list = (List)map.get(imageFlavor)) != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            int n = Integer.MAX_VALUE;
            ImageLoaderFactory imageLoaderFactory = null;
            while (iterator.hasNext()) {
                ImageLoader imageLoader;
                int n2;
                ImageLoaderFactory imageLoaderFactory2 = (ImageLoaderFactory)iterator.next();
                if (!imageLoaderFactory2.isSupported(imageInfo) || (n2 = (imageLoader = imageLoaderFactory2.newImageLoader(imageFlavor)).getUsagePenalty()) >= n) continue;
                n = n2;
                imageLoaderFactory = imageLoaderFactory2;
            }
            return imageLoaderFactory;
        }
        return null;
    }

    public ImageLoaderFactory[] getImageLoaderFactories(ImageInfo imageInfo, ImageFlavor imageFlavor) {
        String string = imageInfo.getMimeType();
        TreeSet<ImageLoaderFactory> treeSet = new TreeSet<ImageLoaderFactory>(new ImageLoaderFactoryComparator(imageFlavor));
        imageInfo.getCustomObjects().put("additionalPenalties", this.additionalPenalties);
        Map map = (Map)this.loaders.get(string);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                List list;
                Map.Entry entry2 = entry;
                ImageFlavor imageFlavor2 = (ImageFlavor)entry2.getKey();
                if (!imageFlavor2.isCompatible(imageFlavor) || (list = (List)entry2.getValue()) == null || list.size() <= 0) continue;
                for (Object e : list) {
                    ImageLoaderFactory imageLoaderFactory = (ImageLoaderFactory)e;
                    if (!imageLoaderFactory.isSupported(imageInfo)) continue;
                    treeSet.add(imageLoaderFactory);
                }
            }
        }
        if (treeSet.size() == 0) {
            return null;
        }
        return treeSet.toArray(new ImageLoaderFactory[treeSet.size()]);
    }

    public ImageLoaderFactory[] getImageLoaderFactories(String string) {
        Map map = (Map)this.loaders.get(string);
        if (map != null) {
            HashSet hashSet = new HashSet();
            for (Object v : map.values()) {
                List list = (List)v;
                hashSet.addAll(list);
            }
            int n = hashSet.size();
            if (n > 0) {
                return hashSet.toArray(new ImageLoaderFactory[n]);
            }
        }
        return new ImageLoaderFactory[0];
    }

    public void setAdditionalPenalty(String string, Penalty penalty) {
        if (penalty != null) {
            this.additionalPenalties.put(string, penalty);
        } else {
            this.additionalPenalties.remove(string);
        }
        this.lastPreloaderSort = -1;
    }

    public Penalty getAdditionalPenalty(String string) {
        Penalty penalty = (Penalty)this.additionalPenalties.get(string);
        return penalty != null ? penalty : Penalty.ZERO_PENALTY;
    }

    private class ImageLoaderFactoryComparator
    implements Comparator {
        private ImageFlavor targetFlavor;

        public ImageLoaderFactoryComparator(ImageFlavor imageFlavor) {
            this.targetFlavor = imageFlavor;
        }

        public int compare(Object object, Object object2) {
            ImageLoaderFactory imageLoaderFactory = (ImageLoaderFactory)object;
            ImageLoader imageLoader = imageLoaderFactory.newImageLoader(this.targetFlavor);
            long l = imageLoader.getUsagePenalty();
            ImageLoaderFactory imageLoaderFactory2 = (ImageLoaderFactory)object2;
            ImageLoader imageLoader2 = imageLoaderFactory2.newImageLoader(this.targetFlavor);
            long l2 = ImageImplRegistry.this.getAdditionalPenalty(imageLoader2.getClass().getName()).getValue();
            return Penalty.truncate((l += (long)ImageImplRegistry.this.getAdditionalPenalty(imageLoader.getClass().getName()).getValue()) - l2);
        }
    }

    static class MyIterator
    implements Iterator {
        Iterator iter;

        MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            Object e = this.iter.next();
            if (e != null) {
                return ((PreloaderHolder)e).preloader;
            }
            return null;
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    private static class PreloaderHolder {
        private ImagePreloader preloader;
        private int identifier;

        private PreloaderHolder() {
        }

        public String toString() {
            return this.preloader + " " + this.identifier;
        }
    }
}

