/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.pipeline;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.impl.CompositeImageLoader;
import org.apache.xmlgraphics.image.loader.pipeline.ImageConversionEdge;
import org.apache.xmlgraphics.image.loader.pipeline.ImageProviderPipeline;
import org.apache.xmlgraphics.image.loader.pipeline.ImageRepresentation;
import org.apache.xmlgraphics.image.loader.spi.ImageConverter;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;
import org.apache.xmlgraphics.image.loader.spi.ImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.apache.xmlgraphics.util.dijkstra.DefaultEdgeDirectory;
import org.apache.xmlgraphics.util.dijkstra.DijkstraAlgorithm;
import org.apache.xmlgraphics.util.dijkstra.Vertex;

public class PipelineFactory {
    protected static final Log log = LogFactory.getLog(PipelineFactory.class);
    private ImageManager manager;
    private int converterEdgeDirectoryVersion = -1;
    private DefaultEdgeDirectory converterEdgeDirectory;

    public PipelineFactory(ImageManager imageManager) {
        this.manager = imageManager;
    }

    private DefaultEdgeDirectory getEdgeDirectory() {
        ImageImplRegistry imageImplRegistry = this.manager.getRegistry();
        if (imageImplRegistry.getImageConverterModifications() != this.converterEdgeDirectoryVersion) {
            Collection collection = imageImplRegistry.getImageConverters();
            DefaultEdgeDirectory defaultEdgeDirectory = new DefaultEdgeDirectory();
            for (Object e : collection) {
                ImageConverter imageConverter = (ImageConverter)e;
                Penalty penalty = Penalty.toPenalty(imageConverter.getConversionPenalty());
                penalty = penalty.add(imageImplRegistry.getAdditionalPenalty(imageConverter.getClass().getName()));
                defaultEdgeDirectory.addEdge(new ImageConversionEdge(imageConverter, penalty));
            }
            this.converterEdgeDirectoryVersion = imageImplRegistry.getImageConverterModifications();
            this.converterEdgeDirectory = defaultEdgeDirectory;
        }
        return this.converterEdgeDirectory;
    }

    public ImageProviderPipeline newImageConverterPipeline(Image image, ImageFlavor imageFlavor) {
        DefaultEdgeDirectory defaultEdgeDirectory = this.getEdgeDirectory();
        ImageRepresentation imageRepresentation = new ImageRepresentation(imageFlavor);
        ImageProviderPipeline imageProviderPipeline = this.findPipeline(defaultEdgeDirectory, image.getFlavor(), imageRepresentation);
        return imageProviderPipeline;
    }

    public ImageProviderPipeline newImageConverterPipeline(ImageInfo imageInfo, ImageFlavor imageFlavor) {
        ImageProviderPipeline[] imageProviderPipelineArray = this.determineCandidatePipelines(imageInfo, imageFlavor);
        if (imageProviderPipelineArray.length > 0) {
            Arrays.sort(imageProviderPipelineArray, new PipelineComparator());
            ImageProviderPipeline imageProviderPipeline = imageProviderPipelineArray[0];
            if (imageProviderPipeline != null && log.isDebugEnabled()) {
                log.debug((Object)("Pipeline: " + imageProviderPipeline + " with penalty " + imageProviderPipeline.getConversionPenalty()));
            }
            return imageProviderPipeline;
        }
        return null;
    }

    public ImageProviderPipeline[] determineCandidatePipelines(ImageInfo imageInfo, ImageFlavor imageFlavor) {
        String string = imageInfo.getMimeType();
        ImageImplRegistry imageImplRegistry = this.manager.getRegistry();
        ArrayList<ImageProviderPipeline> arrayList = new ArrayList<ImageProviderPipeline>();
        DefaultEdgeDirectory defaultEdgeDirectory = this.getEdgeDirectory();
        ImageLoaderFactory[] imageLoaderFactoryArray = imageImplRegistry.getImageLoaderFactories(imageInfo, imageFlavor);
        if (imageLoaderFactoryArray != null) {
            ImageLoader imageLoader;
            if (imageLoaderFactoryArray.length == 1) {
                imageLoader = imageLoaderFactoryArray[0].newImageLoader(imageFlavor);
            } else {
                int n = imageLoaderFactoryArray.length;
                ImageLoader[] imageLoaderArray = new ImageLoader[n];
                for (int i = 0; i < n; ++i) {
                    imageLoaderArray[i] = imageLoaderFactoryArray[i].newImageLoader(imageFlavor);
                }
                imageLoader = new CompositeImageLoader(imageLoaderArray);
            }
            ImageProviderPipeline imageProviderPipeline = new ImageProviderPipeline(this.manager.getCache(), imageLoader);
            arrayList.add(imageProviderPipeline);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("No ImageLoaderFactory found that can load this format (" + imageFlavor + ") directly. Trying ImageConverters instead..."));
            }
            ImageRepresentation imageRepresentation = new ImageRepresentation(imageFlavor);
            imageLoaderFactoryArray = imageImplRegistry.getImageLoaderFactories(string);
            if (imageLoaderFactoryArray != null) {
                for (ImageLoaderFactory imageLoaderFactory : imageLoaderFactoryArray) {
                    ImageFlavor[] imageFlavorArray;
                    for (ImageFlavor imageFlavor2 : imageFlavorArray = imageLoaderFactory.getSupportedFlavors(string)) {
                        ImageProviderPipeline imageProviderPipeline = this.findPipeline(defaultEdgeDirectory, imageFlavor2, imageRepresentation);
                        if (imageProviderPipeline == null) continue;
                        ImageLoader imageLoader = imageLoaderFactory.newImageLoader(imageFlavor2);
                        imageProviderPipeline.setImageLoader(imageLoader);
                        arrayList.add(imageProviderPipeline);
                    }
                }
            }
        }
        return arrayList.toArray(new ImageProviderPipeline[arrayList.size()]);
    }

    private ImageProviderPipeline findPipeline(DefaultEdgeDirectory defaultEdgeDirectory, ImageFlavor imageFlavor, ImageRepresentation imageRepresentation) {
        Object object;
        DijkstraAlgorithm dijkstraAlgorithm = new DijkstraAlgorithm(defaultEdgeDirectory);
        ImageRepresentation imageRepresentation2 = new ImageRepresentation(imageFlavor);
        dijkstraAlgorithm.execute(imageRepresentation2, imageRepresentation);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Lowest penalty: " + dijkstraAlgorithm.getLowestPenalty(imageRepresentation)));
        }
        Vertex vertex = imageRepresentation;
        Vertex vertex2 = dijkstraAlgorithm.getPredecessor(imageRepresentation);
        if (vertex2 == null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"No route found!");
            }
            return null;
        }
        LinkedList<ImageConversionEdge> linkedList = new LinkedList<ImageConversionEdge>();
        while ((vertex2 = dijkstraAlgorithm.getPredecessor(vertex)) != null) {
            object = (ImageConversionEdge)defaultEdgeDirectory.getBestEdge(vertex2, vertex);
            linkedList.addFirst((ImageConversionEdge)object);
            vertex = vertex2;
        }
        object = new ImageProviderPipeline(this.manager.getCache(), null);
        for (Object e : linkedList) {
            ImageConversionEdge imageConversionEdge = (ImageConversionEdge)e;
            ((ImageProviderPipeline)object).addConverter(imageConversionEdge.getImageConverter());
        }
        return object;
    }

    public ImageProviderPipeline[] determineCandidatePipelines(ImageInfo imageInfo, ImageFlavor[] imageFlavorArray) {
        ArrayList<ImageProviderPipeline> arrayList = new ArrayList<ImageProviderPipeline>();
        for (ImageFlavor imageFlavor : imageFlavorArray) {
            Penalty penalty;
            ImageProviderPipeline imageProviderPipeline = this.newImageConverterPipeline(imageInfo, imageFlavor);
            if (imageProviderPipeline == null || (penalty = imageProviderPipeline.getConversionPenalty(this.manager.getRegistry())).isInfinitePenalty()) continue;
            arrayList.add(imageProviderPipeline);
        }
        return arrayList.toArray(new ImageProviderPipeline[arrayList.size()]);
    }

    public ImageProviderPipeline[] determineCandidatePipelines(Image image, ImageFlavor[] imageFlavorArray) {
        ArrayList<ImageProviderPipeline> arrayList = new ArrayList<ImageProviderPipeline>();
        for (ImageFlavor imageFlavor : imageFlavorArray) {
            ImageProviderPipeline imageProviderPipeline = this.newImageConverterPipeline(image, imageFlavor);
            if (imageProviderPipeline == null) continue;
            arrayList.add(imageProviderPipeline);
        }
        return arrayList.toArray(new ImageProviderPipeline[arrayList.size()]);
    }

    private static class PipelineComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1161513617996198090L;

        private PipelineComparator() {
        }

        public int compare(Object object, Object object2) {
            ImageProviderPipeline imageProviderPipeline = (ImageProviderPipeline)object;
            ImageProviderPipeline imageProviderPipeline2 = (ImageProviderPipeline)object2;
            return imageProviderPipeline.getConversionPenalty() - imageProviderPipeline2.getConversionPenalty();
        }
    }
}

