/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.util.Map;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageLoaderFactory;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRaw;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageLoaderRawPNG;
import org.apache.xmlgraphics.image.loader.spi.ImageLoader;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageLoaderFactoryRaw
extends AbstractImageLoaderFactory {
    public static final String MIME_EMF = "image/x-emf";
    private static final String[] MIMES = new String[]{"image/png", "image/jpeg", "image/tiff", "image/x-emf"};
    private static final ImageFlavor[][] FLAVORS = new ImageFlavor[][]{{ImageFlavor.RAW_PNG}, {ImageFlavor.RAW_JPEG}, {ImageFlavor.RAW_TIFF}, {ImageFlavor.RAW_EMF}};

    public static String getMimeForRawFlavor(ImageFlavor imageFlavor) {
        int n = FLAVORS.length;
        for (int i = 0; i < n; ++i) {
            int n2 = FLAVORS[i].length;
            for (int j = 0; j < n2; ++j) {
                if (!FLAVORS[i][j].equals(imageFlavor)) continue;
                return MIMES[i];
            }
        }
        throw new IllegalArgumentException("ImageFlavor is not a \"raw\" flavor: " + imageFlavor);
    }

    @Override
    public String[] getSupportedMIMETypes() {
        return MIMES;
    }

    @Override
    public ImageFlavor[] getSupportedFlavors(String string) {
        int n = MIMES.length;
        for (int i = 0; i < n; ++i) {
            if (!MIMES[i].equals(string)) continue;
            return FLAVORS[i];
        }
        throw new IllegalArgumentException("Unsupported MIME type: " + string);
    }

    @Override
    public ImageLoader newImageLoader(ImageFlavor imageFlavor) {
        if (imageFlavor.equals(ImageFlavor.RAW_JPEG)) {
            return new ImageLoaderRawJPEG();
        }
        if (imageFlavor.equals(ImageFlavor.RAW_PNG)) {
            return new ImageLoaderRawPNG();
        }
        return new ImageLoaderRaw(imageFlavor);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isSupported(ImageInfo imageInfo) {
        if ("image/png".equals(imageInfo.getMimeType())) {
            IIOMetadata iIOMetadata;
            Map map = (Map)imageInfo.getCustomObjects().get("additionalPenalties");
            int n = 0;
            Penalty penalty = (Penalty)map.get(ImageLoaderRawPNG.class.getName());
            if (penalty != null) {
                n = penalty.getValue();
            }
            if ((iIOMetadata = (IIOMetadata)imageInfo.getCustomObjects().get(IIOMetadata.class)) != null) {
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_png_1.0").getChildNodes();
                NamedNodeMap namedNodeMap = iIOMetadataNode.getElementsByTagName("IHDR").item(0).getAttributes();
                String string = namedNodeMap.getNamedItem("bitDepth").getNodeValue();
                String string2 = namedNodeMap.getNamedItem("interlaceMethod").getNodeValue();
                String string3 = namedNodeMap.getNamedItem("colorType").getNodeValue();
                if (!string.equals("8") || !string2.equals("none") || (string3.equals("RGBAlpha") || string3.equals("GrayAlpha")) && n >= 0) {
                    return false;
                }
                iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree("javax_imageio_1.0").getChildNodes();
                Node node = iIOMetadataNode.getElementsByTagName("NumChannels").item(0);
                String string4 = node.getAttributes().getNamedItem("value").getNodeValue();
                if ("4".equals(string4) && "Palette".equals(string3) && n >= 0) {
                    return false;
                }
            }
        }
        return true;
    }
}

