/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Map;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImageConverter;
import org.apache.xmlgraphics.image.loader.impl.ImageBuffered;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;
import org.apache.xmlgraphics.java2d.color.DeviceCMYKColorSpace;
import org.apache.xmlgraphics.util.UnitConv;

public class ImageConverterG2D2Bitmap
extends AbstractImageConverter {
    @Override
    public Image convert(Image image, Map map) {
        this.checkSourceFlavor(image);
        assert (image instanceof ImageGraphics2D);
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        Object v = map.get(ImageProcessingHints.BITMAP_TYPE_INTENT);
        int n = 24;
        if ("gray".equals(v)) {
            n = 8;
        } else if ("mono".equals(v)) {
            n = 1;
        }
        Object v2 = map.get(ImageProcessingHints.TRANSPARENCY_INTENT);
        boolean bl = true;
        if ("ignore".equals(v2)) {
            bl = false;
        }
        int n2 = 300;
        Number number = (Number)map.get(ImageProcessingHints.TARGET_RESOLUTION);
        if (number != null) {
            n2 = number.intValue();
        }
        boolean bl2 = Boolean.TRUE.equals(map.get("CMYK"));
        BufferedImage bufferedImage = this.paintToBufferedImage(imageGraphics2D, n, bl, n2, bl2);
        ImageBuffered imageBuffered = new ImageBuffered(image.getInfo(), bufferedImage, null);
        return imageBuffered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage paintToBufferedImage(ImageGraphics2D imageGraphics2D, int n, boolean bl, int n2, boolean bl2) {
        Object object;
        BufferedImage bufferedImage;
        ImageSize imageSize = imageGraphics2D.getSize();
        RenderingHints renderingHints = null;
        int n3 = (int)Math.ceil(UnitConv.mpt2px(imageSize.getWidthMpt(), n2));
        int n4 = (int)Math.ceil(UnitConv.mpt2px(imageSize.getHeightMpt(), n2));
        switch (n) {
            case 1: {
                bufferedImage = new BufferedImage(n3, n4, 12);
                bl = false;
                renderingHints = new RenderingHints(null);
                renderingHints.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                break;
            }
            case 8: {
                if (bl) {
                    bufferedImage = ImageConverterG2D2Bitmap.createGrayBufferedImageWithAlpha(n3, n4);
                    break;
                }
                bufferedImage = new BufferedImage(n3, n4, 10);
                break;
            }
            default: {
                if (bl) {
                    bufferedImage = new BufferedImage(n3, n4, 2);
                    break;
                }
                if (bl2) {
                    object = new ComponentColorModel(new DeviceCMYKColorSpace(), false, false, 1, 0);
                    int[] nArray = new int[]{0, 1, 2, 3};
                    PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(0, n3, n4, 4, n3 * 4, nArray);
                    WritableRaster writableRaster = WritableRaster.createWritableRaster(pixelInterleavedSampleModel, new Point(0, 0));
                    bufferedImage = new BufferedImage((ColorModel)object, writableRaster, false, null);
                    break;
                }
                bufferedImage = new BufferedImage(n3, n4, 1);
            }
        }
        object = bufferedImage.createGraphics();
        try {
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            this.setRenderingHintsForBufferedImage((Graphics2D)object);
            if (renderingHints != null) {
                ((Graphics2D)object).addRenderingHints(renderingHints);
            }
            ((Graphics2D)object).setBackground(Color.white);
            ((Graphics)object).setColor(Color.black);
            if (!bl) {
                ((Graphics)object).clearRect(0, 0, n3, n4);
            }
            double d = (double)n3 / (double)imageSize.getWidthMpt();
            double d2 = (double)n4 / (double)imageSize.getHeightMpt();
            ((Graphics2D)object).scale(d, d2);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, imageSize.getWidthMpt(), imageSize.getHeightMpt());
            imageGraphics2D.getGraphics2DImagePainter().paint((Graphics2D)object, double_);
        }
        finally {
            ((Graphics)object).dispose();
        }
        return bufferedImage;
    }

    private static BufferedImage createGrayBufferedImageWithAlpha(int n, int n2) {
        boolean bl = true;
        int n3 = 2;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = 8;
        }
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, true, bl, 3, 0);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n, n2, n3, new Point(0, 0));
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, bl, null);
        return bufferedImage;
    }

    protected void setRenderingHintsForBufferedImage(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    @Override
    public ImageFlavor getSourceFlavor() {
        return ImageFlavor.GRAPHICS2D;
    }

    @Override
    public ImageFlavor getTargetFlavor() {
        return ImageFlavor.BUFFERED_IMAGE;
    }
}

