/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.xmlgraphics.image.codec.tiff.CompressionValue;
import org.apache.xmlgraphics.image.codec.tiff.ImageInfo;
import org.apache.xmlgraphics.image.codec.tiff.ImageType;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageEncoderImpl;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableOutputStream;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int[] SIZE_OF_TYPE = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    @Override
    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    public Object encodeMultiple(Object object, RenderedImage renderedImage) throws IOException {
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        if (tIFFEncodeParam.getExtraImages() != null) {
            throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder11"));
        }
        Context context = (Context)object;
        if (context == null) {
            context = new Context();
            this.writeFileHeader();
        } else {
            context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, false);
        }
        context.nextImage = renderedImage;
        return context;
    }

    public void finishMultiple(Object object) throws IOException {
        if (object == null) {
            throw new NullPointerException();
        }
        Context context = (Context)object;
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        char c;
        int n7;
        CompressionValue compressionValue = tIFFEncodeParam.getCompression();
        if (compressionValue == CompressionValue.JPEG_TTN2) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFImageEncoder12"));
        }
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n8 = renderedImage.getMinX();
        int n9 = renderedImage.getMinY();
        int n10 = renderedImage.getWidth();
        int n11 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int[] nArray = sampleModel.getSampleSize();
        int n12 = nArray[0];
        int n13 = sampleModel.getNumBands();
        int n14 = sampleModel.getDataType();
        this.validateImage(n12, nArray, n13, n14, colorModel);
        boolean bl3 = n14 == 2 || n14 == 1;
        ImageInfo imageInfo = ImageInfo.newInstance(renderedImage, n12, n13, colorModel, tIFFEncodeParam);
        if (imageInfo.getType() == ImageType.UNSUPPORTED) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder8"));
        }
        int n15 = imageInfo.getNumTiles();
        long l = imageInfo.getBytesPerTile();
        long l2 = imageInfo.getBytesPerRow();
        int n16 = imageInfo.getTileHeight();
        int n17 = imageInfo.getTileWidth();
        long[] lArray = new long[n15];
        for (int i = 0; i < n15; ++i) {
            lArray[i] = l;
        }
        if (!bl2) {
            long l3 = n11 - n16 * (n15 - 1);
            lArray[n15 - 1] = l3 * l2;
        }
        long l4 = l * (long)(n15 - 1) + lArray[n15 - 1];
        long[] lArray2 = new long[n15];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n10}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n11}));
        char[] cArray = new char[n13];
        for (n7 = 0; n7 < n13; ++n7) {
            cArray[n7] = (char)n12;
        }
        treeSet.add(new TIFFField(258, 3, n13, cArray));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)compressionValue.getValue()}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)imageInfo.getType().getPhotometricInterpretation()}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n15, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n13}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n16}));
            treeSet.add(new TIFFField(279, 4, n15, lArray));
        }
        if (imageInfo.getColormap() != null) {
            treeSet.add(new TIFFField(320, 3, imageInfo.getColormapSize(), imageInfo.getColormap()));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n17}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n16}));
            treeSet.add(new TIFFField(324, 4, n15, lArray2));
            treeSet.add(new TIFFField(325, 4, n15, lArray));
        }
        if (imageInfo.getNumberOfExtraSamples() > 0) {
            char[] cArray2 = new char[imageInfo.getNumberOfExtraSamples()];
            for (c = '\u0000'; c < imageInfo.getNumberOfExtraSamples(); ++c) {
                cArray2[c] = (char)imageInfo.getExtraSamplesType().getValue();
            }
            treeSet.add(new TIFFField(338, 3, imageInfo.getNumberOfExtraSamples(), cArray2));
        }
        if (n14 != 0) {
            char[] cArray3 = new char[n13];
            cArray3[0] = n14 == 4 ? 3 : (n14 == 1 ? 1 : 2);
            for (c = '\u0001'; c < n13; ++c) {
                cArray3[c] = cArray3[0];
            }
            treeSet.add(new TIFFField(339, 3, n13, cArray3));
        }
        if (imageInfo.getType() == ImageType.YCBCR) {
            n7 = 1;
            c = '\u0001';
            treeSet.add(new TIFFField(530, 3, 2, new char[]{n7, c}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{(char)(compressionValue == CompressionValue.JPEG_TTN2 ? 1 : 2)}));
            long[][] object = new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object));
        }
        TIFFField[] tIFFFieldArray = tIFFEncodeParam.getExtraFields();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeSet.size());
        for (TIFFField outputStream : treeSet) {
            arrayList.add(outputStream.getTag());
        }
        for (TIFFField tIFFField : tIFFFieldArray) {
            Integer n18 = tIFFField.getTag();
            if (arrayList.contains(n18)) continue;
            treeSet.add(tIFFField);
            arrayList.add(n18);
        }
        int n19 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n19;
        OutputStream outputStream = null;
        byte[] byArray = null;
        Object var37_47 = null;
        int n20 = 0;
        boolean bl4 = false;
        Deflater deflater = null;
        boolean bl5 = false;
        if (compressionValue == CompressionValue.NONE) {
            int n21;
            n6 = 0;
            if (n12 == 16 && lArray2[0] % 2L != 0L) {
                n6 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (n12 == 32 && lArray2[0] % 4L != 0L) {
                n6 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)n6;
            }
            for (n21 = 1; n21 < n15; ++n21) {
                lArray2[n21] = lArray2[n21 - 1] + lArray[n21 - 1];
            }
            if (!bl && ((n20 = (int)(lArray2[0] + l4)) & 1) != 0) {
                ++n20;
                bl4 = true;
            }
            this.writeDirectory(n, treeSet, n20);
            if (n6 != 0) {
                for (n21 = 0; n21 < n6; ++n21) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                outputStream = this.output;
                try {
                    File file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (IOException iOException) {
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            n6 = 0;
            switch (compressionValue) {
                case PACKBITS: {
                    n6 = (int)(l + (l2 + 127L) / 128L * (long)n16);
                    break;
                }
                case DEFLATE: {
                    n6 = (int)l;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    n6 = 0;
                }
            }
            if (n6 != 0) {
                byArray = new byte[n6];
            }
        }
        int[] nArray2 = null;
        float[] fArray = null;
        boolean bl6 = n12 == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n14 == 0 || n12 == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray2 = null;
        if (compressionValue != CompressionValue.JPEG_TTN2) {
            if (n14 == 0) {
                byArray2 = new byte[n16 * n17 * n13];
            } else if (bl3) {
                byArray2 = new byte[2 * n16 * n17 * n13];
            } else if (n14 == 3 || n14 == 4) {
                byArray2 = new byte[4 * n16 * n17 * n13];
            }
        }
        int n22 = n9 + n11;
        int n23 = n8 + n10;
        int n24 = 0;
        for (n5 = n9; n5 < n22; n5 += n16) {
            n4 = bl2 ? n16 : Math.min(n16, n22 - n5);
            n3 = n4 * n17 * n13;
            block25: for (n2 = n8; n2 < n23; n2 += n17) {
                int n25;
                int n26;
                int n27;
                Raster raster = renderedImage.getData(new Rectangle(n2, n5, n17, n4));
                boolean bl7 = false;
                if (compressionValue != CompressionValue.JPEG_TTN2) {
                    if (bl6) {
                        if (n12 == 8) {
                            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray3 = componentSampleModel.getBankIndices();
                            int[] nArray4 = componentSampleModel.getBandOffsets();
                            n27 = componentSampleModel.getPixelStride();
                            n26 = componentSampleModel.getScanlineStride();
                            if (n27 != n13 || (long)n26 != l2) {
                                bl7 = false;
                            } else {
                                bl7 = true;
                                for (n25 = 0; bl7 && n25 < n13; ++n25) {
                                    if (nArray3[n25] == 0 && nArray4[n25] == n25) continue;
                                    bl7 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl7 = true;
                            }
                        }
                    }
                    if (!bl7) {
                        if (n14 == 4) {
                            fArray = raster.getPixels(n2, n5, n17, n4, fArray);
                        } else {
                            nArray2 = raster.getPixels(n2, n5, n17, n4, nArray2);
                        }
                    }
                }
                int n28 = 0;
                int n29 = 0;
                switch (n12) {
                    case 1: {
                        int n30;
                        int n31;
                        int n32;
                        if (bl7) {
                            byte[] byArray3 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n25 = multiPixelPackedSampleModel.getScanlineStride();
                            n32 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                            if ((long)n25 == l2) {
                                System.arraycopy(byArray3, n32, byArray2, 0, (int)l2 * n4);
                            } else {
                                n31 = 0;
                                for (n30 = 0; n30 < n4; ++n30) {
                                    System.arraycopy(byArray3, n32, byArray2, n31, (int)l2);
                                    n32 += n25;
                                    n31 += (int)l2;
                                }
                            }
                        } else {
                            int n33 = 0;
                            for (n27 = 0; n27 < n4; ++n27) {
                                for (n26 = 0; n26 < n17 / 8; ++n26) {
                                    n28 = nArray2[n33++] << 7 | nArray2[n33++] << 6 | nArray2[n33++] << 5 | nArray2[n33++] << 4 | nArray2[n33++] << 3 | nArray2[n33++] << 2 | nArray2[n33++] << 1 | nArray2[n33++];
                                    byArray2[n29++] = (byte)n28;
                                }
                                if (n17 % 8 <= 0) continue;
                                n28 = 0;
                                for (n26 = 0; n26 < n17 % 8; ++n26) {
                                    n28 |= nArray2[n33++] << 7 - n26;
                                }
                                byArray2[n29++] = (byte)n28;
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n4 * ((n17 + 7) / 8));
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            int n34 = TIFFImageEncoder.compressPackBits(byArray2, n4, l2, byArray);
                            lArray[n24++] = n34;
                            this.output.write(byArray, 0, n34);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        int n35 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n24++] = n35;
                        this.output.write(byArray, 0, n35);
                        continue block25;
                    }
                    case 4: {
                        int n36 = 0;
                        for (n27 = 0; n27 < n4; ++n27) {
                            for (n26 = 0; n26 < n17 / 2; ++n26) {
                                n28 = nArray2[n36++] << 4 | nArray2[n36++];
                                byArray2[n29++] = (byte)n28;
                            }
                            if ((n17 & 1) != 1) continue;
                            n28 = nArray2[n36++] << 4;
                            byArray2[n29++] = (byte)n28;
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n4 * ((n17 + 1) / 2));
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n27 = TIFFImageEncoder.compressPackBits(byArray2, n4, l2, byArray);
                            lArray[n24++] = n27;
                            this.output.write(byArray, 0, n27);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n27 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n24++] = n27;
                        this.output.write(byArray, 0, n27);
                        continue block25;
                    }
                    case 8: {
                        int n30;
                        int n31;
                        int n32;
                        if (compressionValue != CompressionValue.JPEG_TTN2) {
                            if (bl7) {
                                byte[] byArray4 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n25 = componentSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n5 - raster.getSampleModelTranslateY());
                                n32 = componentSampleModel.getScanlineStride();
                                if ((long)n32 == l2) {
                                    System.arraycopy(byArray4, n25, byArray2, 0, (int)l2 * n4);
                                } else {
                                    n31 = 0;
                                    for (n30 = 0; n30 < n4; ++n30) {
                                        System.arraycopy(byArray4, n25, byArray2, n31, (int)l2);
                                        n25 += n32;
                                        n31 += (int)l2;
                                    }
                                }
                            } else {
                                for (n27 = 0; n27 < n3; ++n27) {
                                    byArray2[n27] = (byte)nArray2[n27];
                                }
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n3);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n27 = TIFFImageEncoder.compressPackBits(byArray2, n4, l2, byArray);
                            lArray[n24++] = n27;
                            this.output.write(byArray, 0, n27);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n27 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n24++] = n27;
                        this.output.write(byArray, 0, n27);
                        continue block25;
                    }
                    case 16: {
                        n27 = 0;
                        for (n26 = 0; n26 < n3; ++n26) {
                            n25 = nArray2[n26];
                            byArray2[n27++] = (byte)((n25 & 0xFF00) >> 8);
                            byArray2[n27++] = (byte)(n25 & 0xFF);
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n3 * 2);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n26 = TIFFImageEncoder.compressPackBits(byArray2, n4, l2, byArray);
                            lArray[n24++] = n26;
                            this.output.write(byArray, 0, n26);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n26 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n24++] = n26;
                        this.output.write(byArray, 0, n26);
                        continue block25;
                    }
                    case 32: {
                        int n32;
                        if (n14 == 3) {
                            n26 = 0;
                            for (n25 = 0; n25 < n3; ++n25) {
                                n32 = nArray2[n25];
                                byArray2[n26++] = (byte)((n32 & 0xFF000000) >>> 24);
                                byArray2[n26++] = (byte)((n32 & 0xFF0000) >>> 16);
                                byArray2[n26++] = (byte)((n32 & 0xFF00) >>> 8);
                                byArray2[n26++] = (byte)(n32 & 0xFF);
                            }
                        } else {
                            n26 = 0;
                            for (n25 = 0; n25 < n3; ++n25) {
                                n32 = Float.floatToIntBits(fArray[n25]);
                                byArray2[n26++] = (byte)((n32 & 0xFF000000) >>> 24);
                                byArray2[n26++] = (byte)((n32 & 0xFF0000) >>> 16);
                                byArray2[n26++] = (byte)((n32 & 0xFF00) >>> 8);
                                byArray2[n26++] = (byte)(n32 & 0xFF);
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray2, 0, n3 * 4);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n26 = TIFFImageEncoder.compressPackBits(byArray2, n4, l2, byArray);
                            lArray[n24++] = n26;
                            this.output.write(byArray, 0, n26);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n26 = TIFFImageEncoder.deflate(deflater, byArray2, byArray);
                        lArray[n24++] = n26;
                        this.output.write(byArray, 0, n26);
                        continue block25;
                    }
                }
            }
        }
        if (compressionValue == CompressionValue.NONE) {
            if (bl4) {
                this.output.write(0);
            }
        } else {
            void var37_49;
            n5 = 0;
            for (n4 = 1; n4 < n15; ++n4) {
                n3 = (int)lArray[n4 - 1];
                n5 += n3;
                lArray2[n4] = lArray2[n4 - 1] + (long)n3;
            }
            int n37 = n20 = bl ? 0 : n + n19 + (n5 += (int)lArray[n15 - 1]);
            if ((n20 & 1) != 0) {
                ++n20;
                bl4 = true;
            }
            if (outputStream == null) {
                if (bl4) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l3 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n20);
                seekableOutputStream.seek(l3);
            } else if (var37_49 != null) {
                try (FileInputStream fileInputStream = new FileInputStream((File)var37_49);){
                    int n38;
                    this.output.close();
                    this.output = outputStream;
                    this.writeDirectory(n, treeSet, n20);
                    byte[] byArray5 = new byte[8192];
                    for (n2 = 0; n2 < n5; n2 += n38) {
                        n38 = fileInputStream.read(byArray5);
                        if (n38 == -1) {
                            break;
                        }
                        this.output.write(byArray5, 0, n38);
                    }
                }
                boolean bl8 = var37_49.delete();
                assert (bl8);
                if (bl4) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.output;
                this.output = outputStream;
                this.writeDirectory(n, treeSet, n20);
                byteArrayOutputStream.writeTo(this.output);
                if (bl4) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder13"));
            }
        }
        return n20;
    }

    private void validateImage(int n, int[] nArray, int n2, int n3, ColorModel colorModel) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder0"));
        }
        if ((n == 1 || n == 4) && n2 != 1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder1"));
        }
        switch (n3) {
            case 0: {
                if (n != 4) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (n == 16) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (n == 32) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder5"));
            }
        }
        if (colorModel instanceof IndexColorModel && n3 != 0) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder6"));
        }
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        for (Object e : sortedSet) {
            TIFFField tIFFField = (TIFFField)e;
            int n3 = tIFFField.getCount() * SIZE_OF_TYPE[tIFFField.getType()];
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        for (Object e : sortedSet) {
            TIFFField tIFFField = (TIFFField)e;
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        for (Object e : arrayList) {
            this.writeValues((TIFFField)e);
        }
    }

    private static int getValueSize(TIFFField tIFFField) throws UnsupportedEncodingException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = tIFFField.getAsString(i).getBytes("UTF-8");
                n3 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n3;
            }
        } else {
            n3 = n2 * SIZE_OF_TYPE[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                int n3;
                byte[] byArray = tIFFField.getAsBytes();
                if (n2 > 4) {
                    n2 = 4;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    this.output.write(byArray[n3]);
                }
                for (n3 = 0; n3 < 4 - n2; ++n3) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n4;
                char[] cArray = tIFFField.getAsChars();
                if (n2 > 2) {
                    n2 = 2;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    this.writeUnsignedShort(cArray[n4]);
                }
                for (n4 = 0; n4 < 2 - n2; ++n4) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i = 0; i < n2; ++i) {
                    this.output.write(byArray[i]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(cArray[i]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(sArray[i]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i = 0; i < n2; ++i) {
                    int n3 = Float.floatToIntBits(fArray[i]);
                    this.writeLong(n3);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i = 0; i < n2; ++i) {
                    long l = Double.doubleToLongBits(dArray[i]);
                    this.writeLong(l >>> 32);
                    this.writeLong(l & 0xFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i][0]);
                    this.writeLong(lArray[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray = tIFFField.getAsString(i).getBytes("UTF-8");
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        this.output.write((n & 0xFF00) >>> 8);
        this.output.write(n & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)(l & 0xFFL));
    }

    private static int compressPackBits(byte[] byArray, int n, long l, byte[] byArray2) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 = TIFFImageEncoder.packBits(byArray, n2, (int)l, byArray2, n3);
            n2 += (int)l;
        }
        return n3;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6;
            byte by = byArray[n];
            for (n6 = 1; n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]; ++n6, ++n) {
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2]); ++n6) {
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }

    private static class Context {
        private RenderedImage nextImage;
        private int ifdOffset = 8;

        private Context() {
        }
    }
}

