/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg12;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg12.LineHeightValue;
import io.sf.carte.echosvg.css.engine.value.svg12.SVG12ValueConstants;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends LengthManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 43;
    }

    @Override
    public String getPropertyName() {
        return "line-height";
    }

    @Override
    public Value getDefaultValue() {
        return SVG12ValueConstants.NORMAL_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case IDENT: {
                String string = lexicalUnit.getStringValue().toLowerCase();
                if ("normal".equals(string)) {
                    return SVG12ValueConstants.NORMAL_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    protected int getOrientation() {
        return 1;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getCssValueType() != 1) {
            return value;
        }
        switch (value.getPrimitiveType()) {
            case 1: {
                return new LineHeightValue(1, value.getFloatValue(), true);
            }
            case 2: {
                float f = value.getFloatValue();
                int n2 = cSSEngine.getFontSizeIndex();
                float f2 = cSSEngine.getComputedStyle(cSSStylableElement, string, n2).getFloatValue();
                return new FloatValue(1, f * f2 * 0.01f);
            }
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }
}

