/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class OpacityManager
extends AbstractValueManager {
    protected boolean inherited;
    protected String property;

    public OpacityManager(String string, boolean bl) {
        this.property = string;
        this.inherited = bl;
    }

    @Override
    public boolean isInheritedProperty() {
        return this.inherited;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 25;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.NUMBER_1;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case INTEGER: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        if (s == 1) {
            return new FloatValue(s, f);
        }
        throw this.createInvalidFloatTypeDOMException(s);
    }
}

