/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css2;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class FontSizeAdjustManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 44;
    }

    @Override
    public String getPropertyName() {
        return "font-size-adjust";
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case INTEGER: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case IDENT: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lexicalUnit.getStringValue());
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(short s, String string, CSSEngine cSSEngine) throws DOMException {
        if (s != 21) {
            throw this.createInvalidStringTypeDOMException(s);
        }
        if (string.equalsIgnoreCase("none")) {
            return ValueConstants.NONE_VALUE;
        }
        throw this.createInvalidIdentifierDOMException(string);
    }

    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        if (s == 1) {
            return new FloatValue(s, f);
        }
        throw this.createInvalidFloatTypeDOMException(s);
    }
}

