/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css2;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueFactory;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.ShorthandManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import io.sf.carte.echosvg.css.engine.value.css2.FontSizeManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;

public class FontShorthandManager
extends AbstractValueFactory
implements ShorthandManager {
    static LexicalUnit NORMAL_LU;
    static LexicalUnit BOLD_LU;
    static LexicalUnit MEDIUM_LU;
    static LexicalUnit SZ_10PT_LU;
    static LexicalUnit SZ_8PT_LU;
    static LexicalUnit FONT_FAMILY_LU;
    protected static final Set<String> values;

    @Override
    public String getPropertyName() {
        return "font";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    public void handleSystemFont(CSSEngine cSSEngine, ShorthandManager.PropertyHandler propertyHandler, String string, boolean bl) {
        LexicalUnit lexicalUnit = NORMAL_LU;
        LexicalUnit lexicalUnit2 = NORMAL_LU;
        LexicalUnit lexicalUnit3 = NORMAL_LU;
        LexicalUnit lexicalUnit4 = NORMAL_LU;
        LexicalUnit lexicalUnit5 = FONT_FAMILY_LU;
        LexicalUnit lexicalUnit6 = string.equals("small-caption") ? SZ_8PT_LU : SZ_10PT_LU;
        propertyHandler.property("font-family", lexicalUnit5, bl);
        propertyHandler.property("font-style", lexicalUnit, bl);
        propertyHandler.property("font-variant", lexicalUnit2, bl);
        propertyHandler.property("font-weight", lexicalUnit3, bl);
        propertyHandler.property("font-size", lexicalUnit6, bl);
        propertyHandler.property("line-height", lexicalUnit4, bl);
    }

    @Override
    public void setValues(CSSEngine cSSEngine, ShorthandManager.PropertyHandler propertyHandler, LexicalUnit lexicalUnit, boolean bl) {
        String string;
        String string2;
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return;
            }
            case IDENT: {
                string2 = lexicalUnit.getStringValue().toLowerCase();
                if (!values.contains(string2)) break;
                this.handleSystemFont(cSSEngine, propertyHandler, string2, bl);
                return;
            }
        }
        string2 = null;
        LexicalUnit lexicalUnit2 = null;
        LexicalUnit lexicalUnit3 = null;
        LexicalUnit lexicalUnit4 = null;
        LexicalUnit lexicalUnit5 = null;
        LexicalUnit lexicalUnit6 = null;
        ValueManager[] valueManagerArray = cSSEngine.getValueManagers();
        int n = cSSEngine.getPropertyIndex("font-style");
        int n2 = cSSEngine.getPropertyIndex("font-variant");
        int n3 = cSSEngine.getPropertyIndex("font-weight");
        int n4 = cSSEngine.getPropertyIndex("font-size");
        int n5 = cSSEngine.getPropertyIndex("line-height");
        IdentifierManager identifierManager = (IdentifierManager)valueManagerArray[n];
        IdentifierManager identifierManager2 = (IdentifierManager)valueManagerArray[n2];
        IdentifierManager identifierManager3 = (IdentifierManager)valueManagerArray[n3];
        FontSizeManager fontSizeManager = (FontSizeManager)valueManagerArray[n4];
        StringMap stringMap = identifierManager.getIdentifiers();
        StringMap stringMap2 = identifierManager2.getIdentifiers();
        StringMap stringMap3 = identifierManager3.getIdentifiers();
        StringMap stringMap4 = fontSizeManager.getIdentifiers();
        boolean bl2 = false;
        LexicalUnit lexicalUnit7 = null;
        while (!bl2 && lexicalUnit != null) {
            switch (lexicalUnit.getLexicalUnitType()) {
                case IDENT: {
                    string = lexicalUnit.getStringValue().toLowerCase().intern();
                    if (string2 == null && stringMap.get(string) != null) {
                        string2 = lexicalUnit;
                        if (lexicalUnit7 == null) break;
                        if (lexicalUnit3 == null) {
                            lexicalUnit3 = lexicalUnit7;
                            lexicalUnit7 = null;
                            break;
                        }
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit7.getLexicalUnitType());
                    }
                    if (lexicalUnit2 == null && stringMap2.get(string) != null) {
                        lexicalUnit2 = lexicalUnit;
                        if (lexicalUnit7 == null) break;
                        if (lexicalUnit3 == null) {
                            lexicalUnit3 = lexicalUnit7;
                            lexicalUnit7 = null;
                            break;
                        }
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit7.getLexicalUnitType());
                    }
                    if (lexicalUnit7 == null && lexicalUnit3 == null && stringMap3.get(string) != null) {
                        lexicalUnit3 = lexicalUnit;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case INTEGER: {
                    if (lexicalUnit7 == null && lexicalUnit3 == null) {
                        lexicalUnit7 = lexicalUnit;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            if (bl2) continue;
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        if (lexicalUnit == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        switch (lexicalUnit.getLexicalUnitType()) {
            case IDENT: {
                string = lexicalUnit.getStringValue().toLowerCase().intern();
                if (stringMap4.get(string) == null) break;
                lexicalUnit4 = lexicalUnit;
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                break;
            }
            case DIMENSION: {
                if (!CSSUnit.isLengthUnitType((short)lexicalUnit.getCssUnit())) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                }
            }
            case INTEGER: 
            case REAL: 
            case PERCENTAGE: {
                lexicalUnit4 = lexicalUnit;
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                break;
            }
        }
        if (lexicalUnit4 == null) {
            if (lexicalUnit7 != null) {
                lexicalUnit4 = lexicalUnit7;
                lexicalUnit7 = null;
            } else {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
            }
        }
        if (lexicalUnit7 != null) {
            if (lexicalUnit3 == null) {
                lexicalUnit3 = lexicalUnit7;
            } else {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit7.getLexicalUnitType());
            }
        }
        if (lexicalUnit == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        switch (lexicalUnit.getLexicalUnitType()) {
            case OPERATOR_SLASH: {
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                if (lexicalUnit == null) {
                    throw this.createMalformedLexicalUnitDOMException();
                }
                lexicalUnit5 = lexicalUnit;
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                break;
            }
        }
        if (lexicalUnit == null) {
            throw this.createMalformedLexicalUnitDOMException();
        }
        lexicalUnit6 = lexicalUnit;
        if (string2 == null) {
            string2 = NORMAL_LU;
        }
        if (lexicalUnit2 == null) {
            lexicalUnit2 = NORMAL_LU;
        }
        if (lexicalUnit3 == null) {
            lexicalUnit3 = NORMAL_LU;
        }
        if (lexicalUnit5 == null) {
            lexicalUnit5 = NORMAL_LU;
        }
        propertyHandler.property("font-family", lexicalUnit6, bl);
        propertyHandler.property("font-style", (LexicalUnit)string2, bl);
        propertyHandler.property("font-variant", lexicalUnit2, bl);
        propertyHandler.property("font-weight", lexicalUnit3, bl);
        propertyHandler.property("font-size", lexicalUnit4, bl);
        if (n5 != -1) {
            propertyHandler.property("line-height", lexicalUnit5, bl);
        }
    }

    static {
        CSSParser cSSParser = new CSSParser();
        try {
            NORMAL_LU = cSSParser.parsePropertyValue((Reader)new StringReader("normal"));
            BOLD_LU = cSSParser.parsePropertyValue((Reader)new StringReader("bold"));
            MEDIUM_LU = cSSParser.parsePropertyValue((Reader)new StringReader("medium"));
            SZ_10PT_LU = cSSParser.parsePropertyValue((Reader)new StringReader("10pt"));
            SZ_8PT_LU = cSSParser.parsePropertyValue((Reader)new StringReader("8pt"));
            FONT_FAMILY_LU = cSSParser.parsePropertyValue((Reader)new StringReader("\"Dialog\",\"Helvetica\",sans-serif"));
        }
        catch (CSSParseException | IOException throwable) {
            // empty catch block
        }
        values = new HashSet<String>();
        values.add("caption");
        values.add("icon");
        values.add("menu");
        values.add("message-box");
        values.add("small-caption");
        values.add("status-bar");
    }
}

