/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.IdentifierManager;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.RGBColorValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public abstract class AbstractColorManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();
    protected static final StringMap computedValues;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case HSLCOLOR: 
            case HWBCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: {
                String string;
                StyleValue styleValue;
                ValueFactory valueFactory = new ValueFactory();
                try {
                    styleValue = valueFactory.createCSSValue(lexicalUnit);
                    if (styleValue.getCssValueType() != CSSValue.CssType.TYPED) {
                        throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                    }
                    string = ((CSSTypedValue)styleValue).toRGBColor().toString();
                }
                catch (DOMException dOMException) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                }
                styleValue = new CSSParser();
                try {
                    lexicalUnit = styleValue.parsePropertyValue((Reader)new StringReader(string));
                }
                catch (CSSParseException | IOException throwable) {
                    throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
                }
            }
            case RGBCOLOR: {
                Value value;
                LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
                Value value2 = this.createColorComponent(lexicalUnit2);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                }
                Value value3 = this.createColorComponent(lexicalUnit2);
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()).getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                }
                Value value4 = this.createColorComponent(lexicalUnit2);
                if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                    if ((lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA || lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) && (lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
                        throw new DOMException(12, "Invalid color: " + lexicalUnit.getCssText());
                    }
                    value = this.createColorComponent(lexicalUnit2);
                } else {
                    value = null;
                }
                return this.createRGBColor(value2, value3, value4, value);
            }
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getPrimitiveType() == 21) {
            String string2 = value.getStringValue();
            Value value2 = (Value)computedValues.get(string2);
            if (value2 != null) {
                return value2;
            }
            if (values.get(string2) == null) {
                throw new IllegalStateException("Not a system-color:" + string2);
            }
            return cSSEngine.getCSSContext().getSystemColor(string2);
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    protected Value createRGBColor(Value value, Value value2, Value value3, Value value4) {
        return value4 == null ? new RGBColorValue(value, value2, value3) : new RGBColorValue(value, value2, value3, value4);
    }

    protected Value createColorComponent(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INTEGER: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case PERCENTAGE: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
        }
        throw this.createInvalidRGBComponentUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    private DOMException createInvalidRGBComponentUnitDOMException(LexicalUnit.LexicalType lexicalType) {
        Object[] objectArray = new Object[]{this.getPropertyName(), lexicalType.toString()};
        String string = Messages.formatMessage("invalid.rgb.component.unit", objectArray);
        return new DOMException(9, string);
    }

    static {
        values.put("aqua", ValueConstants.AQUA_VALUE);
        values.put("black", ValueConstants.BLACK_VALUE);
        values.put("blue", ValueConstants.BLUE_VALUE);
        values.put("fuchsia", ValueConstants.FUCHSIA_VALUE);
        values.put("gray", ValueConstants.GRAY_VALUE);
        values.put("green", ValueConstants.GREEN_VALUE);
        values.put("lime", ValueConstants.LIME_VALUE);
        values.put("maroon", ValueConstants.MAROON_VALUE);
        values.put("navy", ValueConstants.NAVY_VALUE);
        values.put("olive", ValueConstants.OLIVE_VALUE);
        values.put("purple", ValueConstants.PURPLE_VALUE);
        values.put("red", ValueConstants.RED_VALUE);
        values.put("silver", ValueConstants.SILVER_VALUE);
        values.put("teal", ValueConstants.TEAL_VALUE);
        values.put("transparent", ValueConstants.TRANSPARENT_VALUE);
        values.put("white", ValueConstants.WHITE_VALUE);
        values.put("yellow", ValueConstants.YELLOW_VALUE);
        values.put("activeborder", ValueConstants.ACTIVEBORDER_VALUE);
        values.put("activecaption", ValueConstants.ACTIVECAPTION_VALUE);
        values.put("appworkspace", ValueConstants.APPWORKSPACE_VALUE);
        values.put("background", ValueConstants.BACKGROUND_VALUE);
        values.put("buttonface", ValueConstants.BUTTONFACE_VALUE);
        values.put("buttonhighlight", ValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put("buttonshadow", ValueConstants.BUTTONSHADOW_VALUE);
        values.put("buttontext", ValueConstants.BUTTONTEXT_VALUE);
        values.put("captiontext", ValueConstants.CAPTIONTEXT_VALUE);
        values.put("graytext", ValueConstants.GRAYTEXT_VALUE);
        values.put("highlight", ValueConstants.HIGHLIGHT_VALUE);
        values.put("highlighttext", ValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put("inactiveborder", ValueConstants.INACTIVEBORDER_VALUE);
        values.put("inactivecaption", ValueConstants.INACTIVECAPTION_VALUE);
        values.put("inactivecaptiontext", ValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put("infobackground", ValueConstants.INFOBACKGROUND_VALUE);
        values.put("infotext", ValueConstants.INFOTEXT_VALUE);
        values.put("menu", ValueConstants.MENU_VALUE);
        values.put("menutext", ValueConstants.MENUTEXT_VALUE);
        values.put("scrollbar", ValueConstants.SCROLLBAR_VALUE);
        values.put("threeddarkshadow", ValueConstants.THREEDDARKSHADOW_VALUE);
        values.put("threedface", ValueConstants.THREEDFACE_VALUE);
        values.put("threedhighlight", ValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put("threedlightshadow", ValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put("threedshadow", ValueConstants.THREEDSHADOW_VALUE);
        values.put("window", ValueConstants.WINDOW_VALUE);
        values.put("windowframe", ValueConstants.WINDOWFRAME_VALUE);
        values.put("windowtext", ValueConstants.WINDOWTEXT_VALUE);
        computedValues = new StringMap();
        computedValues.put("black", ValueConstants.BLACK_RGB_VALUE);
        computedValues.put("silver", ValueConstants.SILVER_RGB_VALUE);
        computedValues.put("gray", ValueConstants.GRAY_RGB_VALUE);
        computedValues.put("white", ValueConstants.WHITE_RGB_VALUE);
        computedValues.put("maroon", ValueConstants.MAROON_RGB_VALUE);
        computedValues.put("red", ValueConstants.RED_RGB_VALUE);
        computedValues.put("purple", ValueConstants.PURPLE_RGB_VALUE);
        computedValues.put("fuchsia", ValueConstants.FUCHSIA_RGB_VALUE);
        computedValues.put("green", ValueConstants.GREEN_RGB_VALUE);
        computedValues.put("lime", ValueConstants.LIME_RGB_VALUE);
        computedValues.put("olive", ValueConstants.OLIVE_RGB_VALUE);
        computedValues.put("yellow", ValueConstants.YELLOW_RGB_VALUE);
        computedValues.put("navy", ValueConstants.NAVY_RGB_VALUE);
        computedValues.put("blue", ValueConstants.BLUE_RGB_VALUE);
        computedValues.put("teal", ValueConstants.TEAL_RGB_VALUE);
        computedValues.put("aqua", ValueConstants.AQUA_RGB_VALUE);
        computedValues.put("transparent", ValueConstants.TRANSPARENT_RGB_VALUE);
    }
}

