/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder.image;

import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.ImageTranscoder;
import io.sf.carte.echosvg.transcoder.keys.StringKey;
import java.awt.image.BufferedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.lang.reflect.InvocationTargetException;

public class TIFFTranscoder
extends ImageTranscoder {
    public static final TranscodingHints.Key KEY_FORCE_TRANSPARENT_WHITE = ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE;
    public static final TranscodingHints.Key KEY_COMPRESSION_METHOD = new StringKey();

    public TIFFTranscoder() {
        this.hints.put(KEY_FORCE_TRANSPARENT_WHITE, (Object)Boolean.FALSE);
    }

    @Override
    public BufferedImage createImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    private WriteAdapter getWriteAdapter(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            WriteAdapter writeAdapter = (WriteAdapter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return writeAdapter;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    @Override
    public void writeImage(BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        Object object;
        boolean bl = false;
        if (this.hints.containsKey(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE)) {
            bl = (Boolean)this.hints.get(ImageTranscoder.KEY_FORCE_TRANSPARENT_WHITE);
        }
        if (bl) {
            object = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            this.forceTransparentWhite(bufferedImage, (SinglePixelPackedSampleModel)object);
        }
        if ((object = this.getWriteAdapter("io.sf.carte.echosvg.ext.awt.image.codec.tiff.TIFFTranscoderInternalCodecWriteAdapter")) == null) {
            object = this.getWriteAdapter("io.sf.carte.echosvg.ext.awt.image.codec.imageio.TIFFTranscoderImageIOWriteAdapter");
        }
        if (object == null) {
            throw new TranscoderException("Could not write TIFF file because no WriteAdapter is availble");
        }
        object.writeImage(this, bufferedImage, transcoderOutput);
    }

    public static interface WriteAdapter {
        public void writeImage(TIFFTranscoder var1, BufferedImage var2, TranscoderOutput var3) throws TranscoderException;
    }
}

