/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.transcoder;

import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.dom.GenericDOMImplementation;
import io.sf.carte.echosvg.dom.util.DocumentFactory;
import io.sf.carte.echosvg.dom.util.SAXDocumentFactory;
import io.sf.carte.echosvg.transcoder.AbstractTranscoder;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderInput;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.keys.BooleanKey;
import io.sf.carte.echosvg.transcoder.keys.DOMImplementationKey;
import io.sf.carte.echosvg.transcoder.keys.StringKey;
import java.io.IOException;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public abstract class XMLAbstractTranscoder
extends AbstractTranscoder {
    public static final TranscodingHints.Key KEY_XML_PARSER_VALIDATING = new BooleanKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT = new StringKey();
    public static final TranscodingHints.Key KEY_DOCUMENT_ELEMENT_NAMESPACE_URI = new StringKey();
    public static final TranscodingHints.Key KEY_DOM_IMPLEMENTATION = new DOMImplementationKey();

    protected XMLAbstractTranscoder() {
        this.hints.put(KEY_XML_PARSER_VALIDATING, (Object)Boolean.FALSE);
    }

    @Override
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) throws TranscoderException {
        Document document = null;
        document = transcoderInput.getDocument() != null ? transcoderInput.getDocument() : this.loadDocument(transcoderInput);
        if (document != null) {
            String string = transcoderInput.getURI();
            try {
                this.transcode(document, string, transcoderOutput);
            }
            catch (TranscoderException transcoderException) {
                this.handler.fatalError(transcoderException);
                return;
            }
        }
    }

    private Document loadDocument(TranscoderInput transcoderInput) throws TranscoderException {
        String string = (String)this.hints.get(KEY_DOCUMENT_ELEMENT_NAMESPACE_URI);
        String string2 = (String)this.hints.get(KEY_DOCUMENT_ELEMENT);
        DocumentFactory documentFactory = this.createDocumentFactory(string2);
        if (string == null) {
            this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT_NAMESPACE_URI"));
            return null;
        }
        if (string2 == null) {
            this.handler.fatalError(new TranscoderException("Unspecified transcoding hints: KEY_DOCUMENT_ELEMENT"));
            return null;
        }
        Object object = this.hints.get(KEY_XML_PARSER_VALIDATING);
        boolean bl = object != null && (Boolean)object != false;
        documentFactory.setValidating(bl);
        documentFactory.setXMLReader(transcoderInput.getXMLReader());
        String string3 = transcoderInput.getURI();
        Document document = null;
        try {
            if (transcoderInput.getInputStream() != null) {
                document = documentFactory.createDocument(string, string2, string3, transcoderInput.getInputStream(), transcoderInput.getEncoding());
            } else if (transcoderInput.getReader() != null) {
                document = documentFactory.createDocument(string, string2, string3, transcoderInput.getReader());
            } else if (string3 != null) {
                document = documentFactory.createDocument(string, string2, string3, transcoderInput.getEncoding());
            }
        }
        catch (DOMException dOMException) {
            this.handler.fatalError(new TranscoderException(dOMException));
        }
        catch (IOException iOException) {
            this.handler.fatalError(new TranscoderException(iOException));
        }
        return document;
    }

    private DocumentFactory createDocumentFactory(String string) {
        DocumentFactory documentFactory;
        DOMImplementation dOMImplementation = (DOMImplementation)this.hints.get(KEY_DOM_IMPLEMENTATION);
        if (dOMImplementation == null) {
            if ("html".equalsIgnoreCase(string)) {
                dOMImplementation = GenericDOMImplementation.getDOMImplementation();
                documentFactory = new SAXDocumentFactory(dOMImplementation);
            } else {
                dOMImplementation = SVGDOMImplementation.getDOMImplementation();
                documentFactory = this.createDocumentFactory(dOMImplementation);
            }
        } else {
            documentFactory = this.createDocumentFactory(dOMImplementation);
        }
        return documentFactory;
    }

    protected DocumentFactory createDocumentFactory(DOMImplementation dOMImplementation) {
        return new SAXDocumentFactory(dOMImplementation);
    }

    protected abstract void transcode(Document var1, String var2, TranscoderOutput var3) throws TranscoderException;
}

