/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.png;

import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGEncodeParam;
import io.sf.carte.echosvg.ext.awt.image.codec.png.PNGImageEncoder;
import io.sf.carte.echosvg.ext.awt.image.rendered.IndexImage;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class PNGTranscoderInternalCodecWriteAdapter
implements PNGTranscoder.WriteAdapter {
    @Override
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        float f;
        PNGEncodeParam pNGEncodeParam;
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n = -1;
        if (transcodingHints.containsKey(PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)transcodingHints.get(PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)bufferedImage, (int)(1 << n));
        }
        if ((pNGEncodeParam = PNGEncodeParam.getDefaultEncodeParam(bufferedImage)) instanceof PNGEncodeParam.RGB) {
            ((PNGEncodeParam.RGB)pNGEncodeParam).setBackgroundRGB(new int[]{255, 255, 255});
        }
        if (transcodingHints.containsKey(PNGTranscoder.KEY_GAMMA)) {
            f = ((Float)transcodingHints.get(PNGTranscoder.KEY_GAMMA)).floatValue();
            if (f > 0.0f) {
                pNGEncodeParam.setGamma(f);
            }
            pNGEncodeParam.setChromaticity(PNGTranscoder.DEFAULT_CHROMA);
        } else {
            pNGEncodeParam.setSRGBIntent(0);
        }
        f = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n2 = (int)((double)(1000.0f / f) + 0.5);
        pNGEncodeParam.setPhysicalDimension(n2, n2, 1);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            PNGImageEncoder pNGImageEncoder = new PNGImageEncoder(outputStream, pNGEncodeParam);
            pNGImageEncoder.encode(bufferedImage);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

