/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.codec.imageio;

import io.sf.carte.echosvg.ext.awt.image.rendered.IndexImage;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriter;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterParams;
import io.sf.carte.echosvg.ext.awt.image.spi.ImageWriterRegistry;
import io.sf.carte.echosvg.transcoder.TranscoderException;
import io.sf.carte.echosvg.transcoder.TranscoderOutput;
import io.sf.carte.echosvg.transcoder.TranscodingHints;
import io.sf.carte.echosvg.transcoder.image.PNGTranscoder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;

public class PNGTranscoderImageIOWriteAdapter
implements PNGTranscoder.WriteAdapter {
    @Override
    public void writeImage(PNGTranscoder pNGTranscoder, BufferedImage bufferedImage, TranscoderOutput transcoderOutput) throws TranscoderException {
        TranscodingHints transcodingHints = pNGTranscoder.getTranscodingHints();
        int n = -1;
        if (transcodingHints.containsKey(PNGTranscoder.KEY_INDEXED) && ((n = ((Integer)transcodingHints.get(PNGTranscoder.KEY_INDEXED)).intValue()) == 1 || n == 2 || n == 4 || n == 8)) {
            bufferedImage = IndexImage.getIndexedImage((BufferedImage)bufferedImage, (int)(1 << n));
        }
        ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/png");
        ImageWriterParams imageWriterParams = new ImageWriterParams();
        float f = pNGTranscoder.getUserAgent().getPixelUnitToMillimeter();
        int n2 = (int)(25.4 / (double)f + 0.5);
        imageWriterParams.setResolution(n2);
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            imageWriter.writeImage((RenderedImage)bufferedImage, outputStream, imageWriterParams);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new TranscoderException(iOException);
        }
    }
}

