/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.swing.gvt;

import io.sf.carte.echosvg.swing.gvt.InteractorAdapter;
import io.sf.carte.echosvg.swing.gvt.JGVTComponent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;

public class AbstractImageZoomInteractor
extends InteractorAdapter {
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;

    @Override
    public boolean endInteraction() {
        return this.finished;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.finished) {
            JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
            jGVTComponent.setPaintingTransform(null);
            return;
        }
        this.finished = false;
        this.xStart = mouseEvent.getX();
        this.yStart = mouseEvent.getY();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        AffineTransform affineTransform = jGVTComponent.getPaintingTransform();
        if (affineTransform != null) {
            AffineTransform affineTransform2 = (AffineTransform)jGVTComponent.getRenderingTransform().clone();
            affineTransform2.preConcatenate(affineTransform);
            jGVTComponent.setRenderingTransform(affineTransform2);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.xCurrent = mouseEvent.getX();
        this.yCurrent = mouseEvent.getY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.xStart, this.yStart);
        int n = this.yCurrent - this.yStart;
        double d = n < 0 ? ((n -= 10) > -15 ? 1.0 : -15.0 / (double)n) : ((n += 10) < 15 ? 1.0 : (double)n / 15.0);
        affineTransform.scale(d, d);
        affineTransform.translate(-this.xStart, -this.yStart);
        jGVTComponent.setPaintingTransform(affineTransform);
    }
}

