/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class ClassFileUtilities {
    public static final byte CONSTANT_UTF8_INFO = 1;
    public static final byte CONSTANT_INTEGER_INFO = 3;
    public static final byte CONSTANT_FLOAT_INFO = 4;
    public static final byte CONSTANT_LONG_INFO = 5;
    public static final byte CONSTANT_DOUBLE_INFO = 6;
    public static final byte CONSTANT_CLASS_INFO = 7;
    public static final byte CONSTANT_STRING_INFO = 8;
    public static final byte CONSTANT_FIELDREF_INFO = 9;
    public static final byte CONSTANT_METHODREF_INFO = 10;
    public static final byte CONSTANT_INTERFACEMETHODREF_INFO = 11;
    public static final byte CONSTANT_NAMEANDTYPE_INFO = 12;

    protected ClassFileUtilities() {
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length == 1 && stringArray[0].equals("-f")) {
            bl = true;
        } else if (stringArray.length != 0) {
            System.err.println("usage: io.sf.carte.echosvg.util.ClassFileUtilities [-f]");
            System.err.println();
            System.err.println("  -f    list files that cause each jar file dependency");
            System.exit(1);
        }
        File file = new File(".");
        File file2 = null;
        String[] stringArray2 = file.list();
        if (stringArray2 != null) {
            for (String object5 : stringArray2) {
                if (!object5.startsWith("echosvg-")) continue;
                file2 = new File(object5);
                if (file2.isDirectory()) break;
                file2 = null;
            }
        }
        if (file2 == null || !file2.isDirectory()) {
            System.out.println("Directory 'echosvg-xxx' not found in current directory!");
            return;
        }
        try {
            Iterator iterator4;
            Object object2;
            HashMap hashMap = new HashMap();
            HashMap<String, Jar> hashMap2 = new HashMap<String, Jar>();
            ClassFileUtilities.collectJars(file2, hashMap2, hashMap);
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator2 = hashMap2.values().iterator();
            while (iterator2.hasNext()) {
                hashSet.add(((Jar)iterator2.next()).jarFile);
            }
            for (Object object2 : hashMap.values()) {
                iterator4 = ClassFileUtilities.getClassDependencies(((ClassFile)object2).getInputStream(), hashSet, false);
                Iterator<String> iterator3 = iterator4.iterator();
                while (iterator3.hasNext()) {
                    String string = iterator3.next();
                    ClassFile classFile = (ClassFile)hashMap.get(string);
                    if (object2 == classFile || classFile == null) continue;
                    ((ClassFile)object2).deps.add(classFile);
                }
            }
            for (Object object2 : hashMap.values()) {
                for (ClassFile classFile : ((ClassFile)object2).deps) {
                    Jar jar = ((ClassFile)object2).jar;
                    Jar jar2 = classFile.jar;
                    if (((ClassFile)object2).name.equals(classFile.name) || jar2 == jar || jar.files.contains(classFile)) continue;
                    Integer n = jar.deps.get(jar2);
                    if (n == null) {
                        jar.deps.put(jar2, 1);
                        continue;
                    }
                    jar.deps.put(jar2, n + 1);
                }
            }
            object2 = new ArrayList(10);
            for (Iterator iterator4 : hashMap2.values()) {
                for (Jar jar : ((Jar)((Object)iterator4)).deps.keySet()) {
                    Triple triple = new Triple();
                    triple.from = iterator4;
                    triple.to = jar;
                    triple.count = ((Jar)((Object)iterator4)).deps.get(jar);
                    object2.add(triple);
                }
            }
            Collections.sort(object2);
            iterator4 = object2.iterator();
            while (iterator4.hasNext()) {
                Triple triple = (Triple)iterator4.next();
                System.out.println(triple.count + "," + triple.from.name + "," + triple.to.name);
                if (!bl) continue;
                for (ClassFile classFile : triple.from.files) {
                    for (ClassFile classFile2 : classFile.deps) {
                        if (classFile2.jar != triple.to || triple.from.files.contains(classFile2)) continue;
                        System.out.println("\t" + classFile.name + " --> " + classFile2.name);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void collectJars(File file, Map<String, Jar> map, Map<String, ClassFile> map2) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string = file2.getName();
                if (string.endsWith(".jar") && file2.isFile()) {
                    Jar jar = new Jar();
                    jar.name = file2.getPath();
                    jar.file = file2;
                    jar.jarFile = new JarFile(file2);
                    map.put(jar.name, jar);
                    Enumeration<JarEntry> enumeration = jar.jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = enumeration.nextElement();
                        String string2 = zipEntry.getName();
                        if (!string2.endsWith(".class")) continue;
                        ClassFile classFile = new ClassFile();
                        classFile.name = string2;
                        classFile.jar = jar;
                        map2.put(jar.name + '!' + classFile.name, classFile);
                        jar.files.add(classFile);
                    }
                    continue;
                }
                if (!file2.isDirectory()) continue;
                ClassFileUtilities.collectJars(file2, map, map2);
            }
        }
    }

    public static Set<String> getClassDependencies(String string, Set<Object> set, boolean bl) throws IOException {
        return ClassFileUtilities.getClassDependencies(new FileInputStream(string), set, bl);
    }

    public static Set<String> getClassDependencies(InputStream inputStream, Set<Object> set, boolean bl) throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        ClassFileUtilities.computeClassDependencies(inputStream, set, hashSet2, hashSet, bl);
        return hashSet;
    }

    private static void computeClassDependencies(InputStream inputStream, Set<Object> set, Set<String> set2, Set<String> set3, boolean bl) throws IOException {
        for (String string : ClassFileUtilities.getClassDependencies(inputStream)) {
            if (set2.contains(string)) continue;
            set2.add(string);
            for (Object object : set) {
                Object object2;
                InputStream inputStream2 = null;
                String string2 = null;
                JarFile jarFile = null;
                Object object3 = object;
                if (object3 instanceof JarFile) {
                    jarFile = (JarFile)object3;
                    object2 = string + ".class";
                    ZipEntry zipEntry = jarFile.getEntry((String)object2);
                    if (zipEntry != null) {
                        string2 = jarFile.getName() + '!' + (String)object2;
                        inputStream2 = jarFile.getInputStream(zipEntry);
                    }
                } else {
                    string2 = (String)object3 + '/' + string + ".class";
                    object2 = new File(string2);
                    if (((File)object2).isFile()) {
                        inputStream2 = new FileInputStream((File)object2);
                    }
                }
                if (inputStream2 != null) {
                    set3.add(string2);
                    if (bl) {
                        ClassFileUtilities.computeClassDependencies(inputStream2, set, set2, set3, bl);
                    }
                    ((InputStream)inputStream2).close();
                }
                if (jarFile == null) continue;
                jarFile.close();
            }
        }
    }

    public static Set<String> getClassDependencies(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != -889275714) {
            throw new IOException("Invalid classfile");
        }
        dataInputStream.readInt();
        int n = dataInputStream.readShort();
        String[] stringArray = new String[n];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        block8: for (int i = 1; i < n; ++i) {
            int n2 = dataInputStream.readByte() & 0xFF;
            switch (n2) {
                case 5: 
                case 6: {
                    dataInputStream.readLong();
                    ++i;
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: {
                    dataInputStream.readInt();
                    continue block8;
                }
                case 7: {
                    hashSet.add(dataInputStream.readShort() & 0xFFFF);
                    continue block8;
                }
                case 8: {
                    dataInputStream.readShort();
                    continue block8;
                }
                case 12: {
                    dataInputStream.readShort();
                    hashSet2.add(dataInputStream.readShort() & 0xFFFF);
                    continue block8;
                }
                case 1: {
                    stringArray[i] = dataInputStream.readUTF();
                    continue block8;
                }
                default: {
                    throw new RuntimeException("unexpected data in constant-pool:" + n2);
                }
            }
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            hashSet3.add(stringArray[(Integer)iterator.next()]);
        }
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            hashSet3.addAll(ClassFileUtilities.getDescriptorClasses(stringArray[(Integer)iterator.next()]));
        }
        return hashSet3;
    }

    protected static Set<String> getDescriptorClasses(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        char c = string.charAt(n);
        switch (c) {
            case '(': {
                StringBuilder stringBuilder;
                block14: while (true) {
                    c = string.charAt(++n);
                    switch (c) {
                        case '[': {
                            while ((c = string.charAt(++n)) == '[') {
                            }
                            if (c != 'L') continue block14;
                        }
                        case 'L': {
                            c = string.charAt(++n);
                            stringBuilder = new StringBuilder();
                            while (c != ';') {
                                stringBuilder.append(c);
                                c = string.charAt(++n);
                            }
                            hashSet.add(stringBuilder.toString());
                            continue block14;
                        }
                        default: {
                            continue block14;
                        }
                        case ')': 
                    }
                    break;
                }
                c = string.charAt(++n);
                switch (c) {
                    case '[': {
                        while ((c = string.charAt(++n)) == '[') {
                        }
                        if (c != 'L') break;
                    }
                    case 'L': {
                        c = string.charAt(++n);
                        stringBuilder = new StringBuilder();
                        while (c != ';') {
                            stringBuilder.append(c);
                            c = string.charAt(++n);
                        }
                        hashSet.add(stringBuilder.toString());
                        break;
                    }
                }
                break;
            }
            case '[': {
                while ((c = string.charAt(++n)) == '[') {
                }
                if (c != 'L') break;
            }
            case 'L': {
                c = string.charAt(++n);
                StringBuilder stringBuilder = new StringBuilder();
                while (c != ';') {
                    stringBuilder.append(c);
                    c = string.charAt(++n);
                }
                hashSet.add(stringBuilder.toString());
                break;
            }
        }
        return hashSet;
    }

    protected static class ClassFile {
        public String name;
        public List<ClassFile> deps = new ArrayList<ClassFile>(10);
        public Jar jar;

        protected ClassFile() {
        }

        public InputStream getInputStream() throws IOException {
            return this.jar.jarFile.getInputStream(this.jar.jarFile.getEntry(this.name));
        }
    }

    protected static class Jar {
        public String name;
        public File file;
        public JarFile jarFile;
        public Map<Jar, Integer> deps = new HashMap<Jar, Integer>();
        public Set<ClassFile> files = new HashSet<ClassFile>();

        protected Jar() {
        }
    }

    protected static class Triple
    implements Comparable<Triple> {
        public Jar from;
        public Jar to;
        public int count;

        protected Triple() {
        }

        @Override
        public int compareTo(Triple triple) {
            return triple.count - this.count;
        }
    }
}

