/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AttributeInitializer;
import io.sf.carte.echosvg.anim.dom.SVGLocatableSupport;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedBoolean;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedLength;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedPreserveAspectRatio;
import io.sf.carte.echosvg.anim.dom.SVGOMAnimatedRect;
import io.sf.carte.echosvg.anim.dom.SVGOMLength;
import io.sf.carte.echosvg.anim.dom.SVGStylableElement;
import io.sf.carte.echosvg.anim.dom.TraitInformation;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.svg.AbstractSVGMatrix;
import io.sf.carte.echosvg.dom.svg.SVGContext;
import io.sf.carte.echosvg.dom.svg.SVGOMAngle;
import io.sf.carte.echosvg.dom.svg.SVGOMPoint;
import io.sf.carte.echosvg.dom.svg.SVGOMRect;
import io.sf.carte.echosvg.dom.svg.SVGOMTransform;
import io.sf.carte.echosvg.dom.svg.SVGSVGContext;
import io.sf.carte.echosvg.dom.svg.SVGTestsSupport;
import io.sf.carte.echosvg.dom.svg.SVGZoomAndPanSupport;
import io.sf.carte.echosvg.dom.util.ListNodeList;
import io.sf.carte.echosvg.dom.util.XMLSupport;
import io.sf.carte.echosvg.util.DoublyIndexedTable;
import java.awt.geom.AffineTransform;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.stylesheets.DocumentStyle;
import org.w3c.dom.stylesheets.StyleSheetList;
import org.w3c.dom.svg.SVGAngle;
import org.w3c.dom.svg.SVGAnimatedBoolean;
import org.w3c.dom.svg.SVGAnimatedLength;
import org.w3c.dom.svg.SVGAnimatedPreserveAspectRatio;
import org.w3c.dom.svg.SVGAnimatedRect;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGNumber;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStringList;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGViewSpec;
import org.w3c.dom.views.AbstractView;
import org.w3c.dom.views.DocumentView;

public class SVGOMSVGElement
extends SVGStylableElement
implements SVGSVGElement {
    private static final long serialVersionUID = 1L;
    protected static DoublyIndexedTable<String, String> xmlTraitInformation;
    protected static final AttributeInitializer attributeInitializer;
    protected SVGOMAnimatedLength x;
    protected SVGOMAnimatedLength y;
    protected SVGOMAnimatedLength width;
    protected SVGOMAnimatedLength height;
    protected SVGOMAnimatedBoolean externalResourcesRequired;
    protected SVGOMAnimatedPreserveAspectRatio preserveAspectRatio;
    protected SVGOMAnimatedRect viewBox;

    protected SVGOMSVGElement() {
    }

    public SVGOMSVGElement(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.initializeLiveAttributes();
    }

    @Override
    protected void initializeAllLiveAttributes() {
        super.initializeAllLiveAttributes();
        this.initializeLiveAttributes();
    }

    private void initializeLiveAttributes() {
        this.x = this.createLiveAnimatedLength(null, "x", "0", (short)2, false);
        this.y = this.createLiveAnimatedLength(null, "y", "0", (short)1, false);
        this.width = this.createLiveAnimatedLength(null, "width", "100%", (short)2, true);
        this.height = this.createLiveAnimatedLength(null, "height", "100%", (short)1, true);
        this.externalResourcesRequired = this.createLiveAnimatedBoolean(null, "externalResourcesRequired", false);
        this.preserveAspectRatio = this.createLiveAnimatedPreserveAspectRatio();
        this.viewBox = this.createLiveAnimatedRect(null, "viewBox", null);
    }

    public String getLocalName() {
        return "svg";
    }

    public SVGAnimatedLength getX() {
        return this.x;
    }

    public SVGAnimatedLength getY() {
        return this.y;
    }

    public SVGAnimatedLength getWidth() {
        return this.width;
    }

    public SVGAnimatedLength getHeight() {
        return this.height;
    }

    public String getContentScriptType() {
        return this.getAttributeNS(null, "contentScriptType");
    }

    public void setContentScriptType(String string) {
        this.setAttributeNS(null, "contentScriptType", string);
    }

    public String getContentStyleType() {
        return this.getAttributeNS(null, "contentStyleType");
    }

    public void setContentStyleType(String string) {
        this.setAttributeNS(null, "contentStyleType", string);
    }

    public SVGRect getViewport() {
        SVGContext sVGContext = this.getSVGContext();
        return new SVGOMRect(0.0f, 0.0f, sVGContext.getViewportWidth(), sVGContext.getViewportHeight());
    }

    public float getPixelUnitToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getPixelUnitToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getScreenPixelToMillimeterX() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public float getScreenPixelToMillimeterY() {
        return this.getSVGContext().getPixelUnitToMillimeter();
    }

    public boolean getUseCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getUseCurrentView is not implemented");
    }

    public void setUseCurrentView(boolean bl) throws DOMException {
        throw new UnsupportedOperationException("SVGSVGElement.setUseCurrentView is not implemented");
    }

    public SVGViewSpec getCurrentView() {
        throw new UnsupportedOperationException("SVGSVGElement.getCurrentView is not implemented");
    }

    public float getCurrentScale() {
        AffineTransform affineTransform = this.getSVGContext().getScreenTransform();
        if (affineTransform != null) {
            return (float)Math.sqrt(affineTransform.getDeterminant());
        }
        return 1.0f;
    }

    public void setCurrentScale(float f) throws DOMException {
        SVGContext sVGContext = this.getSVGContext();
        AffineTransform affineTransform = sVGContext.getScreenTransform();
        if (affineTransform != null) {
            float f2 = (float)Math.sqrt(affineTransform.getDeterminant());
            float f3 = f / f2;
            affineTransform = new AffineTransform(affineTransform.getScaleX() * (double)f3, affineTransform.getShearY() * (double)f3, affineTransform.getShearX() * (double)f3, affineTransform.getScaleY() * (double)f3, affineTransform.getTranslateX(), affineTransform.getTranslateY());
            sVGContext.setScreenTransform(affineTransform);
        }
    }

    public SVGPoint getCurrentTranslate() {
        return new SVGPoint(){

            protected AffineTransform getScreenTransform() {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                return sVGContext.getScreenTransform();
            }

            public float getX() {
                AffineTransform affineTransform = this.getScreenTransform();
                return (float)affineTransform.getTranslateX();
            }

            public float getY() {
                AffineTransform affineTransform = this.getScreenTransform();
                return (float)affineTransform.getTranslateY();
            }

            public void setX(float f) {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                AffineTransform affineTransform = sVGContext.getScreenTransform();
                affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), (double)f, affineTransform.getTranslateY());
                sVGContext.setScreenTransform(affineTransform);
            }

            public void setY(float f) {
                SVGContext sVGContext = SVGOMSVGElement.this.getSVGContext();
                AffineTransform affineTransform = sVGContext.getScreenTransform();
                affineTransform = new AffineTransform(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), (double)f);
                sVGContext.setScreenTransform(affineTransform);
            }

            public SVGPoint matrixTransform(SVGMatrix sVGMatrix) {
                AffineTransform affineTransform = this.getScreenTransform();
                float f = (float)affineTransform.getTranslateX();
                float f2 = (float)affineTransform.getTranslateY();
                float f3 = sVGMatrix.getA() * f + sVGMatrix.getC() * f2 + sVGMatrix.getE();
                float f4 = sVGMatrix.getB() * f + sVGMatrix.getD() * f2 + sVGMatrix.getF();
                return new SVGOMPoint(f3, f4);
            }
        };
    }

    public int suspendRedraw(int n) {
        if (n > 60000) {
            n = 60000;
        } else if (n < 0) {
            n = 0;
        }
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.suspendRedraw(n);
    }

    public void unsuspendRedraw(int n) throws DOMException {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        if (!sVGSVGContext.unsuspendRedraw(n)) {
            throw this.createDOMException((short)8, "invalid.suspend.handle", new Object[]{n});
        }
    }

    public void unsuspendRedrawAll() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.unsuspendRedrawAll();
    }

    public void forceRedraw() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.forceRedraw();
    }

    public void pauseAnimations() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.pauseAnimations();
    }

    public void unpauseAnimations() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.unpauseAnimations();
    }

    public boolean animationsPaused() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.animationsPaused();
    }

    public float getCurrentTime() {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.getCurrentTime();
    }

    public void setCurrentTime(float f) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        sVGSVGContext.setCurrentTime(f);
    }

    public NodeList getIntersectionList(SVGRect sVGRect, SVGElement sVGElement) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        List list = sVGSVGContext.getIntersectionList(sVGRect, (Element)sVGElement);
        return new ListNodeList(list);
    }

    public NodeList getEnclosureList(SVGRect sVGRect, SVGElement sVGElement) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        List list = sVGSVGContext.getEnclosureList(sVGRect, (Element)sVGElement);
        return new ListNodeList(list);
    }

    public boolean checkIntersection(SVGElement sVGElement, SVGRect sVGRect) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.checkIntersection((Element)sVGElement, sVGRect);
    }

    public boolean checkEnclosure(SVGElement sVGElement, SVGRect sVGRect) {
        SVGSVGContext sVGSVGContext = (SVGSVGContext)this.getSVGContext();
        return sVGSVGContext.checkEnclosure((Element)sVGElement, sVGRect);
    }

    public void deselectAll() {
        ((SVGSVGContext)this.getSVGContext()).deselectAll();
    }

    public SVGNumber createSVGNumber() {
        return new SVGNumber(){
            protected float value;

            public float getValue() {
                return this.value;
            }

            public void setValue(float f) {
                this.value = f;
            }
        };
    }

    public SVGLength createSVGLength() {
        return new SVGOMLength(this);
    }

    public SVGAngle createSVGAngle() {
        return new SVGOMAngle();
    }

    public SVGPoint createSVGPoint() {
        return new SVGOMPoint(0.0f, 0.0f);
    }

    public SVGMatrix createSVGMatrix() {
        return new AbstractSVGMatrix(){
            protected AffineTransform at = new AffineTransform();

            protected AffineTransform getAffineTransform() {
                return this.at;
            }
        };
    }

    public SVGRect createSVGRect() {
        return new SVGOMRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public SVGTransform createSVGTransform() {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setType((short)1);
        return sVGOMTransform;
    }

    public SVGTransform createSVGTransformFromMatrix(SVGMatrix sVGMatrix) {
        SVGOMTransform sVGOMTransform = new SVGOMTransform();
        sVGOMTransform.setMatrix(sVGMatrix);
        return sVGOMTransform;
    }

    public Element getElementById(String string) {
        return this.ownerDocument.getChildElementById((Node)((Object)this), string);
    }

    public SVGElement getNearestViewportElement() {
        return SVGLocatableSupport.getNearestViewportElement((Element)((Object)this));
    }

    public SVGElement getFarthestViewportElement() {
        return SVGLocatableSupport.getFarthestViewportElement((Element)((Object)this));
    }

    public SVGRect getBBox() {
        return SVGLocatableSupport.getBBox((Element)((Object)this));
    }

    public SVGMatrix getCTM() {
        return SVGLocatableSupport.getCTM((Element)((Object)this));
    }

    public SVGMatrix getScreenCTM() {
        return SVGLocatableSupport.getScreenCTM((Element)((Object)this));
    }

    public SVGMatrix getTransformToElement(SVGElement sVGElement) throws SVGException {
        return SVGLocatableSupport.getTransformToElement((Element)((Object)this), sVGElement);
    }

    public DocumentView getDocument() {
        return (DocumentView)((Object)this.getOwnerDocument());
    }

    public CSSStyleDeclaration getComputedStyle(Element element, String string) {
        AbstractView abstractView = ((DocumentView)((Object)this.getOwnerDocument())).getDefaultView();
        return ((ViewCSS)abstractView).getComputedStyle(element, string);
    }

    public Event createEvent(String string) throws DOMException {
        return ((DocumentEvent)((Object)this.getOwnerDocument())).createEvent(string);
    }

    public boolean canDispatch(String string, String string2) throws DOMException {
        AbstractDocument abstractDocument = (AbstractDocument)this.getOwnerDocument();
        return abstractDocument.canDispatch(string, string2);
    }

    public StyleSheetList getStyleSheets() {
        return ((DocumentStyle)((Object)this.getOwnerDocument())).getStyleSheets();
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String string) {
        return ((DocumentCSS)((Object)this.getOwnerDocument())).getOverrideStyle(element, string);
    }

    public String getXMLlang() {
        return XMLSupport.getXMLLang((Element)((Object)this));
    }

    public void setXMLlang(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", string);
    }

    public String getXMLspace() {
        return XMLSupport.getXMLSpace((Element)((Object)this));
    }

    public void setXMLspace(String string) {
        this.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", string);
    }

    public short getZoomAndPan() {
        return SVGZoomAndPanSupport.getZoomAndPan((Element)((Object)this));
    }

    public void setZoomAndPan(short s) {
        SVGZoomAndPanSupport.setZoomAndPan((Element)((Object)this), (short)s);
    }

    public SVGAnimatedRect getViewBox() {
        return this.viewBox;
    }

    public SVGAnimatedPreserveAspectRatio getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public SVGAnimatedBoolean getExternalResourcesRequired() {
        return this.externalResourcesRequired;
    }

    public SVGStringList getRequiredFeatures() {
        return SVGTestsSupport.getRequiredFeatures((Element)((Object)this));
    }

    public SVGStringList getRequiredExtensions() {
        return SVGTestsSupport.getRequiredExtensions((Element)((Object)this));
    }

    public SVGStringList getSystemLanguage() {
        return SVGTestsSupport.getSystemLanguage((Element)((Object)this));
    }

    public boolean hasExtension(String string) {
        return SVGTestsSupport.hasExtension((Element)((Object)this), (String)string);
    }

    @Override
    protected AttributeInitializer getAttributeInitializer() {
        return attributeInitializer;
    }

    protected Node newNode() {
        return new SVGOMSVGElement();
    }

    @Override
    protected DoublyIndexedTable<String, String> getTraitInformationTable() {
        return xmlTraitInformation;
    }

    static {
        DoublyIndexedTable doublyIndexedTable = new DoublyIndexedTable(SVGStylableElement.xmlTraitInformation);
        doublyIndexedTable.put(null, (Object)"x", (Object)new TraitInformation(true, 3, 1));
        doublyIndexedTable.put(null, (Object)"y", (Object)new TraitInformation(true, 3, 2));
        doublyIndexedTable.put(null, (Object)"width", (Object)new TraitInformation(true, 3, 1));
        doublyIndexedTable.put(null, (Object)"height", (Object)new TraitInformation(true, 3, 2));
        doublyIndexedTable.put(null, (Object)"preserveAspectRatio", (Object)new TraitInformation(true, 32));
        doublyIndexedTable.put(null, (Object)"viewBox", (Object)new TraitInformation(true, 50));
        doublyIndexedTable.put(null, (Object)"externalResourcesRequired", (Object)new TraitInformation(true, 49));
        xmlTraitInformation = doublyIndexedTable;
        attributeInitializer = new AttributeInitializer(7);
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", null, "xmlns", "http://www.w3.org/2000/svg");
        attributeInitializer.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns", "xlink", "http://www.w3.org/1999/xlink");
        attributeInitializer.addAttribute(null, null, "preserveAspectRatio", "xMidYMid meet");
        attributeInitializer.addAttribute(null, null, "zoomAndPan", "magnify");
        attributeInitializer.addAttribute(null, null, "version", "1.0");
        attributeInitializer.addAttribute(null, null, "contentScriptType", "text/ecmascript");
        attributeInitializer.addAttribute(null, null, "contentStyleType", "text/css");
    }
}

