/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.AbstractElement;
import io.sf.carte.echosvg.anim.dom.AbstractSVGAnimatedValue;
import io.sf.carte.echosvg.anim.dom.AnimationTarget;
import io.sf.carte.echosvg.anim.dom.SVGOMElement;
import io.sf.carte.echosvg.anim.values.AnimatablePathDataValue;
import io.sf.carte.echosvg.anim.values.AnimatableValue;
import io.sf.carte.echosvg.dom.svg.AbstractSVGList;
import io.sf.carte.echosvg.dom.svg.AbstractSVGNormPathSegList;
import io.sf.carte.echosvg.dom.svg.AbstractSVGPathSegList;
import io.sf.carte.echosvg.dom.svg.ListBuilder;
import io.sf.carte.echosvg.dom.svg.ListHandler;
import io.sf.carte.echosvg.dom.svg.LiveAttributeException;
import io.sf.carte.echosvg.dom.svg.SVGAnimatedPathDataSupport;
import io.sf.carte.echosvg.dom.svg.SVGItem;
import io.sf.carte.echosvg.dom.svg.SVGPathSegItem;
import io.sf.carte.echosvg.parser.ParseException;
import io.sf.carte.echosvg.parser.PathArrayProducer;
import io.sf.carte.echosvg.parser.PathHandler;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedPathData;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegList;

public class SVGOMAnimatedPathData
extends AbstractSVGAnimatedValue
implements SVGAnimatedPathData {
    protected boolean changing;
    protected BaseSVGPathSegList pathSegs;
    protected NormalizedBaseSVGPathSegList normalizedPathSegs;
    protected AnimSVGPathSegList animPathSegs;
    protected String defaultValue;

    public SVGOMAnimatedPathData(AbstractElement abstractElement, String string, String string2, String string3) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
    }

    public SVGPathSegList getAnimatedNormalizedPathSegList() {
        throw new UnsupportedOperationException("SVGAnimatedPathData.getAnimatedNormalizedPathSegList is not implemented");
    }

    public SVGPathSegList getAnimatedPathSegList() {
        if (this.animPathSegs == null) {
            this.animPathSegs = new AnimSVGPathSegList();
        }
        return this.animPathSegs;
    }

    public SVGPathSegList getNormalizedPathSegList() {
        if (this.normalizedPathSegs == null) {
            this.normalizedPathSegs = new NormalizedBaseSVGPathSegList();
        }
        return this.normalizedPathSegs;
    }

    public SVGPathSegList getPathSegList() {
        if (this.pathSegs == null) {
            this.pathSegs = new BaseSVGPathSegList();
        }
        return this.pathSegs;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.pathSegs == null) {
                this.pathSegs = new BaseSVGPathSegList();
            }
            this.pathSegs.revalidate();
            if (this.pathSegs.missing) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 0, null);
            }
            if (this.pathSegs.malformed) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 1, this.pathSegs.getValueAsString());
            }
        }
    }

    @Override
    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGPathSegList sVGPathSegList = this.getPathSegList();
        PathArrayProducer pathArrayProducer = new PathArrayProducer();
        SVGAnimatedPathDataSupport.handlePathSegList((SVGPathSegList)sVGPathSegList, (PathHandler)pathArrayProducer);
        return new AnimatablePathDataValue(animationTarget, pathArrayProducer.getPathCommands(), pathArrayProducer.getPathParameters());
    }

    @Override
    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatablePathDataValue animatablePathDataValue = (AnimatablePathDataValue)animatableValue;
            if (this.animPathSegs == null) {
                this.animPathSegs = new AnimSVGPathSegList();
            }
            this.animPathSegs.setAnimatedValue(animatablePathDataValue.getCommands(), animatablePathDataValue.getParameters());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing) {
            if (this.pathSegs != null) {
                this.pathSegs.invalidate();
            }
            if (this.normalizedPathSegs != null) {
                this.normalizedPathSegs.invalidate();
            }
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing) {
            if (this.pathSegs != null) {
                this.pathSegs.invalidate();
            }
            if (this.normalizedPathSegs != null) {
                this.normalizedPathSegs.invalidate();
            }
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing) {
            if (this.pathSegs != null) {
                this.pathSegs.invalidate();
            }
            if (this.normalizedPathSegs != null) {
                this.normalizedPathSegs.invalidate();
            }
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public class AnimSVGPathSegList
    extends AbstractSVGPathSegList {
        private int[] parameterIndex = new int[1];

        public AnimSVGPathSegList() {
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedPathData.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPathData.this.element).createSVGException(s, string, objectArray);
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedPathData.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedPathData.this.getPathSegList().getNumberOfItems();
        }

        public SVGPathSeg getItem(int n) throws DOMException {
            if (SVGOMAnimatedPathData.this.hasAnimVal) {
                return super.getItem(n);
            }
            return SVGOMAnimatedPathData.this.getPathSegList().getItem(n);
        }

        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuilder.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuilder.append(this.getItemSeparator());
                stringBuilder.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuilder.toString();
        }

        protected void setAttributeValue(String string) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        public SVGPathSeg initialize(SVGPathSeg sVGPathSeg) throws DOMException, SVGException {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        public SVGPathSeg insertItemBefore(SVGPathSeg sVGPathSeg, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        public SVGPathSeg replaceItem(SVGPathSeg sVGPathSeg, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        public SVGPathSeg removeItem(int n) throws DOMException {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        public SVGPathSeg appendItem(SVGPathSeg sVGPathSeg) throws DOMException {
            throw SVGOMAnimatedPathData.this.element.createDOMException((short)7, "readonly.pathseg.list", null);
        }

        protected SVGPathSegItem newItem(short s, float[] fArray, int[] nArray) {
            switch (s) {
                case 10: 
                case 11: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    int n2 = nArray[0];
                    nArray[0] = n2 + 1;
                    int n3 = nArray[0];
                    nArray[0] = n3 + 1;
                    int n4 = nArray[0];
                    nArray[0] = n4 + 1;
                    int n5 = nArray[0];
                    nArray[0] = n5 + 1;
                    int n6 = nArray[0];
                    nArray[0] = n6 + 1;
                    int n7 = nArray[0];
                    nArray[0] = n7 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegArcItem(s, PATHSEG_LETTERS[s], fArray[n], fArray[n2], fArray[n3], fArray[n4] != 0.0f, fArray[n5] != 0.0f, fArray[n6], fArray[n7]);
                }
                case 1: {
                    return new SVGPathSegItem(s, PATHSEG_LETTERS[s]);
                }
                case 6: 
                case 7: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    int n8 = nArray[0];
                    nArray[0] = n8 + 1;
                    int n9 = nArray[0];
                    nArray[0] = n9 + 1;
                    int n10 = nArray[0];
                    nArray[0] = n10 + 1;
                    int n11 = nArray[0];
                    nArray[0] = n11 + 1;
                    int n12 = nArray[0];
                    nArray[0] = n12 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem(s, PATHSEG_LETTERS[s], fArray[n], fArray[n8], fArray[n9], fArray[n10], fArray[n11], fArray[n12]);
                }
                case 16: 
                case 17: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    int n13 = nArray[0];
                    nArray[0] = n13 + 1;
                    int n14 = nArray[0];
                    nArray[0] = n14 + 1;
                    int n15 = nArray[0];
                    nArray[0] = n15 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem(s, PATHSEG_LETTERS[s], fArray[n], fArray[n13], fArray[n14], fArray[n15]);
                }
                case 8: 
                case 9: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    int n16 = nArray[0];
                    nArray[0] = n16 + 1;
                    int n17 = nArray[0];
                    nArray[0] = n17 + 1;
                    int n18 = nArray[0];
                    nArray[0] = n18 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem(s, PATHSEG_LETTERS[s], fArray[n], fArray[n16], fArray[n17], fArray[n18]);
                }
                case 18: 
                case 19: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    int n19 = nArray[0];
                    nArray[0] = n19 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticSmoothItem(s, PATHSEG_LETTERS[s], fArray[n], fArray[n19]);
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    int n20 = nArray[0];
                    nArray[0] = n20 + 1;
                    return new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(s, PATHSEG_LETTERS[s], fArray[n], fArray[n20]);
                }
                case 12: 
                case 13: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    return new AbstractSVGPathSegList.SVGPathSegLinetoHorizontalItem(s, PATHSEG_LETTERS[s], fArray[n]);
                }
                case 14: 
                case 15: {
                    int n = nArray[0];
                    nArray[0] = n + 1;
                    return new AbstractSVGPathSegList.SVGPathSegLinetoVerticalItem(s, PATHSEG_LETTERS[s], fArray[n]);
                }
            }
            return null;
        }

        protected void setAnimatedValue(short[] sArray, float[] fArray) {
            int n;
            int n2 = this.itemList.size();
            int[] nArray = this.parameterIndex;
            nArray[0] = 0;
            block11: for (n = 0; n < n2 && n < sArray.length; ++n) {
                SVGPathSeg sVGPathSeg = (SVGPathSeg)this.itemList.get(n);
                if (sVGPathSeg.getPathSegType() != sArray[n]) {
                    sVGPathSeg = this.newItem(sArray[n], fArray, nArray);
                    continue;
                }
                switch (sArray[n]) {
                    case 10: 
                    case 11: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegArcItem)sVGPathSeg;
                        int n3 = nArray[0];
                        nArray[0] = n3 + 1;
                        sVGPathSegArcItem.setR1(fArray[n3]);
                        int n4 = nArray[0];
                        nArray[0] = n4 + 1;
                        sVGPathSegArcItem.setR2(fArray[n4]);
                        int n5 = nArray[0];
                        nArray[0] = n5 + 1;
                        sVGPathSegArcItem.setAngle(fArray[n5]);
                        int n6 = nArray[0];
                        nArray[0] = n6 + 1;
                        sVGPathSegArcItem.setLargeArcFlag(fArray[n6] != 0.0f);
                        int n7 = nArray[0];
                        nArray[0] = n7 + 1;
                        sVGPathSegArcItem.setSweepFlag(fArray[n7] != 0.0f);
                        int n8 = nArray[0];
                        nArray[0] = n8 + 1;
                        sVGPathSegArcItem.setX(fArray[n8]);
                        int n9 = nArray[0];
                        nArray[0] = n9 + 1;
                        sVGPathSegArcItem.setY(fArray[n9]);
                        continue block11;
                    }
                    case 1: {
                        continue block11;
                    }
                    case 6: 
                    case 7: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem)sVGPathSeg;
                        int n10 = nArray[0];
                        nArray[0] = n10 + 1;
                        sVGPathSegArcItem.setX1(fArray[n10]);
                        int n11 = nArray[0];
                        nArray[0] = n11 + 1;
                        sVGPathSegArcItem.setY1(fArray[n11]);
                        int n12 = nArray[0];
                        nArray[0] = n12 + 1;
                        sVGPathSegArcItem.setX2(fArray[n12]);
                        int n13 = nArray[0];
                        nArray[0] = n13 + 1;
                        sVGPathSegArcItem.setY2(fArray[n13]);
                        int n14 = nArray[0];
                        nArray[0] = n14 + 1;
                        sVGPathSegArcItem.setX(fArray[n14]);
                        int n15 = nArray[0];
                        nArray[0] = n15 + 1;
                        sVGPathSegArcItem.setY(fArray[n15]);
                        continue block11;
                    }
                    case 16: 
                    case 17: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegCurvetoCubicSmoothItem)sVGPathSeg;
                        int n16 = nArray[0];
                        nArray[0] = n16 + 1;
                        sVGPathSegArcItem.setX2(fArray[n16]);
                        int n17 = nArray[0];
                        nArray[0] = n17 + 1;
                        sVGPathSegArcItem.setY2(fArray[n17]);
                        int n18 = nArray[0];
                        nArray[0] = n18 + 1;
                        sVGPathSegArcItem.setX(fArray[n18]);
                        int n19 = nArray[0];
                        nArray[0] = n19 + 1;
                        sVGPathSegArcItem.setY(fArray[n19]);
                        continue block11;
                    }
                    case 8: 
                    case 9: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticItem)sVGPathSeg;
                        int n20 = nArray[0];
                        nArray[0] = n20 + 1;
                        sVGPathSegArcItem.setX1(fArray[n20]);
                        int n21 = nArray[0];
                        nArray[0] = n21 + 1;
                        sVGPathSegArcItem.setY1(fArray[n21]);
                        int n22 = nArray[0];
                        nArray[0] = n22 + 1;
                        sVGPathSegArcItem.setX(fArray[n22]);
                        int n23 = nArray[0];
                        nArray[0] = n23 + 1;
                        sVGPathSegArcItem.setY(fArray[n23]);
                        continue block11;
                    }
                    case 18: 
                    case 19: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegCurvetoQuadraticSmoothItem)sVGPathSeg;
                        int n24 = nArray[0];
                        nArray[0] = n24 + 1;
                        sVGPathSegArcItem.setX(fArray[n24]);
                        int n25 = nArray[0];
                        nArray[0] = n25 + 1;
                        sVGPathSegArcItem.setY(fArray[n25]);
                        continue block11;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem)sVGPathSeg;
                        int n26 = nArray[0];
                        nArray[0] = n26 + 1;
                        sVGPathSegArcItem.setX(fArray[n26]);
                        int n27 = nArray[0];
                        nArray[0] = n27 + 1;
                        sVGPathSegArcItem.setY(fArray[n27]);
                        continue block11;
                    }
                    case 12: 
                    case 13: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegLinetoHorizontalItem)sVGPathSeg;
                        int n28 = nArray[0];
                        nArray[0] = n28 + 1;
                        sVGPathSegArcItem.setX(fArray[n28]);
                        continue block11;
                    }
                    case 14: 
                    case 15: {
                        AbstractSVGPathSegList.SVGPathSegArcItem sVGPathSegArcItem = (AbstractSVGPathSegList.SVGPathSegLinetoVerticalItem)sVGPathSeg;
                        int n29 = nArray[0];
                        nArray[0] = n29 + 1;
                        sVGPathSegArcItem.setY(fArray[n29]);
                        continue block11;
                    }
                }
            }
            while (n < sArray.length) {
                this.appendItemImpl(this.newItem(sArray[n], fArray, nArray));
                ++n;
            }
            while (n2 > sArray.length) {
                this.removeItemImpl(--n2);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem sVGItem) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }

    public class BaseSVGPathSegList
    extends AbstractSVGPathSegList {
        protected boolean missing;
        protected boolean malformed;

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedPathData.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPathData.this.element).createSVGException(s, string, objectArray);
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedPathData.this.element.getAttributeNodeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPathData.this.defaultValue;
            }
            return attr.getValue();
        }

        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedPathData.this.changing = true;
                SVGOMAnimatedPathData.this.element.setAttributeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName, string);
            }
            finally {
                SVGOMAnimatedPathData.this.changing = false;
            }
        }

        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        protected void resetAttribute(SVGItem sVGItem) {
            super.resetAttribute(sVGItem);
            this.missing = false;
            this.malformed = false;
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            if (string == null) {
                this.missing = true;
                return;
            }
            try {
                ListBuilder listBuilder = new ListBuilder((AbstractSVGList)this);
                this.doParse(string, (ListHandler)listBuilder);
                if (listBuilder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = listBuilder.getList();
            }
            catch (ParseException parseException) {
                this.itemList = new ArrayList(1);
                this.malformed = true;
            }
        }
    }

    public class NormalizedBaseSVGPathSegList
    extends AbstractSVGNormPathSegList {
        protected boolean missing;
        protected boolean malformed;

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedPathData.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedPathData.this.element).createSVGException(s, string, objectArray);
        }

        protected String getValueAsString() throws SVGException {
            Attr attr = SVGOMAnimatedPathData.this.element.getAttributeNodeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName);
            if (attr == null) {
                return SVGOMAnimatedPathData.this.defaultValue;
            }
            return attr.getValue();
        }

        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedPathData.this.changing = true;
                SVGOMAnimatedPathData.this.element.setAttributeNS(SVGOMAnimatedPathData.this.namespaceURI, SVGOMAnimatedPathData.this.localName, string);
            }
            finally {
                SVGOMAnimatedPathData.this.changing = false;
            }
        }

        protected void revalidate() {
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            if (string == null) {
                this.missing = true;
                return;
            }
            try {
                ListBuilder listBuilder = new ListBuilder((AbstractSVGList)this);
                this.doParse(string, (ListHandler)listBuilder);
                if (listBuilder.getList() != null) {
                    this.clear(this.itemList);
                }
                this.itemList = listBuilder.getList();
            }
            catch (ParseException parseException) {
                this.itemList = new ArrayList(1);
                this.malformed = true;
            }
        }
    }
}

