/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.extension.svg;

import io.sf.carte.echosvg.ext.awt.image.LinearTransfer;
import io.sf.carte.echosvg.ext.awt.image.TransferFunction;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractColorInterpolationRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.rendered.ComponentTransferRed;
import io.sf.carte.echosvg.extension.svg.EchoSVGHistogramNormalizationFilter;
import io.sf.carte.echosvg.extension.svg.HistogramRed;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;

public class EchoSVGHistogramNormalizationFilter8Bit
extends AbstractColorInterpolationRable
implements EchoSVGHistogramNormalizationFilter {
    private float trim = 0.01f;
    protected int[] histo = null;
    protected float slope;
    protected float intercept;

    @Override
    public void setSource(Filter filter) {
        this.init(filter, null);
    }

    @Override
    public Filter getSource() {
        return (Filter)this.getSources().get(0);
    }

    @Override
    public float getTrim() {
        return this.trim;
    }

    @Override
    public void setTrim(float f) {
        this.trim = f;
        this.touch();
    }

    public EchoSVGHistogramNormalizationFilter8Bit(Filter filter, float f) {
        this.setSource(filter);
        this.setTrim(f);
    }

    public void computeHistogram(RenderContext renderContext) {
        int n;
        float f;
        if (this.histo != null) {
            return;
        }
        Filter filter = this.getSource();
        float f2 = 100.0f / filter.getWidth();
        if (f2 > (f = 100.0f / filter.getHeight())) {
            f2 = f;
        }
        AffineTransform affineTransform = AffineTransform.getScaleInstance(f2, f2);
        renderContext = new RenderContext(affineTransform, renderContext.getRenderingHints());
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        this.histo = new HistogramRed(this.convertSourceCS(renderedImage)).getHistogram();
        int n2 = (int)((double)((float)(renderedImage.getWidth() * renderedImage.getHeight()) * this.trim) + 0.5);
        int n3 = 0;
        for (n = 0; n < 255 && (n3 += this.histo[n]) < n2; ++n) {
        }
        int n4 = n;
        n3 = 0;
        for (n = 255; n > 0 && (n3 += this.histo[n]) < n2; --n) {
        }
        int n5 = n;
        this.slope = 255.0f / (float)(n5 - n4);
        this.intercept = this.slope * (float)(-n4) / 255.0f;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        RenderedImage renderedImage = this.getSource().createRendering(renderContext);
        if (renderedImage == null) {
            return null;
        }
        this.computeHistogram(renderContext);
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        TransferFunction[] transferFunctionArray = new TransferFunction[n];
        LinearTransfer linearTransfer = new LinearTransfer(this.slope, this.intercept);
        for (int i = 0; i < transferFunctionArray.length; ++i) {
            transferFunctionArray[i] = linearTransfer;
        }
        return new ComponentTransferRed(this.convertSourceCS(renderedImage), transferFunctionArray, null);
    }
}

