/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen.font.table;

import io.sf.carte.echosvg.svggen.font.table.DirectoryEntry;
import io.sf.carte.echosvg.svggen.font.table.FeatureList;
import io.sf.carte.echosvg.svggen.font.table.LigatureSubst;
import io.sf.carte.echosvg.svggen.font.table.LookupList;
import io.sf.carte.echosvg.svggen.font.table.LookupSubtable;
import io.sf.carte.echosvg.svggen.font.table.LookupSubtableFactory;
import io.sf.carte.echosvg.svggen.font.table.ScriptList;
import io.sf.carte.echosvg.svggen.font.table.SingleSubst;
import io.sf.carte.echosvg.svggen.font.table.Table;
import java.io.IOException;
import java.io.RandomAccessFile;

public class GsubTable
implements Table,
LookupSubtableFactory {
    private ScriptList scriptList;
    private FeatureList featureList;
    private LookupList lookupList;

    protected GsubTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        randomAccessFile.readInt();
        int n = randomAccessFile.readUnsignedShort();
        int n2 = randomAccessFile.readUnsignedShort();
        int n3 = randomAccessFile.readUnsignedShort();
        this.scriptList = new ScriptList(randomAccessFile, directoryEntry.getOffset() + n);
        this.featureList = new FeatureList(randomAccessFile, directoryEntry.getOffset() + n2);
        this.lookupList = new LookupList(randomAccessFile, directoryEntry.getOffset() + n3, this);
    }

    @Override
    public LookupSubtable read(int n, RandomAccessFile randomAccessFile, int n2) throws IOException {
        LookupSubtable lookupSubtable = null;
        switch (n) {
            case 1: {
                lookupSubtable = SingleSubst.read(randomAccessFile, n2);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                lookupSubtable = LigatureSubst.read(randomAccessFile, n2);
                break;
            }
            case 5: {
                break;
            }
        }
        return lookupSubtable;
    }

    @Override
    public int getType() {
        return 1196643650;
    }

    public ScriptList getScriptList() {
        return this.scriptList;
    }

    public FeatureList getFeatureList() {
        return this.featureList;
    }

    public LookupList getLookupList() {
        return this.lookupList;
    }

    public String toString() {
        return "GSUB";
    }
}

