/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen.font.table;

import io.sf.carte.echosvg.svggen.font.table.Feature;
import io.sf.carte.echosvg.svggen.font.table.FeatureRecord;
import io.sf.carte.echosvg.svggen.font.table.LangSys;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FeatureList {
    private int featureCount;
    private FeatureRecord[] featureRecords;
    private Feature[] features;

    public FeatureList(RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2;
        randomAccessFile.seek(n);
        this.featureCount = randomAccessFile.readUnsignedShort();
        this.featureRecords = new FeatureRecord[this.featureCount];
        this.features = new Feature[this.featureCount];
        for (n2 = 0; n2 < this.featureCount; ++n2) {
            this.featureRecords[n2] = new FeatureRecord(randomAccessFile);
        }
        for (n2 = 0; n2 < this.featureCount; ++n2) {
            this.features[n2] = new Feature(randomAccessFile, n + this.featureRecords[n2].getOffset());
        }
    }

    public Feature findFeature(LangSys langSys, String string) {
        if (string.length() != 4) {
            return null;
        }
        int n = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        for (int i = 0; i < this.featureCount; ++i) {
            if (this.featureRecords[i].getTag() != n || !langSys.isFeatureIndexed(i)) continue;
            return this.features[i];
        }
        return null;
    }
}

