/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen.font;

import io.sf.carte.echosvg.constants.XMLConstants;
import io.sf.carte.echosvg.svggen.font.Font;
import io.sf.carte.echosvg.svggen.font.Glyph;
import io.sf.carte.echosvg.svggen.font.Messages;
import io.sf.carte.echosvg.svggen.font.Point;
import io.sf.carte.echosvg.svggen.font.table.CmapFormat;
import io.sf.carte.echosvg.svggen.font.table.Feature;
import io.sf.carte.echosvg.svggen.font.table.FeatureTags;
import io.sf.carte.echosvg.svggen.font.table.GsubTable;
import io.sf.carte.echosvg.svggen.font.table.KernSubtable;
import io.sf.carte.echosvg.svggen.font.table.KernTable;
import io.sf.carte.echosvg.svggen.font.table.KerningPair;
import io.sf.carte.echosvg.svggen.font.table.LangSys;
import io.sf.carte.echosvg.svggen.font.table.PostTable;
import io.sf.carte.echosvg.svggen.font.table.Script;
import io.sf.carte.echosvg.svggen.font.table.ScriptTags;
import io.sf.carte.echosvg.svggen.font.table.SingleSubst;
import io.sf.carte.echosvg.util.SVGConstants;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.HashSet;

public class SVGFont
implements XMLConstants,
SVGConstants,
ScriptTags,
FeatureTags {
    static final String EOL;
    static final String PROPERTY_LINE_SEPARATOR = "line.separator";
    static final String PROPERTY_LINE_SEPARATOR_DEFAULT = "\n";
    static final int DEFAULT_FIRST = 32;
    static final int DEFAULT_LAST = 126;
    private static String QUOT_EOL;
    private static String CONFIG_USAGE;
    private static String CONFIG_SVG_BEGIN;
    private static String CONFIG_SVG_TEST_CARD_START;
    private static String CONFIG_SVG_TEST_CARD_END;
    public static final char ARG_KEY_START_CHAR = '-';
    public static final String ARG_KEY_CHAR_RANGE_LOW = "-l";
    public static final String ARG_KEY_CHAR_RANGE_HIGH = "-h";
    public static final String ARG_KEY_ID = "-id";
    public static final String ARG_KEY_ASCII = "-ascii";
    public static final String ARG_KEY_TESTCARD = "-testcard";
    public static final String ARG_KEY_AUTO_RANGE = "-autorange";
    public static final String ARG_KEY_OUTPUT_PATH = "-o";

    protected static String encodeEntities(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (string.charAt(i) == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (string.charAt(i) == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (string.charAt(i) == '\'') {
                stringBuilder.append("&apos;");
                continue;
            }
            if (string.charAt(i) == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            stringBuilder.append(string.charAt(i));
        }
        return stringBuilder.toString();
    }

    protected static String getContourAsSVGPathData(Glyph glyph, int n, int n2) {
        if (glyph.getPoint((int)n).endOfContour) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (n3 < n2) {
            Point point = glyph.getPoint(n + n3 % n2);
            Point point2 = glyph.getPoint(n + (n3 + 1) % n2);
            Point point3 = glyph.getPoint(n + (n3 + 2) % n2);
            if (n3 == 0) {
                stringBuilder.append("M").append(String.valueOf(point.x)).append(" ").append(String.valueOf(point.y));
            }
            if (point.onCurve && point2.onCurve) {
                if (point2.x == point.x) {
                    stringBuilder.append("V").append(String.valueOf(point2.y));
                } else if (point2.y == point.y) {
                    stringBuilder.append("H").append(String.valueOf(point2.x));
                } else {
                    stringBuilder.append("L").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y));
                }
                ++n3;
                continue;
            }
            if (point.onCurve && !point2.onCurve && point3.onCurve) {
                stringBuilder.append("Q").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y)).append(" ").append(String.valueOf(point3.x)).append(" ").append(String.valueOf(point3.y));
                n3 += 2;
                continue;
            }
            if (point.onCurve && !point2.onCurve && !point3.onCurve) {
                stringBuilder.append("Q").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y)).append(" ").append(String.valueOf(SVGFont.midValue(point2.x, point3.x))).append(" ").append(String.valueOf(SVGFont.midValue(point2.y, point3.y)));
                n3 += 2;
                continue;
            }
            if (!point.onCurve && !point2.onCurve) {
                stringBuilder.append("T").append(String.valueOf(SVGFont.midValue(point.x, point2.x))).append(" ").append(String.valueOf(SVGFont.midValue(point.y, point2.y)));
                ++n3;
                continue;
            }
            if (!point.onCurve && point2.onCurve) {
                stringBuilder.append("T").append(String.valueOf(point2.x)).append(" ").append(String.valueOf(point2.y));
                ++n3;
                continue;
            }
            System.out.println("drawGlyph case not catered for!!");
            break;
        }
        stringBuilder.append("Z");
        return stringBuilder.toString();
    }

    protected static String getSVGFontFaceElement(Font font) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = font.getNameTable().getRecord((short)1);
        short s = font.getHeadTable().getUnitsPerEm();
        String string2 = font.getOS2Table().getPanose().toString();
        short s2 = font.getHheaTable().getAscender();
        short s3 = font.getHheaTable().getDescender();
        int n = 0;
        stringBuilder.append("<").append("font-face").append(EOL).append("    ").append("font-family").append("=\"").append(string).append(QUOT_EOL).append("    ").append("units-per-em").append("=\"").append(s).append(QUOT_EOL).append("    ").append("panose-1").append("=\"").append(string2).append(QUOT_EOL).append("    ").append("ascent").append("=\"").append(s2).append(QUOT_EOL).append("    ").append("descent").append("=\"").append(s3).append(QUOT_EOL).append("    ").append("alphabetic").append("=\"").append(n).append('\"').append(" />").append(EOL);
        return stringBuilder.toString();
    }

    protected static void writeFontAsSVGFragment(PrintStream printStream, Font font, String string, int n, int n2, boolean bl, boolean bl2) throws Exception {
        Object object;
        LangSys langSys;
        Object object2;
        short s = font.getOS2Table().getAvgCharWidth();
        printStream.print("<");
        printStream.print("font");
        printStream.print(" ");
        if (string != null) {
            printStream.print("id");
            printStream.print("=\"");
            printStream.print(string);
            printStream.print('\"');
            printStream.print(" ");
        }
        printStream.print("horiz-adv-x");
        printStream.print("=\"");
        printStream.print(s);
        printStream.print('\"');
        printStream.print(" >");
        printStream.print(SVGFont.getSVGFontFaceElement(font));
        CmapFormat cmapFormat = null;
        if (bl2) {
            cmapFormat = font.getCmapTable().getCmapFormat((short)1, (short)0);
        } else {
            cmapFormat = font.getCmapTable().getCmapFormat((short)3, (short)1);
            if (cmapFormat == null) {
                cmapFormat = font.getCmapTable().getCmapFormat((short)3, (short)0);
            }
        }
        if (cmapFormat == null) {
            throw new Exception("Cannot find a suitable cmap table");
        }
        GsubTable gsubTable = (GsubTable)font.getTable(1196643650);
        SingleSubst singleSubst = null;
        SingleSubst singleSubst2 = null;
        SingleSubst singleSubst3 = null;
        if (gsubTable != null && (object2 = gsubTable.getScriptList().findScript("arab")) != null && (langSys = ((Script)object2).getDefaultLangSys()) != null) {
            Feature feature = gsubTable.getFeatureList().findFeature(langSys, "init");
            object = gsubTable.getFeatureList().findFeature(langSys, "medi");
            Feature feature2 = gsubTable.getFeatureList().findFeature(langSys, "fina");
            if (feature != null) {
                singleSubst = (SingleSubst)gsubTable.getLookupList().getLookup(feature, 0).getSubtable(0);
            }
            if (object != null) {
                singleSubst2 = (SingleSubst)gsubTable.getLookupList().getLookup((Feature)object, 0).getSubtable(0);
            }
            if (feature2 != null) {
                singleSubst3 = (SingleSubst)gsubTable.getLookupList().getLookup(feature2, 0).getSubtable(0);
            }
        }
        printStream.println(SVGFont.getGlyphAsSVG(font, font.getGlyph(0), 0, s, singleSubst, singleSubst2, singleSubst3, ""));
        try {
            if (n == -1) {
                n = !bl ? 32 : cmapFormat.getFirst();
            }
            if (n2 == -1) {
                n2 = !bl ? 126 : cmapFormat.getLast();
            }
            object2 = new HashSet();
            for (int i = n; i <= n2; ++i) {
                int n3 = cmapFormat.mapCharCode(i);
                if (n3 <= 0) continue;
                object2.add(n3);
                printStream.println(SVGFont.getGlyphAsSVG(font, font.getGlyph(n3), n3, s, singleSubst, singleSubst2, singleSubst3, 32 <= i && i <= 127 ? SVGFont.encodeEntities(String.valueOf((char)i)) : "&#x" + Integer.toHexString(i) + ";"));
            }
            KernTable kernTable = (KernTable)font.getTable(1801810542);
            if (kernTable != null) {
                KernSubtable kernSubtable = kernTable.getSubtable(0);
                object = (PostTable)font.getTable(1886352244);
                for (int i = 0; i < kernSubtable.getKerningPairCount(); ++i) {
                    KerningPair kerningPair = kernSubtable.getKerningPair(i);
                    if (!object2.contains(kerningPair.getLeft()) || !object2.contains(kerningPair.getRight())) continue;
                    printStream.println(SVGFont.getKerningPairAsSVG(kerningPair, (PostTable)object));
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        printStream.print("</");
        printStream.print("font");
        printStream.println(">");
    }

    protected static String getGlyphAsSVG(Font font, Glyph glyph, int n, int n2, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = 0;
        int n5 = font.getHmtxTable().getAdvanceWidth(n);
        if (n == 0) {
            stringBuilder.append("<");
            stringBuilder.append("missing-glyph");
        } else {
            stringBuilder.append("<").append("glyph").append(" ").append("unicode").append("=\"").append(string2).append('\"');
            String string3 = font.getPostTable().getGlyphName(n);
            if (string3 != null) {
                stringBuilder.append(" ").append("glyph-name").append("=\"").append(string3).append('\"');
            }
        }
        if (n5 != n2) {
            stringBuilder.append(" ").append("horiz-adv-x").append("=\"").append(n5).append('\"');
        }
        if (string != null) {
            stringBuilder.append(string);
        }
        if (glyph != null) {
            stringBuilder.append(" ").append("d").append("=\"");
            for (int i = 0; i < glyph.getPointCount(); ++i) {
                ++n4;
                if (!glyph.getPoint((int)i).endOfContour) continue;
                stringBuilder.append(SVGFont.getContourAsSVGPathData(glyph, n3, n4));
                n3 = i + 1;
                n4 = 0;
            }
            stringBuilder.append('\"');
        }
        stringBuilder.append(" />");
        SVGFont.chopUpStringBuilder(stringBuilder);
        return stringBuilder.toString();
    }

    protected static String getGlyphAsSVG(Font font, Glyph glyph, int n, int n2, SingleSubst singleSubst, SingleSubst singleSubst2, SingleSubst singleSubst3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        if (singleSubst != null) {
            n3 = singleSubst.substitute(n);
        }
        if (singleSubst2 != null) {
            n4 = singleSubst2.substitute(n);
        }
        if (singleSubst3 != null) {
            n5 = singleSubst3.substitute(n);
        }
        if (n3 != n) {
            stringBuilder.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n3), n3, n2, " arabic-form=\"initial\"", string));
            stringBuilder.append(EOL);
            bl = true;
        }
        if (n4 != n) {
            stringBuilder.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n4), n4, n2, " arabic-form=\"medial\"", string));
            stringBuilder.append(EOL);
            bl = true;
        }
        if (n5 != n) {
            stringBuilder.append(SVGFont.getGlyphAsSVG(font, font.getGlyph(n5), n5, n2, " arabic-form=\"terminal\"", string));
            stringBuilder.append(EOL);
            bl = true;
        }
        if (bl) {
            stringBuilder.append(SVGFont.getGlyphAsSVG(font, glyph, n, n2, " arabic-form=\"isolated\"", string));
        } else {
            stringBuilder.append(SVGFont.getGlyphAsSVG(font, glyph, n, n2, null, string));
        }
        return stringBuilder.toString();
    }

    protected static String getKerningPairAsSVG(KerningPair kerningPair, PostTable postTable) {
        String string = postTable.getGlyphName(kerningPair.getLeft());
        String string2 = postTable.getGlyphName(kerningPair.getRight());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append("hkern").append(" ");
        if (string == null) {
            stringBuilder.append("u1").append("=\"");
            stringBuilder.append(kerningPair.getLeft());
        } else {
            stringBuilder.append("g1").append("=\"");
            stringBuilder.append(string);
        }
        stringBuilder.append('\"').append(" ");
        if (string2 == null) {
            stringBuilder.append("u2").append("=\"");
            stringBuilder.append(kerningPair.getRight());
        } else {
            stringBuilder.append("g2").append("=\"");
            stringBuilder.append(string2);
        }
        stringBuilder.append('\"').append(" ").append("k").append("=\"");
        stringBuilder.append(-kerningPair.getValue());
        stringBuilder.append('\"').append(" />");
        return stringBuilder.toString();
    }

    protected static void writeSvgBegin(PrintStream printStream) {
        printStream.println(Messages.formatMessage(CONFIG_SVG_BEGIN, new Object[]{"-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd"}));
    }

    protected static void writeSvgDefsBegin(PrintStream printStream) {
        printStream.println("<defs >");
    }

    protected static void writeSvgDefsEnd(PrintStream printStream) {
        printStream.println("</defs>");
    }

    protected static void writeSvgEnd(PrintStream printStream) {
        printStream.println("</svg>");
    }

    protected static void writeSvgTestCard(PrintStream printStream, String string) {
        printStream.println(Messages.formatMessage(CONFIG_SVG_TEST_CARD_START, null));
        printStream.println(string);
        printStream.println(Messages.formatMessage(CONFIG_SVG_TEST_CARD_END, null));
    }

    public static void main(String[] stringArray) {
        try {
            String string = SVGFont.parseArgs(stringArray, null);
            String string2 = SVGFont.parseArgs(stringArray, ARG_KEY_CHAR_RANGE_LOW);
            String string3 = SVGFont.parseArgs(stringArray, ARG_KEY_CHAR_RANGE_HIGH);
            String string4 = SVGFont.parseArgs(stringArray, ARG_KEY_ID);
            String string5 = SVGFont.parseArgs(stringArray, ARG_KEY_ASCII);
            String string6 = SVGFont.parseArgs(stringArray, ARG_KEY_TESTCARD);
            String string7 = SVGFont.parseArgs(stringArray, ARG_KEY_OUTPUT_PATH);
            String string8 = SVGFont.parseArgs(stringArray, ARG_KEY_AUTO_RANGE);
            PrintStream printStream = null;
            FileOutputStream fileOutputStream = null;
            if (string7 != null) {
                fileOutputStream = new FileOutputStream(string7);
                printStream = new PrintStream(fileOutputStream);
            } else {
                printStream = System.out;
            }
            if (string != null) {
                Font font = Font.create(string);
                SVGFont.writeSvgBegin(printStream);
                SVGFont.writeSvgDefsBegin(printStream);
                SVGFont.writeFontAsSVGFragment(printStream, font, string4, string2 != null ? Integer.parseInt(string2) : -1, string3 != null ? Integer.parseInt(string3) : -1, string8 != null, string5 != null);
                SVGFont.writeSvgDefsEnd(printStream);
                if (string6 != null) {
                    String string9 = font.getNameTable().getRecord((short)1);
                    SVGFont.writeSvgTestCard(printStream, string9);
                }
                SVGFont.writeSvgEnd(printStream);
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            } else {
                SVGFont.usage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
            SVGFont.usage();
        }
    }

    private static void chopUpStringBuilder(StringBuilder stringBuilder) {
        if (stringBuilder.length() < 256) {
            return;
        }
        for (int i = 240; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) != ' ') continue;
            stringBuilder.setCharAt(i, '\n');
            i += 240;
        }
    }

    private static int midValue(int n, int n2) {
        return n + (n2 - n) / 2;
    }

    private static String parseArgs(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (string == null) {
                if (stringArray[i].charAt(0) == '-') continue;
                return stringArray[i];
            }
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            if (i < stringArray.length - 1 && stringArray[i + 1].charAt(0) != '-') {
                return stringArray[i + 1];
            }
            return stringArray[i];
        }
        return null;
    }

    private static void usage() {
        System.err.println(Messages.formatMessage(CONFIG_USAGE, null));
    }

    static {
        String string;
        try {
            string = System.getProperty(PROPERTY_LINE_SEPARATOR, PROPERTY_LINE_SEPARATOR_DEFAULT);
        }
        catch (SecurityException securityException) {
            string = PROPERTY_LINE_SEPARATOR_DEFAULT;
        }
        EOL = string;
        QUOT_EOL = '\"' + EOL;
        CONFIG_USAGE = "SVGFont.config.usage";
        CONFIG_SVG_BEGIN = "SVGFont.config.svg.begin";
        CONFIG_SVG_TEST_CARD_START = "SVGFont.config.svg.test.card.start";
        CONFIG_SVG_TEST_CARD_END = "SVGFont.config.svg.test.card.end";
    }
}

