/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.ext.awt.g2d.GraphicContext;
import io.sf.carte.echosvg.ext.awt.g2d.TransformStackElement;
import io.sf.carte.echosvg.svggen.AbstractSVGConverter;
import io.sf.carte.echosvg.svggen.SVGDescriptor;
import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGTransformDescriptor;
import java.util.Stack;

public class SVGTransform
extends AbstractSVGConverter {
    private static double radiansToDegrees = 57.29577951308232;

    public SVGTransform(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return new SVGTransformDescriptor(this.toSVGTransform(graphicContext));
    }

    public final String toSVGTransform(GraphicContext graphicContext) {
        return this.toSVGTransform(graphicContext.getTransformStack());
    }

    public final String toSVGTransform(TransformStackElement[] transformStackElementArray) {
        int n = transformStackElementArray.length;
        Stack<TransformStackElement> stack = new Stack<TransformStackElement>(){
            private static final long serialVersionUID = 1L;

            @Override
            public TransformStackElement push(TransformStackElement transformStackElement) {
                TransformStackElement transformStackElement2;
                if (transformStackElement.isIdentity()) {
                    transformStackElement2 = this.pop();
                } else {
                    super.push(transformStackElement);
                    transformStackElement2 = null;
                }
                return transformStackElement2;
            }

            @Override
            public TransformStackElement pop() {
                TransformStackElement transformStackElement = null;
                if (!super.empty()) {
                    transformStackElement = (TransformStackElement)super.pop();
                }
                return transformStackElement;
            }
        };
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        TransformStackElement transformStackElement = null;
        while (n2 < n) {
            n4 = n2;
            if (transformStackElement == null) {
                transformStackElement = transformStackElementArray[n2].clone();
            }
            bl = true;
            for (n3 = ++n4; n3 < n && (bl = transformStackElement.concatenate(transformStackElementArray[n3])); ++n3) {
            }
            n2 = n3;
            transformStackElement = stack.push(transformStackElement);
        }
        if (transformStackElement != null) {
            stack.push(transformStackElement);
        }
        int n5 = stack.size();
        StringBuilder stringBuilder = new StringBuilder(n5 * 8);
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuilder.append(this.convertTransform((TransformStackElement)stack.get(n2)));
            stringBuilder.append(" ");
        }
        String string = stringBuilder.toString().trim();
        return string;
    }

    final String convertTransform(TransformStackElement transformStackElement) {
        StringBuilder stringBuilder = new StringBuilder();
        double[] dArray = transformStackElement.getTransformParameters();
        switch (transformStackElement.getType().toInt()) {
            case 0: {
                if (transformStackElement.isIdentity()) break;
                stringBuilder.append("translate");
                stringBuilder.append("(");
                stringBuilder.append(this.doubleString(dArray[0]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[1]));
                stringBuilder.append(")");
                break;
            }
            case 1: {
                if (transformStackElement.isIdentity()) break;
                stringBuilder.append("rotate");
                stringBuilder.append("(");
                stringBuilder.append(this.doubleString(radiansToDegrees * dArray[0]));
                stringBuilder.append(")");
                break;
            }
            case 2: {
                if (transformStackElement.isIdentity()) break;
                stringBuilder.append("scale");
                stringBuilder.append("(");
                stringBuilder.append(this.doubleString(dArray[0]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[1]));
                stringBuilder.append(")");
                break;
            }
            case 3: {
                if (transformStackElement.isIdentity()) break;
                stringBuilder.append("matrix");
                stringBuilder.append("(");
                stringBuilder.append(1);
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[1]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[0]));
                stringBuilder.append(",");
                stringBuilder.append(1);
                stringBuilder.append(",");
                stringBuilder.append(0);
                stringBuilder.append(",");
                stringBuilder.append(0);
                stringBuilder.append(")");
                break;
            }
            case 4: {
                if (transformStackElement.isIdentity()) break;
                stringBuilder.append("matrix");
                stringBuilder.append("(");
                stringBuilder.append(this.doubleString(dArray[0]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[1]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[2]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[3]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[4]));
                stringBuilder.append(",");
                stringBuilder.append(this.doubleString(dArray[5]));
                stringBuilder.append(")");
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return stringBuilder.toString();
    }
}

