/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.svggen;

import io.sf.carte.echosvg.svggen.SVGGeneratorContext;
import io.sf.carte.echosvg.svggen.SVGGraphicObjectConverter;
import java.awt.Polygon;
import java.awt.geom.PathIterator;
import org.w3c.dom.Element;

public class SVGPolygon
extends SVGGraphicObjectConverter {
    public SVGPolygon(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    public Element toSVG(Polygon polygon) {
        Element element = this.getGeneratorContext().getDOMFactory().createElementNS("http://www.w3.org/2000/svg", "polygon");
        StringBuilder stringBuilder = new StringBuilder(" ");
        PathIterator pathIterator = polygon.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    this.appendPoint(stringBuilder, fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.appendPoint(stringBuilder, fArray[0], fArray[1]);
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new RuntimeException("invalid segmentType:" + n);
                }
            }
            pathIterator.next();
        }
        element.setAttributeNS(null, "points", stringBuilder.substring(0, stringBuilder.length() - 1));
        return element;
    }

    private void appendPoint(StringBuilder stringBuilder, float f, float f2) {
        stringBuilder.append(this.doubleString(f));
        stringBuilder.append(" ");
        stringBuilder.append(this.doubleString(f2));
        stringBuilder.append(" ");
    }
}

